/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.security;

import jadex.base.gui.CMSUpdateHandler;
import jadex.base.gui.PlatformSelectorDialog;
import jadex.base.gui.componenttree.ComponentIconCache;
import jadex.bridge.BasicComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.types.security.ISecurityService;
import jadex.bridge.service.types.security.MechanismInfo;
import jadex.bridge.service.types.security.ParameterInfo;
import jadex.commons.ICommand;
import jadex.commons.SReflect;
import jadex.commons.gui.ObjectCardLayout;
import jadex.commons.gui.PropertiesPanel;
import jadex.commons.gui.SGUI;
import jadex.commons.transformation.BasicTypeConverter;
import jadex.commons.transformation.IObjectStringConverter;
import jadex.commons.transformation.IStringObjectConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class AcquireCertificatePanel
extends JPanel {
    protected IExternalAccess ea;
    protected IExternalAccess jccaccess;
    protected ISecurityService secser;
    protected JComboBox cbmechs;
    protected ObjectCardLayout ocl;
    protected JPanel pdetail;
    protected CMSUpdateHandler cmshandler;
    protected Map<String, ICommand<Object>> updateactions;

    public AcquireCertificatePanel(IExternalAccess ea, IExternalAccess jccaccess, ISecurityService secser, CMSUpdateHandler cmshandler) {
        this.ea = ea;
        this.jccaccess = jccaccess;
        this.secser = secser;
        this.cmshandler = cmshandler;
        this.updateactions = new HashMap<String, ICommand<Object>>();
        this.ocl = new ObjectCardLayout();
        this.pdetail = new JPanel((LayoutManager)this.ocl);
        this.cbmechs = new JComboBox();
        this.cbmechs.addItem("None");
        this.cbmechs.setRenderer(new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String val = value instanceof MechanismInfo ? SReflect.getInnerClassName((Class)((MechanismInfo)value).getClazz()) : (String)value;
                return super.getListCellRendererComponent((JList<?>)list, val, index, isSelected, cellHasFocus);
            }
        });
        this.cbmechs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object o = AcquireCertificatePanel.this.cbmechs.getSelectedItem();
                MechanismInfo mi = o instanceof MechanismInfo ? (MechanismInfo)o : null;
                AcquireCertificatePanel.this.secser.setAcquisitionMechanism(mi != null ? mi.getClazz() : null);
                if (mi == null) {
                    if (AcquireCertificatePanel.this.ocl.getComponent((Object)"none") == null) {
                        JPanel p = new JPanel(new BorderLayout());
                        p.add((Component)new JLabel("Deactivated", 0), "Center");
                        AcquireCertificatePanel.this.pdetail.add((Component)p, "none");
                    }
                    AcquireCertificatePanel.this.ocl.show((Object)"none");
                } else {
                    AcquireCertificatePanel.this.createMechanismPanel(mi);
                    AcquireCertificatePanel.this.ocl.show((Object)mi.getClazz());
                }
            }
        });
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Certificate Acquisition Mechanism"));
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)this.cbmechs, "North");
        this.add((Component)this.pdetail, "Center");
    }

    protected PropertiesPanel createMechanismPanel(MechanismInfo mi) {
        Class cl = mi.getClazz();
        if (this.ocl.getComponent((Object)cl) == null) {
            PropertiesPanel pp = new PropertiesPanel();
            pp.addFullLineComponent("Settings", (JComponent)new JLabel("Settings"));
            List pis = mi.getParameterInfos();
            for (ParameterInfo pi : pis) {
                Class tcl = pi.getType();
                if (Boolean.TYPE.equals(tcl) || Boolean.class.equals((Object)tcl)) {
                    this.createCheckBox(pp, pi, mi);
                    continue;
                }
                if (IComponentIdentifier.class.equals((Object)tcl)) {
                    this.createCidChooser(pp, pi, mi, this.cmshandler);
                    continue;
                }
                this.createTextField(pp, pi, mi);
            }
            this.pdetail.add((Component)pp, cl);
        }
        return (PropertiesPanel)this.ocl.getComponent((Object)cl);
    }

    public void setParameterValue(String mechname, String name, Object value) {
        ICommand<Object> update = this.updateactions.get(mechname + "." + name);
        update.execute(value);
    }

    public void setMechanisms(List<MechanismInfo> mechanisms) {
        ItemListener[] lis = this.cbmechs.getItemListeners();
        for (int i = 0; i < lis.length; ++i) {
            this.cbmechs.removeItemListener(lis[i]);
        }
        this.cbmechs.removeAllItems();
        for (MechanismInfo mi : mechanisms) {
            this.cbmechs.addItem(mi);
        }
        this.cbmechs.addItem("None");
        for (int i = 0; i < lis.length; ++i) {
            this.cbmechs.addItemListener(lis[i]);
        }
    }

    public void setSelectedMechanism(int sel) {
        if (sel == -1) {
            this.cbmechs.setSelectedIndex(this.cbmechs.getItemCount() - 1);
        } else {
            this.cbmechs.setSelectedIndex(sel);
        }
    }

    protected void createTextField(PropertiesPanel pp, final ParameterInfo pi, final MechanismInfo mi) {
        final JTextField tf = pp.createTextField(pi.getName(), pi.getValue() == null ? "" : "" + pi.getValue(), true);
        tf.setToolTipText(pi.getDescription());
        Runnable action = new Runnable(){

            @Override
            public void run() {
                Object val = tf.getText();
                Class cl = pi.getType();
                if (!String.class.equals((Object)cl)) {
                    IStringObjectConverter conv = BasicTypeConverter.getBasicStringConverter((Class)cl);
                    if (conv == null) {
                        return;
                    }
                    try {
                        val = conv.convertString((String)val, null);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                AcquireCertificatePanel.this.secser.setAcquisitionMechanismParameterValue(mi.getClazz(), pi.getName(), val);
            }
        };
        this.addTextFieldListener(action, tf);
        this.updateactions.put(mi.getClazz().getName() + "." + pi.getName(), new ICommand<Object>(){

            public void execute(Object val) {
                IObjectStringConverter conv;
                Class cl = pi.getType();
                if (!String.class.equals((Object)cl) && (conv = BasicTypeConverter.getBasicObjectConverter((Class)cl)) != null) {
                    try {
                        val = conv.convertObject(val, null);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                tf.setText("" + val);
            }
        });
    }

    protected void createCheckBox(PropertiesPanel pp, final ParameterInfo pi, final MechanismInfo mi) {
        final JCheckBox cb = pp.createCheckBox(pi.getName(), ((Boolean)pi.getValue()).booleanValue(), true);
        cb.setToolTipText(pi.getDescription());
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcquireCertificatePanel.this.secser.setAcquisitionMechanismParameterValue(mi.getClazz(), pi.getName(), (Object)(cb.isSelected() ? Boolean.TRUE : Boolean.FALSE));
            }
        });
        this.updateactions.put(mi.getClazz().getName() + "." + pi.getName(), new ICommand<Object>(){

            public void execute(Object val) {
                cb.setSelected((Boolean)val);
            }
        });
    }

    protected void createCidChooser(PropertiesPanel pp, final ParameterInfo pi, final MechanismInfo mi, CMSUpdateHandler cmshandler) {
        final JTextField tf = new JTextField();
        tf.setToolTipText(pi.getDescription());
        JButton bu = new JButton("...");
        if (pi.getValue() != null) {
            tf.setText(((IComponentIdentifier)pi.getValue()).getPlatformPrefix());
        }
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)tf, "Center");
        p.add((Component)bu, "East");
        pp.addComponent(pi.getName(), (JComponent)p);
        final PlatformSelectorDialog csd = new PlatformSelectorDialog((Component)SGUI.getWindowParent((Component)this), this.ea, this.jccaccess, cmshandler, null, new ComponentIconCache(this.ea));
        bu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IComponentIdentifier cid = csd.selectAgent(null);
                if (cid != null) {
                    AcquireCertificatePanel.this.secser.setAcquisitionMechanismParameterValue(mi.getClazz(), pi.getName(), (Object)cid);
                }
            }
        });
        this.addTextFieldListener(new Runnable(){

            @Override
            public void run() {
                String name = tf.getText();
                BasicComponentIdentifier cid = name.length() > 0 ? new BasicComponentIdentifier(name) : null;
                AcquireCertificatePanel.this.secser.setAcquisitionMechanismParameterValue(mi.getClazz(), pi.getName(), (Object)cid);
            }
        }, tf);
        this.updateactions.put(mi.getClazz().getName() + "." + pi.getName(), new ICommand<Object>(){

            public void execute(Object val) {
                tf.setText(val == null ? "" : ((IComponentIdentifier)val).getName());
            }
        });
    }

    protected void addTextFieldListener(final Runnable action, JTextField tf) {
        tf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.run();
            }
        });
        tf.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                action.run();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }
}

