/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.security;

import jadex.commons.SUtil;
import jadex.commons.gui.PropertiesPanel;
import jadex.commons.gui.SGUI;
import jadex.commons.security.SSecurity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class CertificatePanel
extends JPanel {
    protected Certificate[] certs;

    public CertificatePanel(Certificate[] certs) {
        this.certs = certs;
        JTabbedPane tp = new JTabbedPane();
        for (Certificate cert : certs) {
            PropertiesPanel pp = new PropertiesPanel();
            String key = cert.getPublicKey().getAlgorithm();
            int len = SSecurity.getKeyLength((Key)cert.getPublicKey());
            if (len != -1) {
                key = key + " (" + len + " bits)";
            }
            int i = 0;
            if (cert instanceof X509Certificate) {
                ++i;
                try {
                    final X509Certificate xcert = (X509Certificate)cert;
                    pp.createTextField("Version", "" + xcert.getVersion());
                    pp.createTextField("Subject", "" + xcert.getSubjectDN());
                    pp.createTextField("Issuer", "" + xcert.getIssuerDN());
                    pp.createTextField("Serial number", "" + SUtil.hex((byte[])xcert.getSerialNumber().toByteArray(), (String)" ", (int)2));
                    pp.createTextField("Validity duration", ((DateFormat)SUtil.SDF.get()).format(xcert.getNotBefore()) + " - " + ((DateFormat)SUtil.SDF.get()).format(xcert.getNotAfter()));
                    pp.createTextField("Public key", key);
                    pp.createTextField("Signature algoritm", xcert.getSigAlgName());
                    pp.createTextField("Fingerprint SHA-1", SSecurity.getHexMessageDigest((byte[])xcert.getEncoded(), (String)"SHA1"));
                    pp.createTextField("Fingerprint MD5", SSecurity.getHexMessageDigest((byte[])xcert.getEncoded(), (String)"MD5"));
                    JButton but = pp.createButton("PEM Encoding", "Show");
                    but.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JTextArea ta = new JTextArea();
                            ta.setEditable(false);
                            ta.setText(SSecurity.getCertificateText((Certificate)xcert));
                            final JDialog dia = new JDialog((Frame)null, "PEM Encoding", false);
                            JButton bok = new JButton("OK");
                            JPanel ps = new JPanel(new GridBagLayout());
                            ps.add((Component)bok, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
                            dia.getContentPane().add((Component)ta, "Center");
                            dia.getContentPane().add((Component)ps, "South");
                            final boolean[] ok = new boolean[1];
                            bok.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    ok[0] = true;
                                    dia.dispose();
                                }
                            });
                            dia.pack();
                            dia.setLocation(SGUI.calculateMiddlePosition((Window)SGUI.getWindowParent((Component)CertificatePanel.this), (Window)dia));
                            dia.setVisible(true);
                        }
                    });
                    tp.addTab("Certificate " + i, (Component)pp);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            pp.createTextField("Type", "" + cert.getType());
            pp.createTextField("Public key", key);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(tp), "Center");
    }
}

