/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.security;

import jadex.commons.ICommand;
import jadex.commons.SUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class PasswordTablePanel
extends JPanel {
    protected DefaultTableModel tmodel;

    public PasswordTablePanel(String name, String[] colnames, final ICommand addaction, final ICommand remaction) {
        JPanel premote = new JPanel(new BorderLayout());
        premote.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), name));
        this.tmodel = new DefaultTableModel(colnames, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }
        };
        final JTable table = new JTable(this.tmodel);
        premote.add((Component)new JScrollPane(table), "Center");
        final JPopupMenu popup = new JPopupMenu();
        if (remaction != null) {
            popup.add(new JMenuItem(new AbstractAction("Remove entry"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int sel = table.getSelectedRow();
                    if (sel != -1) {
                        remaction.execute((Object)new String[]{(String)PasswordTablePanel.this.tmodel.getValueAt(sel, 0), null});
                    }
                }
            }));
        }
        final JTextField tfname = new JTextField();
        final JTextField tfpass = new JTextField();
        JButton buadd = new JButton("Add");
        buadd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (addaction != null) {
                    addaction.execute((Object)new String[]{tfname.getText(), tfpass.getText()});
                }
            }
        });
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseClicked(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mouseClicked(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                } else {
                    int sel = table.getSelectedRow();
                    if (sel != -1) {
                        tfname.setText((String)PasswordTablePanel.this.tmodel.getValueAt(sel, 0));
                        tfpass.setText((String)PasswordTablePanel.this.tmodel.getValueAt(sel, 1));
                    }
                }
            }
        });
        this.tmodel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0 && addaction != null) {
                    addaction.execute((Object)new String[]{(String)PasswordTablePanel.this.tmodel.getValueAt(e.getFirstRow(), 0), (String)PasswordTablePanel.this.tmodel.getValueAt(e.getFirstRow(), 1)});
                    tfpass.setText((String)PasswordTablePanel.this.tmodel.getValueAt(e.getFirstRow(), 1));
                }
            }
        });
        JPanel padd = new JPanel(new GridBagLayout());
        padd.add((Component)new JLabel(colnames[0]), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
        padd.add((Component)tfname, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
        padd.add((Component)new JLabel(colnames[1]), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
        padd.add((Component)tfpass, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
        padd.add((Component)buadd, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)premote, "Center");
        this.add((Component)padd, "South");
    }

    public void update(Map<String, String> passwords) {
        for (int i = this.tmodel.getRowCount() - 1; i >= 0; --i) {
            String key = (String)this.tmodel.getValueAt(i, 0);
            if (passwords.containsKey(key)) {
                String newval = passwords.remove(this.tmodel.getValueAt(i, 0));
                if (SUtil.equals((Object)this.tmodel.getValueAt(i, 1), (Object)newval)) continue;
                this.tmodel.setValueAt(newval, i, 1);
                continue;
            }
            this.tmodel.removeRow(i);
        }
        for (String key : passwords.keySet()) {
            this.tmodel.addRow(new Object[]{key, passwords.get(key)});
        }
    }
}

