/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.security;

import jadex.base.gui.PlatformSelectorDialog;
import jadex.base.gui.componenttree.ComponentIconCache;
import jadex.base.gui.componentviewer.IServiceViewerPanel;
import jadex.base.gui.idtree.IdTableModel;
import jadex.base.gui.jtable.ComponentIdentifierRenderer;
import jadex.base.gui.plugin.IControlCenter;
import jadex.bridge.BasicComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.IService;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.security.ISecurityService;
import jadex.bridge.service.types.security.KeyStoreEntry;
import jadex.bridge.service.types.security.MechanismInfo;
import jadex.commons.ICommand;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.SUtil;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.gui.JSplitPanel;
import jadex.commons.gui.PropertiesPanel;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.future.SwingResultListener;
import jadex.commons.security.SSecurity;
import jadex.tools.jcc.JCCResultListener;
import jadex.tools.security.AcquireCertificatePanel;
import jadex.tools.security.CertificatePanel;
import jadex.tools.security.DualVirtualNamesPanel;
import jadex.tools.security.PasswordTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.cert.Certificate;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;

public class SecuritySettingsPanel
implements IServiceViewerPanel {
    protected ISecurityService secservice;
    protected JCheckBox cbusepass;
    protected JPasswordField tfpass;
    protected JCheckBox cbshowchars;
    protected JCheckBox cbtrulan;
    protected PasswordTablePanel ppp;
    protected PasswordTablePanel npp;
    protected JComponent inner;
    protected JTextField tfstorepath;
    protected JTextField tfstorepass;
    protected JTextField tfkeypass;
    protected JSplitPanel sph;
    protected JSplitPanel spv;
    protected Runnable updateact;
    protected JTextField tfvaldur;

    public IFuture<Void> init(final IControlCenter jcc, IService service) {
        final Future ret = new Future();
        this.secservice = (ISecurityService)service;
        this.inner = new JTabbedPane();
        this.cbusepass = new JCheckBox("Use password");
        final JLabel lbpass = new JLabel("Password");
        this.tfpass = new JPasswordField(10);
        final char echo = this.tfpass.getEchoChar();
        final JButton buapply = new JButton("Apply");
        this.cbshowchars = new JCheckBox("Show characters");
        this.cbusepass.setToolTipText("Enable / disable password protection of the platform.");
        lbpass.setToolTipText("The platform password");
        this.tfpass.setToolTipText("The platform password (<enter> to set new password)");
        buapply.setToolTipText("Set new password");
        this.cbshowchars.setToolTipText("Show / hide password characters in gui");
        this.cbtrulan = new JCheckBox("Trust platforms from the same network (caution)");
        this.cbtrulan.setToolTipText("The trusted networks are not password protected per default. Enter password to disable spoofing.");
        this.cbtrulan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecuritySettingsPanel.this.secservice.setTrustedLanMode(SecuritySettingsPanel.this.cbtrulan.isSelected());
            }
        });
        this.tfvaldur = new JTextField(10);
        this.tfvaldur.setToolTipText("Default validity duration of messages");
        JButton buvaldur = new JButton("Apply");
        buvaldur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    long val = Long.parseLong(SecuritySettingsPanel.this.tfvaldur.getText());
                    SecuritySettingsPanel.this.secservice.setValidityDuration(val * 60000L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.tfstorepath = new JTextField(10);
        JButton bustpa = new JButton("...");
        this.tfstorepass = new JTextField(10);
        this.tfkeypass = new JTextField(10);
        JButton bustoreset = new JButton("Set");
        bustpa.addActionListener(new ActionListener(){
            JFileChooser fc;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.fc == null) {
                    this.fc = new JFileChooser(".");
                }
                this.fc.showOpenDialog(SecuritySettingsPanel.this.inner);
                File sel = this.fc.getSelectedFile();
                if (sel != null && sel.exists()) {
                    try {
                        SecuritySettingsPanel.this.tfstorepath.setText(SUtil.convertPathToRelative((String)sel.getAbsolutePath()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        bustoreset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String p = SecuritySettingsPanel.this.tfstorepath.getText();
                String relp = SUtil.convertPathToRelative((String)p);
                SecuritySettingsPanel.this.secservice.setKeystoreInfo(relp, SecuritySettingsPanel.this.tfstorepass.getText(), SecuritySettingsPanel.this.tfkeypass.getText());
            }
        });
        final JPanel pdetails = new JPanel(new BorderLayout());
        final JTable ktt = new JTable();
        IdTableModel<String, KeyStoreEntry> kttm = new IdTableModel<String, KeyStoreEntry>(new String[]{"Alias", "Type", "Protected", "Expired", "Algorithm", "Validity", "Creation"}, new Class[]{String.class, String.class, Boolean.class, Boolean.class, String.class, String.class, String.class}, ktt){

            public Object getValueAt(KeyStoreEntry obj, int column) {
                Object ret = obj;
                if (column == 0) {
                    ret = obj.getAlias();
                } else if (column == 1) {
                    ret = obj.getType();
                } else if (column == 2) {
                    ret = obj.isProtected();
                } else if (column == 3) {
                    ret = obj.isExpired();
                } else if (column == 4) {
                    ret = obj.getAlgorithm();
                } else if (column == 5) {
                    ret = ((DateFormat)SUtil.SDF2.get()).format(new Date(obj.getFrom())) + " - " + ((DateFormat)SUtil.SDF2.get()).format(new Date(obj.getTo()));
                } else if (column == 6) {
                    ret = ((DateFormat)SUtil.SDF.get()).format(new Date(obj.getDate()));
                }
                return ret;
            }
        };
        ktt.setModel((TableModel)kttm);
        ktt.getSelectionModel().addListSelectionListener(new ListSelectionListener((IdTableModel)kttm){
            final /* synthetic */ IdTableModel val$kttm;
            {
                this.val$kttm = idTableModel;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                pdetails.removeAll();
                int idx = ktt.getSelectedRow();
                if (idx != -1) {
                    KeyStoreEntry kse = (KeyStoreEntry)this.val$kttm.getValueAt(idx, -1);
                    CertificatePanel ct = new CertificatePanel(kse.getCertificates());
                    pdetails.add((Component)ct, "Center");
                }
                pdetails.invalidate();
                SecuritySettingsPanel.this.inner.invalidate();
                SecuritySettingsPanel.this.inner.repaint();
            }
        });
        this.updateact = new Runnable((IdTableModel)kttm, jcc){
            final /* synthetic */ IdTableModel val$kttm;
            final /* synthetic */ IControlCenter val$jcc;
            {
                this.val$kttm = idTableModel;
                this.val$jcc = iControlCenter;
            }

            @Override
            public void run() {
                SecuritySettingsPanel.this.secservice.getKeystoreDetails().addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<Map<String, KeyStoreEntry>>(){

                    public void resultAvailable(Map<String, KeyStoreEntry> infos) {
                        val$kttm.removeAll();
                        Iterator<String> it = infos.keySet().iterator();
                        while (it.hasNext()) {
                            KeyStoreEntry kse = infos.get(it.next());
                            val$kttm.addObject((Object)kse.getAlias(), (Object)kse);
                        }
                    }

                    public void exceptionOccurred(Exception exception) {
                        val$jcc.setStatusText("Exception during refresh: " + exception.getMessage());
                    }
                }));
            }
        };
        JScrollPane sktt = new JScrollPane(ktt);
        MouseAdapter ma = new MouseAdapter((IdTableModel)kttm, jcc){
            JFileChooser chls;
            final /* synthetic */ IdTableModel val$kttm;
            final /* synthetic */ IControlCenter val$jcc;
            {
                this.val$kttm = idTableModel;
                this.val$jcc = iControlCenter;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.popup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.popup(e);
            }

            protected void popup(MouseEvent e) {
                if (this.chls == null) {
                    this.chls = new JFileChooser(".");
                    this.chls.setFileFilter(new FileFilter(){

                        @Override
                        public String getDescription() {
                            return ".cer";
                        }

                        @Override
                        public boolean accept(File f) {
                            return !f.isDirectory() && f.getName().endsWith(".cer");
                        }
                    });
                }
                if (e.isPopupTrigger()) {
                    int row = ktt.rowAtPoint(e.getPoint());
                    JPopupMenu menu = new JPopupMenu("Key store menu");
                    if (row != -1) {
                        ktt.getSelectionModel().setSelectionInterval(row, row);
                        final KeyStoreEntry kse = (KeyStoreEntry)this.val$kttm.getValueAt(row, -1);
                        menu.add(new AbstractAction("Delete " + kse.getType()){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                SecuritySettingsPanel.this.secservice.removeKeyStoreEntry(kse.getAlias());
                                SecuritySettingsPanel.this.updateact.run();
                            }
                        });
                        menu.add(new AbstractAction("Export certificate ..."){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String text = SSecurity.getCertificateText((Certificate)kse.getCertificates()[0]);
                                if (0 == chls.showSaveDialog(SecuritySettingsPanel.this.inner)) {
                                    BufferedWriter out = null;
                                    try {
                                        File f = chls.getSelectedFile();
                                        if (f.getName().indexOf(".") == -1) {
                                            f = new File(f.getParent(), f.getName() + ".cer");
                                        }
                                        out = new BufferedWriter(new FileWriter(f));
                                        out.write(text);
                                    }
                                    catch (IOException iOException) {
                                    }
                                    finally {
                                        try {
                                            out.close();
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                            }
                        });
                    }
                    menu.add(new AbstractAction("Import certificate from file ..."){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PropertiesPanel pp = new PropertiesPanel();
                            JPanel ppl = new JPanel(new BorderLayout());
                            final JTextField tfentry = new JTextField();
                            JButton busep = new JButton("...");
                            ppl.add((Component)tfentry, "Center");
                            ppl.add((Component)busep, "East");
                            pp.addComponent("Entry name", (JComponent)ppl);
                            busep.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    PlatformSelectorDialog psd = new PlatformSelectorDialog((Component)SecuritySettingsPanel.this.inner, val$jcc.getPlatformAccess(), val$jcc.getJCCAccess(), val$jcc.getCMSHandler(), val$jcc.getPropertyHandler(), new ComponentIconCache(val$jcc.getJCCAccess()));
                                    IComponentIdentifier cid = psd.selectAgent(null);
                                    if (cid != null) {
                                        tfentry.setText(cid.getPlatformPrefix());
                                    }
                                }
                            });
                            JPanel pfi = new JPanel(new BorderLayout());
                            final JTextField tffile = new JTextField();
                            JButton busel = new JButton("...");
                            pfi.add((Component)tffile, "Center");
                            pfi.add((Component)busel, "East");
                            pp.addComponent("File", (JComponent)pfi);
                            busel.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (0 == chls.showOpenDialog(SecuritySettingsPanel.this.inner)) {
                                        try {
                                            tffile.setText(chls.getSelectedFile().getCanonicalPath());
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                            });
                            if (SGUI.createDialog((String)"Import Certificate", (JComponent)pp, (JComponent)SecuritySettingsPanel.this.inner)) {
                                String alias = tfentry.getText();
                                String fname = tffile.getText();
                                if (alias.length() > 0 && fname.length() > 0) {
                                    try {
                                        final String name = tfentry.getText();
                                        FileInputStream fis = new FileInputStream(fname);
                                        SecuritySettingsPanel.this.secservice.addPlatformCertificate((IComponentIdentifier)new BasicComponentIdentifier(name), SSecurity.createCertificate((InputStream)fis)).addResultListener((IResultListener)new IResultListener<Void>(){

                                            public void resultAvailable(Void result) {
                                                val$jcc.setStatusText("Successfully imported certificate for: " + name);
                                            }

                                            public void exceptionOccurred(Exception exception) {
                                                val$jcc.setStatusText("Problem while importing certificate for: " + name + " " + exception.getMessage());
                                            }
                                        });
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            }
                        }
                    });
                    menu.add(new AbstractAction("Import certificate from platform ..."){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PropertiesPanel pp = new PropertiesPanel();
                            JPanel ppl = new JPanel(new BorderLayout());
                            final JTextField tfentry = new JTextField();
                            tfentry.setEditable(false);
                            JButton busep = new JButton("...");
                            ppl.add((Component)tfentry, "Center");
                            ppl.add((Component)busep, "East");
                            pp.addComponent("Entry name", (JComponent)ppl);
                            final IComponentIdentifier[] cid = new IComponentIdentifier[1];
                            busep.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    PlatformSelectorDialog psd = new PlatformSelectorDialog((Component)SecuritySettingsPanel.this.inner, val$jcc.getPlatformAccess(), val$jcc.getJCCAccess(), val$jcc.getCMSHandler(), val$jcc.getPropertyHandler(), new ComponentIconCache(val$jcc.getJCCAccess()));
                                    cid[0] = psd.selectAgent(null);
                                    if (cid[0] != null) {
                                        tfentry.setText(cid[0].getPlatformPrefix());
                                        tfentry.setToolTipText(ComponentIdentifierRenderer.getTooltipText((IComponentIdentifier)cid[0]));
                                    }
                                }
                            });
                            if (SGUI.createDialog((String)"Import Certificate", (JComponent)pp, (JComponent)SecuritySettingsPanel.this.inner) && cid[0] != null) {
                                try {
                                    SServiceProvider.getService((IExternalAccess)val$jcc.getJCCAccess(), (IComponentIdentifier)cid[0].getRoot(), ISecurityService.class).addResultListener((IResultListener)new IResultListener<ISecurityService>(){

                                        public void resultAvailable(ISecurityService ss) {
                                            ss.getPlatformCertificate(null).addResultListener((IResultListener)new IResultListener<Certificate>(){

                                                public void resultAvailable(Certificate cert) {
                                                    SecuritySettingsPanel.this.secservice.addPlatformCertificate(cid[0], cert).addResultListener((IResultListener)new IResultListener<Void>(){

                                                        public void resultAvailable(Void result) {
                                                            val$jcc.setStatusText("Successfully imported certificate for: " + cid[0].getPlatformPrefix());
                                                        }

                                                        public void exceptionOccurred(Exception exception) {
                                                            val$jcc.setStatusText("Problem while importing certificate for: " + cid[0].getPlatformPrefix() + " " + exception.getMessage());
                                                        }
                                                    });
                                                }

                                                public void exceptionOccurred(Exception exception) {
                                                    val$jcc.setStatusText("Problem while importing certificate for: " + cid[0].getPlatformPrefix() + " " + exception.getMessage());
                                                }
                                            });
                                        }

                                        public void exceptionOccurred(Exception exception) {
                                            val$jcc.setStatusText("Problem while importing certificate for: " + cid[0].getPlatformPrefix() + " " + exception.getMessage());
                                        }
                                    });
                                }
                                catch (Exception ex) {
                                    val$jcc.setStatusText("Problem while importing certificate for: " + cid[0].getPlatformPrefix() + " " + ex.getMessage());
                                }
                            }
                        }
                    });
                    menu.add(new AbstractAction("Generate certificate ..."){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PropertiesPanel pp = new PropertiesPanel();
                            JPanel ppl = new JPanel(new BorderLayout());
                            final JTextField tfentry = new JTextField();
                            JButton busep = new JButton("...");
                            ppl.add((Component)tfentry, "Center");
                            ppl.add((Component)busep, "East");
                            pp.addComponent("Entry name", (JComponent)ppl);
                            JTextField tfdn = pp.createTextField("Distinguished name ", "CN=CKS Self Signed Cert", true);
                            JTextField tfdur = pp.createTextField("Validity duration (days)", "365", true);
                            JTextField tfalg = pp.createTextField("Algorithm", "MD5withRSA", true);
                            busep.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    PlatformSelectorDialog psd = new PlatformSelectorDialog((Component)SecuritySettingsPanel.this.inner, val$jcc.getPlatformAccess(), val$jcc.getJCCAccess(), val$jcc.getCMSHandler(), val$jcc.getPropertyHandler(), new ComponentIconCache(val$jcc.getJCCAccess()));
                                    IComponentIdentifier cid = psd.selectAgent(null);
                                    if (cid != null) {
                                        tfentry.setText(cid.getPlatformPrefix());
                                    }
                                }
                            });
                            try {
                                if (SGUI.createDialog((String)"Generate Certificate", (JComponent)pp, (JComponent)SecuritySettingsPanel.this.inner)) {
                                    final String name = tfentry.getText();
                                    String dn = tfdn.getText();
                                    int dur = Integer.parseInt(tfdur.getText());
                                    String alg = tfalg.getText();
                                    KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
                                    gen.initialize(1024);
                                    KeyPair keys = gen.generateKeyPair();
                                    Certificate cert = SSecurity.generateCertificate((String)dn, (KeyPair)keys, (int)dur, (String)alg);
                                    SecuritySettingsPanel.this.secservice.addPlatformCertificate((IComponentIdentifier)new BasicComponentIdentifier(name), cert).addResultListener((IResultListener)new IResultListener<Void>(){

                                        public void resultAvailable(Void result) {
                                            val$jcc.setStatusText("Successfully generated certificate for: " + name);
                                        }

                                        public void exceptionOccurred(Exception exception) {
                                            val$jcc.setStatusText("Problem while generating certificate for: " + name + " " + exception.getMessage());
                                        }
                                    });
                                }
                            }
                            catch (Exception ex) {
                                val$jcc.setStatusText("Error during certificate generation: " + ex.getMessage());
                            }
                        }
                    });
                    menu.add(new AbstractAction("Generate key pair ..."){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PropertiesPanel pp = new PropertiesPanel();
                            JPanel ppl = new JPanel(new BorderLayout());
                            final JTextField tfentry = new JTextField();
                            JButton busep = new JButton("...");
                            ppl.add((Component)tfentry, "Center");
                            ppl.add((Component)busep, "East");
                            pp.addComponent("Entry name", (JComponent)ppl);
                            busep.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    PlatformSelectorDialog psd = new PlatformSelectorDialog((Component)SecuritySettingsPanel.this.inner, val$jcc.getPlatformAccess(), val$jcc.getJCCAccess(), val$jcc.getCMSHandler(), val$jcc.getPropertyHandler(), new ComponentIconCache(val$jcc.getJCCAccess()));
                                    IComponentIdentifier cid = psd.selectAgent(null);
                                    if (cid != null) {
                                        tfentry.setText(cid.getPlatformPrefix());
                                    }
                                }
                            });
                            JTextField tfalg = pp.createTextField("Algorithm ", "RSA", true);
                            JTextField tfsize = pp.createTextField("Keysize", "2048", true);
                            JTextField tfval = pp.createTextField("Validity (days)", "365", true);
                            JTextField tfpass = pp.createTextField("Password", "", true);
                            try {
                                if (SGUI.createDialog((String)"Generate Key Pair", (JComponent)pp, (JComponent)SecuritySettingsPanel.this.inner)) {
                                    final String name = tfentry.getText();
                                    String alg = tfalg.getText();
                                    int size = Integer.parseInt(tfsize.getText());
                                    String pass = tfalg.getText();
                                    int val = Integer.parseInt(tfval.getText());
                                    SecuritySettingsPanel.this.secservice.createKeyPair((IComponentIdentifier)new BasicComponentIdentifier(name), alg, size, pass.length() > 0 ? pass : null, val).addResultListener((IResultListener)new IResultListener<Void>(){

                                        public void resultAvailable(Void result) {
                                            val$jcc.setStatusText("Successfully generated key pair for: " + name);
                                        }

                                        public void exceptionOccurred(Exception exception) {
                                            val$jcc.setStatusText("Problem while generating key pair for: " + name + " " + exception.getMessage());
                                        }
                                    });
                                }
                            }
                            catch (Exception ex) {
                                val$jcc.setStatusText("Error during certificate generation: " + ex.getMessage());
                            }
                        }
                    });
                    menu.show(ktt, e.getX(), e.getY());
                }
            }
        };
        ktt.addMouseListener(ma);
        ktt.getTableHeader().addMouseListener(ma);
        sktt.addMouseListener(ma);
        JButton bureload = new JButton("Reload");
        bureload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecuritySettingsPanel.this.updateact.run();
            }
        });
        this.updateact.run();
        final AcquireCertificatePanel acp = new AcquireCertificatePanel(jcc.getPlatformAccess(), jcc.getJCCAccess(), this.secservice, jcc.getCMSHandler());
        this.secservice.getAcquisitionMechanisms().addResultListener((IResultListener)new SwingDefaultResultListener<List<MechanismInfo>>(){

            public void customResultAvailable(List<MechanismInfo> result) {
                acp.setMechanisms(result);
                SecuritySettingsPanel.this.secservice.getSelectedAcquisitionMechanism().addResultListener((IResultListener)new SwingDefaultResultListener<Integer>(){

                    public void customResultAvailable(Integer sel) {
                        acp.setSelectedMechanism(sel);
                    }
                });
            }
        });
        JPanel plocal = new JPanel(new GridBagLayout());
        plocal.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Local Password Settings"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        plocal.add((Component)this.cbusepass, gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        plocal.add((Component)lbpass, gbc);
        plocal.add((Component)this.tfpass, gbc);
        plocal.add((Component)buapply, gbc);
        gbc.weightx = 1.0;
        plocal.add((Component)this.cbshowchars, gbc);
        ++gbc.gridy;
        JLabel l = new JLabel("Validity duration [mins]");
        l.setToolTipText("Validity duration of messages, i.e. older messages are not accepted.");
        plocal.add((Component)l, new GridBagConstraints(0, gbc.gridy, 1, 1, 0.0, 0.0, 17, 3, gbc.insets, 0, 0));
        plocal.add((Component)this.tfvaldur, new GridBagConstraints(1, gbc.gridy, 1, 1, 0.0, 0.0, 17, 3, gbc.insets, 0, 0));
        plocal.add((Component)buvaldur, new GridBagConstraints(2, gbc.gridy, 1, 1, 0.0, 0.0, 17, 3, gbc.insets, 0, 0));
        ++gbc.gridy;
        plocal.add((Component)new JPanel(), new GridBagConstraints(0, gbc.gridy, 1, 1, 0.0, 1.0, 17, 1, gbc.insets, 0, 0));
        JPanel slocal = new JPanel(new GridBagLayout());
        slocal.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Local Keystore Settings"));
        int x = 0;
        int y = 0;
        Insets in = new Insets(2, 2, 2, 2);
        slocal.add((Component)new JLabel("Key store location: "), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 3, in, 0, 0));
        slocal.add((Component)this.tfstorepath, new GridBagConstraints(x++, y, 1, 1, 1.0, 0.0, 17, 1, in, 0, 0));
        slocal.add((Component)bustpa, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 3, in, 0, 0));
        slocal.add((Component)new JLabel("Key store password:"), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 3, in, 0, 0));
        slocal.add((Component)this.tfstorepass, new GridBagConstraints(x++, y, 1, 1, 1.0, 0.0, 17, 1, in, 0, 0));
        slocal.add((Component)new JLabel("Key password:"), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 3, in, 0, 0));
        slocal.add((Component)this.tfkeypass, new GridBagConstraints(x++, y, 1, 1, 1.0, 0.0, 17, 1, in, 0, 0));
        slocal.add((Component)bustoreset, new GridBagConstraints(x++, y++, 1, 1, 0.0, 0.0, 17, 3, in, 0, 0));
        slocal.add((Component)sktt, new GridBagConstraints(0, y++, 8, 1, 1.0, 1.0, 17, 1, in, 0, 0));
        slocal.add((Component)bureload, new GridBagConstraints(0, y++, 8, 1, 1.0, 0.0, 13, 0, in, 0, 0));
        ICommand paddrem = new ICommand(){

            public void execute(Object args) {
                String[] tmp = (String[])args;
                SecuritySettingsPanel.this.secservice.setPlatformPassword((IComponentIdentifier)new BasicComponentIdentifier(tmp[0]), tmp[1]).addResultListener((IResultListener)new JCCResultListener<Void>(jcc){

                    @Override
                    public void customResultAvailable(Void result) {
                    }
                });
            }
        };
        ICommand naddrem = new ICommand(){

            public void execute(Object args) {
                String[] tmp = (String[])args;
                SecuritySettingsPanel.this.secservice.setNetworkPassword(tmp[0], tmp[1]).addResultListener((IResultListener)new JCCResultListener<Void>(jcc){

                    @Override
                    public void customResultAvailable(Void result) {
                    }
                });
            }
        };
        this.ppp = new PasswordTablePanel("Remote Platform Password Settings", new String[]{"Platform Name", "Password"}, paddrem, paddrem);
        this.npp = new PasswordTablePanel("Network Password Settings", new String[]{"Network Name", "Password"}, naddrem, naddrem);
        this.npp.add((Component)this.cbtrulan, "North");
        this.sph = new JSplitPanel(1);
        this.sph.setOneTouchExpandable(true);
        this.sph.setDividerLocation(0.5);
        this.sph.add((Component)pdetails);
        this.sph.add((Component)new JScrollPane(acp));
        this.spv = new JSplitPanel(0);
        this.spv.setOneTouchExpandable(true);
        this.spv.setDividerLocation(0.5);
        this.spv.add((Component)slocal);
        this.spv.add((Component)this.sph);
        ((JTabbedPane)this.inner).addTab("Password", plocal);
        ((JTabbedPane)this.inner).addTab("Key Store", (Component)this.spv);
        ((JTabbedPane)this.inner).addTab("Remote Passwords", this.ppp);
        ((JTabbedPane)this.inner).addTab("Network Names", this.npp);
        ((JTabbedPane)this.inner).addTab("Virtual Platform Names", new DualVirtualNamesPanel(jcc.getPlatformAccess(), jcc.getJCCAccess(), this.secservice, jcc.getCMSHandler()));
        buapply.setEnabled(false);
        this.cbusepass.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                final boolean usepass = SecuritySettingsPanel.this.cbusepass.isSelected();
                SecuritySettingsPanel.this.secservice.setUsePassword(usepass).addResultListener((IResultListener)new JCCResultListener<Void>(jcc){

                    @Override
                    public void customResultAvailable(Void result) {
                        lbpass.setEnabled(usepass);
                        SecuritySettingsPanel.this.tfpass.setEnabled(usepass);
                        SecuritySettingsPanel.this.cbshowchars.setEnabled(usepass);
                    }
                });
            }
        });
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newpass = new String(SecuritySettingsPanel.this.tfpass.getPassword());
                SecuritySettingsPanel.this.secservice.setLocalPassword(newpass).addResultListener((IResultListener)new JCCResultListener<Void>(jcc){

                    @Override
                    public void customResultAvailable(Void result) {
                        buapply.setEnabled(false);
                    }
                });
            }
        };
        buapply.addActionListener(al);
        this.tfpass.addActionListener(al);
        this.tfpass.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                buapply.setEnabled(true);
            }
        });
        this.cbshowchars.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SecuritySettingsPanel.this.tfpass.setEchoChar(SecuritySettingsPanel.this.cbshowchars.isSelected() ? (char)'\u0000' : echo);
            }
        });
        ISubscriptionIntermediateFuture fut = this.secservice.subscribeToEvents();
        fut.addResultListener((IResultListener)new IIntermediateResultListener<jadex.commons.ChangeEvent<Object>>(){

            public void intermediateResultAvailable(final jadex.commons.ChangeEvent<Object> event) {
                if (event == null) {
                    ret.setResult(null);
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if ("usepass".equals(event.getType())) {
                            SecuritySettingsPanel.this.cbusepass.setSelected((Boolean)event.getValue());
                        } else if ("trustedlan".equals(event.getType())) {
                            SecuritySettingsPanel.this.cbtrulan.setSelected((Boolean)event.getValue());
                        } else if ("localpass".equals(event.getType())) {
                            SecuritySettingsPanel.this.tfpass.setText((String)event.getValue());
                        } else if ("validityduration".equals(event.getType())) {
                            SecuritySettingsPanel.this.tfvaldur.setText("" + (Long)event.getValue() / 60000L);
                        } else if ("platformpass".equals(event.getType())) {
                            SecuritySettingsPanel.this.ppp.update((Map)event.getValue());
                        } else if ("networkpass".equals(event.getType())) {
                            SecuritySettingsPanel.this.npp.update((Map)event.getValue());
                        } else if ("keystoresettings".equals(event.getType())) {
                            String[] info = (String[])event.getValue();
                            SecuritySettingsPanel.this.tfstorepath.setText(info[0]);
                            SecuritySettingsPanel.this.tfstorepass.setText(info[1]);
                            SecuritySettingsPanel.this.tfkeypass.setText(info[2]);
                        } else if ("keystoresettings".equals(event.getType())) {
                            String[] info = (String[])event.getValue();
                            SecuritySettingsPanel.this.tfstorepath.setText(info[0]);
                            SecuritySettingsPanel.this.tfstorepass.setText(info[1]);
                            SecuritySettingsPanel.this.tfkeypass.setText(info[2]);
                        } else if ("keystoreentries".equals(event.getType())) {
                            SecuritySettingsPanel.this.updateact.run();
                        } else if ("selmechanism".equals(event.getType())) {
                            acp.setSelectedMechanism((Integer)event.getValue());
                        } else if ("mechanismparameter".equals(event.getType())) {
                            Object[] data = (Object[])event.getValue();
                            acp.setParameterValue(((Class)event.getSource()).getName(), (String)data[0], data[1]);
                        }
                    }
                });
            }

            public void finished() {
                System.out.println("fin");
            }

            public void resultAvailable(Collection<jadex.commons.ChangeEvent<Object>> result) {
                System.out.println("ra");
            }

            public void exceptionOccurred(Exception exception) {
                exception.printStackTrace();
            }
        });
        return ret;
    }

    public IFuture<Void> shutdown() {
        return IFuture.DONE;
    }

    public JComponent getComponent() {
        return this.inner;
    }

    public String getId() {
        return "securitysettings";
    }

    public IFuture<Void> setProperties(Properties props) {
        this.cbshowchars.setSelected(props.getBooleanProperty("showchars"));
        ((JTabbedPane)this.inner).setSelectedIndex(props.getIntProperty("selected_tab"));
        if (props.getProperty("sph") != null) {
            this.sph.setDividerLocation(props.getDoubleProperty("sph"));
        }
        if (props.getProperty("spv") != null) {
            this.spv.setDividerLocation(props.getDoubleProperty("spv"));
        }
        return IFuture.DONE;
    }

    public IFuture<Properties> getProperties() {
        Properties props = new Properties();
        props.addProperty(new Property("showchars", Boolean.toString(this.cbshowchars.isSelected())));
        props.addProperty(new Property("selected_tab", "" + ((JTabbedPane)this.inner).getSelectedIndex()));
        props.addProperty(new Property("sph", "" + this.sph.getProportionalDividerLocation()));
        props.addProperty(new Property("spv", "" + this.spv.getProportionalDividerLocation()));
        return new Future((Object)props);
    }
}

