/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.security;

import jadex.base.gui.CMSUpdateHandler;
import jadex.base.gui.PlatformSelectorDialog;
import jadex.base.gui.componenttree.ComponentIconCache;
import jadex.base.gui.idtree.IdTreeCellRenderer;
import jadex.base.gui.idtree.IdTreeModel;
import jadex.base.gui.idtree.IdTreeNode;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.types.security.ISecurityService;
import jadex.commons.ChangeEvent;
import jadex.commons.IChangeListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.CombiIcon;
import jadex.commons.gui.PropertiesPanel;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.TreeExpansionHandler;
import jadex.commons.gui.future.SwingExceptionDelegationResultListener;
import jadex.commons.gui.future.SwingResultListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class VirtualNamesPanel
extends JPanel {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"virtual", SGUI.makeIcon(VirtualNamesPanel.class, (String)"/jadex/tools/security/images/virtual.png"), "platform", SGUI.makeIcon(VirtualNamesPanel.class, (String)"/jadex/tools/security/images/platform.png"), "overlay_exclamation", SGUI.makeIcon(VirtualNamesPanel.class, (String)"/jadex/tools/security/images/overlay_exclamation.png")});
    public static final String VIRTUAL = "Role";
    protected IExternalAccess ea;
    protected IExternalAccess jccaccess;
    protected ISecurityService secser;
    protected CMSUpdateHandler cmshandler;
    protected JTree tree;
    protected IdTreeModel<String> model;
    protected boolean platform;
    protected List<IChangeListener<String>> listeners;
    protected Set<String> emptyplatforms;
    protected int vpcnt = 0;
    protected int pcnt = 0;

    public VirtualNamesPanel(IExternalAccess ea, IExternalAccess jccaccess, ISecurityService secser, CMSUpdateHandler cmshandler, boolean platform) {
        this.ea = ea;
        this.secser = secser;
        this.cmshandler = cmshandler;
        this.platform = platform;
        this.listeners = new ArrayList<IChangeListener<String>>();
        this.emptyplatforms = new HashSet<String>();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), platform ? "Platform -> Role" : "Role -> Platform"));
        this.model = new IdTreeModel<String>(){

            public void reload() {
                VirtualNamesPanel.this.createTreeModel();
                super.reload();
            }
        };
        RootNode root = new RootNode();
        this.model.setRoot((TreeNode)((Object)root));
        this.tree = new JTree((TreeModel)this.model);
        new TreeExpansionHandler(this.tree);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer((TreeCellRenderer)new IdTreeCellRenderer());
        this.tree.expandPath(new TreePath(root.getPath()));
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.add((Component)new JScrollPane(this.tree), "Center");
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.popup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.popup(e);
            }

            protected void popup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu menu = new JPopupMenu();
                    TreePath path = VirtualNamesPanel.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (path == null) {
                        path = new TreePath(VirtualNamesPanel.this.model.getRoot());
                    }
                    VirtualNamesPanel.this.tree.setSelectionPath(path);
                    IdTreeNode node = (IdTreeNode)VirtualNamesPanel.this.tree.getLastSelectedPathComponent();
                    if (node instanceof RootNode) {
                        if (VirtualNamesPanel.this.platform) {
                            menu.add(new SelectPlatformAction((IdTreeNode<String>)node));
                            menu.add(new AddPlatformAction((IdTreeNode<String>)node));
                        } else {
                            menu.add(new AddVirtualPlatformAction((IdTreeNode<String>)node));
                        }
                    } else if (node instanceof VirtualPlatformNode) {
                        if (node.getParent() instanceof RootNode) {
                            menu.add(new SelectPlatformAction((IdTreeNode<String>)node));
                            menu.add(new AddPlatformAction((IdTreeNode<String>)node));
                        }
                        menu.add(new RemoveAction((IdTreeNode<String>)node));
                    } else if (node instanceof PlatformNode) {
                        if (node.getParent() instanceof RootNode) {
                            menu.add(new SelectVirtualPlatformAction((IdTreeNode<String>)node));
                            menu.add(new AddVirtualPlatformAction((IdTreeNode<String>)node));
                        }
                        menu.add(new RemoveAction((IdTreeNode<String>)node));
                    }
                    menu.add(new SwitchViewAction());
                    menu.show(VirtualNamesPanel.this.tree, e.getX(), e.getY());
                }
            }
        };
        this.tree.addMouseListener(ma);
        this.createTreeModel();
    }

    protected JTree getTree() {
        return this.tree;
    }

    protected IFuture<Void> createTreeModel() {
        if (this.platform) {
            return this.createPlatformsModel();
        }
        return this.createVirtualsModel();
    }

    protected IFuture<Void> createVirtualsModel() {
        final Future ret = new Future();
        this.secser.getVirtuals().addResultListener((IResultListener)new SwingExceptionDelegationResultListener<Map<String, Set<String>>, Void>(ret){

            public void customResultAvailable(Map<String, Set<String>> virtuals) {
                IdTreeNode root = (IdTreeNode)VirtualNamesPanel.this.model.getRoot();
                root.removeAllChildren();
                VirtualNamesPanel.this.vpcnt = 0;
                VirtualNamesPanel.this.pcnt = 0;
                for (Map.Entry<String, Set<String>> virtual : virtuals.entrySet()) {
                    String v = virtual.getKey();
                    VirtualPlatformNode vn = new VirtualPlatformNode(v);
                    VirtualNamesPanel.this.insertNode(root, vn);
                    if (virtual.getValue() == null) continue;
                    for (String pl : virtual.getValue()) {
                        PlatformNode pn = new PlatformNode(pl);
                        VirtualNamesPanel.this.insertNode(vn, pn);
                    }
                }
                for (int i = 0; i < VirtualNamesPanel.this.tree.getRowCount(); ++i) {
                    VirtualNamesPanel.this.tree.expandRow(i);
                }
                ret.setResult(null);
            }
        });
        return ret;
    }

    protected IFuture<Void> createPlatformsModel() {
        final Future ret = new Future();
        this.secser.getVirtuals().addResultListener((IResultListener)new SwingExceptionDelegationResultListener<Map<String, Set<String>>, Void>(ret){

            public void customResultAvailable(Map<String, Set<String>> virtuals) {
                IdTreeNode root = (IdTreeNode)VirtualNamesPanel.this.model.getRoot();
                root.removeAllChildren();
                VirtualNamesPanel.this.vpcnt = 0;
                VirtualNamesPanel.this.pcnt = 0;
                HashMap<String, HashSet<String>> plats = new HashMap<String, HashSet<String>>();
                for (Map.Entry<String, Set<String>> entry : virtuals.entrySet()) {
                    String v = entry.getKey();
                    if (entry.getValue() == null) continue;
                    for (String pl : entry.getValue()) {
                        HashSet<String> vals = (HashSet<String>)plats.get(pl);
                        if (vals == null) {
                            vals = new HashSet<String>();
                            plats.put(pl, vals);
                        }
                        vals.add(v);
                    }
                }
                for (String string : new HashSet<String>(VirtualNamesPanel.this.emptyplatforms)) {
                    if (!plats.containsKey(string)) {
                        plats.put(string, null);
                        continue;
                    }
                    VirtualNamesPanel.this.emptyplatforms.remove(string);
                }
                for (Map.Entry entry : plats.entrySet()) {
                    String p = (String)entry.getKey();
                    PlatformNode pn = new PlatformNode(p);
                    VirtualNamesPanel.this.insertNode(root, pn);
                    if (entry.getValue() == null) continue;
                    for (String v : (Set)entry.getValue()) {
                        VirtualPlatformNode vn = new VirtualPlatformNode(v);
                        VirtualNamesPanel.this.insertNode(pn, vn);
                    }
                }
                for (int i = 0; i < VirtualNamesPanel.this.tree.getRowCount(); ++i) {
                    VirtualNamesPanel.this.tree.expandRow(i);
                }
                ret.setResult(null);
            }
        });
        return ret;
    }

    public void addChangeListener(IChangeListener<String> listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(IChangeListener<String> listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners(ChangeEvent<String> e) {
        for (IChangeListener<String> lis : this.listeners) {
            lis.changeOccurred(e);
        }
    }

    protected void insertNode(IdTreeNode<?> parent, IdTreeNode<?> child) {
        if (this.platform) {
            if (child instanceof PlatformNode && child.getChildCount() == 0) {
                this.emptyplatforms.add(child.getName());
            } else if (child instanceof VirtualPlatformNode && child.getParent() != null && child.getParent().getChildCount() == 0) {
                this.emptyplatforms.remove(parent.getName());
            }
        }
        this.insertNode(parent, child, true);
    }

    protected void insertNode(IdTreeNode<?> parent, IdTreeNode<?> child, boolean up) {
        int cnt = parent.getChildCount();
        boolean done = false;
        if (cnt > 0) {
            for (int i = 0; i < cnt && !done; ++i) {
                IdTreeNode tmp = (IdTreeNode)parent.getChildAt(i);
                if ((!up || tmp.toString().compareTo(child.toString()) < 0) && (up || tmp.toString().compareTo(child.toString()) > 0)) continue;
                parent.insert(child, i);
                done = true;
            }
        }
        if (!done) {
            parent.add(child);
        }
    }

    class SwitchViewAction
    extends AbstractAction {
        public SwitchViewAction() {
            super(VirtualNamesPanel.this.platform ? "Switch to " + VirtualNamesPanel.VIRTUAL.toLowerCase() + " view" : "Switch to platform view");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VirtualNamesPanel.this.platform = !VirtualNamesPanel.this.platform;
            VirtualNamesPanel.this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VirtualNamesPanel.this.platform ? "Platform -> Role" : "Role -> Platform"));
            if (VirtualNamesPanel.this.platform) {
                VirtualNamesPanel.this.createPlatformsModel();
            } else {
                VirtualNamesPanel.this.createVirtualsModel();
            }
        }
    }

    class RemoveAction
    extends AbstractAction {
        protected IdTreeNode<String> node;

        public RemoveAction(IdTreeNode<String> node) {
            super("Remove " + (node instanceof VirtualPlatformNode ? VirtualNamesPanel.VIRTUAL.toLowerCase() : "platform"));
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String v = null;
            String p = null;
            if (this.node instanceof PlatformNode) {
                p = this.node.getName();
            } else if (this.node instanceof VirtualPlatformNode) {
                v = this.node.getName();
            }
            IdTreeNode pa = (IdTreeNode)this.node.getParent();
            if (pa instanceof VirtualPlatformNode) {
                v = pa.getName();
            } else if (pa instanceof PlatformNode) {
                p = pa.getName();
            }
            VirtualNamesPanel.this.secser.removeVirtual(v, p).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<Void>(){

                public void resultAvailable(Void result) {
                    ((IdTreeNode)RemoveAction.this.node.getParent()).remove(RemoveAction.this.node);
                    VirtualNamesPanel.this.notifyListeners((ChangeEvent<String>)new ChangeEvent(null));
                }

                public void exceptionOccurred(Exception exception) {
                }
            }));
            if (this.node instanceof PlatformNode && this.node.getChildCount() > 0) {
                for (IdTreeNode child : this.node.getChildren()) {
                    VirtualNamesPanel.this.secser.removeVirtual(child.getName(), p).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<Void>(){

                        public void resultAvailable(Void result) {
                        }

                        public void exceptionOccurred(Exception exception) {
                        }
                    }));
                }
            }
        }
    }

    class AddPlatformAction
    extends AbstractAction {
        protected IdTreeNode<String> node;

        public AddPlatformAction(IdTreeNode<String> node) {
            super("Add platform");
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PropertiesPanel pp = new PropertiesPanel();
            JTextField tfname = pp.createTextField("Platform name: ", null, true);
            int res = JOptionPane.showOptionDialog(VirtualNamesPanel.this, pp, "Platform Name", 1, 3, null, new Object[]{"OK", "Cancel"}, "OK");
            if (0 == res) {
                final String name = tfname.getText();
                if (!(this.node instanceof RootNode)) {
                    VirtualNamesPanel.this.secser.addVirtual(this.node.getName(), name).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<Void>(){

                        public void resultAvailable(Void result) {
                            PlatformNode cn = new PlatformNode(name);
                            VirtualNamesPanel.this.insertNode(AddPlatformAction.this.node, cn);
                            VirtualNamesPanel.this.tree.setSelectionPath(new TreePath(cn.getPath()));
                            VirtualNamesPanel.this.notifyListeners((ChangeEvent<String>)new ChangeEvent(null));
                        }

                        public void exceptionOccurred(Exception exception) {
                        }
                    }));
                } else {
                    PlatformNode cn = new PlatformNode(name);
                    VirtualNamesPanel.this.insertNode(this.node, cn);
                    VirtualNamesPanel.this.tree.setSelectionPath(new TreePath(cn.getPath()));
                }
            }
        }
    }

    class SelectPlatformAction
    extends AbstractAction {
        protected IdTreeNode<String> node;

        public SelectPlatformAction(IdTreeNode<String> node) {
            super("Select platform");
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlatformSelectorDialog csd = new PlatformSelectorDialog((Component)SGUI.getWindowParent((Component)VirtualNamesPanel.this), VirtualNamesPanel.this.ea, VirtualNamesPanel.this.jccaccess, VirtualNamesPanel.this.cmshandler, null, new ComponentIconCache(VirtualNamesPanel.this.ea));
            IComponentIdentifier cid = csd.selectAgent(null);
            if (cid != null) {
                final String name = cid.getPlatformPrefix();
                if (!(this.node instanceof RootNode)) {
                    VirtualNamesPanel.this.secser.addVirtual(this.node.getName(), name).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<Void>(){

                        public void resultAvailable(Void result) {
                            PlatformNode cn = new PlatformNode(name);
                            VirtualNamesPanel.this.insertNode(SelectPlatformAction.this.node, cn);
                            VirtualNamesPanel.this.tree.setSelectionPath(new TreePath(cn.getPath()));
                            VirtualNamesPanel.this.notifyListeners((ChangeEvent<String>)new ChangeEvent(null));
                        }

                        public void exceptionOccurred(Exception exception) {
                        }
                    }));
                } else {
                    PlatformNode cn = new PlatformNode(name);
                    VirtualNamesPanel.this.insertNode(this.node, cn);
                    VirtualNamesPanel.this.tree.setSelectionPath(new TreePath(cn.getPath()));
                }
            }
        }
    }

    class SelectVirtualPlatformAction
    extends AbstractAction {
        protected IdTreeNode<String> node;

        public SelectVirtualPlatformAction(IdTreeNode<String> node) {
            super("Select " + VirtualNamesPanel.VIRTUAL.toLowerCase());
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VirtualNamesPanel.this.secser.getVirtuals().addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<Map<String, Set<String>>>(){

                public void resultAvailable(Map<String, Set<String>> vs) {
                    IdTreeNode[] childs;
                    JPanel pan = new JPanel(new BorderLayout());
                    final JTextField tfname = new JTextField();
                    for (IdTreeNode child : childs = SelectVirtualPlatformAction.this.node.getChildren()) {
                        vs.remove(child.getName());
                    }
                    if (!vs.isEmpty()) {
                        ArrayList<String> vals = new ArrayList<String>(vs.keySet());
                        Collections.sort(vals);
                        DefaultListModel<String> model = new DefaultListModel<String>();
                        JList list = new JList(model);
                        for (String v : vals) {
                            model.addElement(v);
                        }
                        list.setSelectionMode(0);
                        list.addListSelectionListener(new ListSelectionListener(){

                            @Override
                            public void valueChanged(ListSelectionEvent e) {
                                boolean adjust = e.getValueIsAdjusting();
                                if (!adjust) {
                                    JList list = (JList)e.getSource();
                                    tfname.setText("" + list.getSelectedValue());
                                }
                            }
                        });
                        pan.add(list, "Center");
                    }
                    pan.add((Component)tfname, "South");
                    int res = JOptionPane.showOptionDialog(VirtualNamesPanel.this, pan, "Role Name", 1, 3, null, new Object[]{"OK", "Cancel"}, "OK");
                    if (0 == res) {
                        final String v = tfname.getText();
                        String p = null;
                        if (!(SelectVirtualPlatformAction.this.node instanceof RootNode)) {
                            p = SelectVirtualPlatformAction.this.node.getName();
                        }
                        VirtualNamesPanel.this.secser.addVirtual(v, p).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<Void>(){

                            public void resultAvailable(Void result) {
                                VirtualPlatformNode cn = new VirtualPlatformNode(v);
                                VirtualNamesPanel.this.insertNode(SelectVirtualPlatformAction.this.node, cn);
                                VirtualNamesPanel.this.tree.setSelectionPath(new TreePath(cn.getPath()));
                                VirtualNamesPanel.this.notifyListeners((ChangeEvent<String>)new ChangeEvent(null));
                            }

                            public void exceptionOccurred(Exception exception) {
                            }
                        }));
                    }
                }

                public void exceptionOccurred(Exception exception) {
                }
            }));
        }
    }

    class AddVirtualPlatformAction
    extends AbstractAction {
        protected IdTreeNode<String> node;

        public AddVirtualPlatformAction(IdTreeNode<String> node) {
            super("Add " + VirtualNamesPanel.VIRTUAL.toLowerCase());
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PropertiesPanel pp = new PropertiesPanel();
            JTextField tfname = pp.createTextField("Role name: ", null, true);
            int res = JOptionPane.showOptionDialog(VirtualNamesPanel.this, pp, "Role Name", 1, 3, null, new Object[]{"OK", "Cancel"}, "OK");
            if (0 == res) {
                final String v = tfname.getText();
                String p = null;
                if (!(this.node instanceof RootNode)) {
                    p = this.node.getName();
                }
                VirtualNamesPanel.this.secser.addVirtual(v, p).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<Void>(){

                    public void resultAvailable(Void result) {
                        VirtualPlatformNode cn = new VirtualPlatformNode(v);
                        VirtualNamesPanel.this.insertNode(AddVirtualPlatformAction.this.node, cn);
                        VirtualNamesPanel.this.tree.setSelectionPath(new TreePath(cn.getPath()));
                        VirtualNamesPanel.this.notifyListeners((ChangeEvent<String>)new ChangeEvent(null));
                    }

                    public void exceptionOccurred(Exception exception) {
                    }
                }));
            }
        }
    }

    class PlatformNode
    extends IdTreeNode<String> {
        public PlatformNode(String name) {
            super(name + "_" + VirtualNamesPanel.this.pcnt++, name, VirtualNamesPanel.this.model, null, icons.getIcon("platform"), null, null);
        }

        protected boolean isSaved() {
            return this.getParent() instanceof VirtualPlatformNode || this.getChildCount() > 0;
        }

        public Icon getIcon() {
            return this.isSaved() ? super.getIcon() : new CombiIcon(new Icon[]{super.getIcon(), icons.getIcon("overlay_exclamation")});
        }

        public String getTooltipText() {
            return this.isSaved() ? super.getTooltipText() : "Changes will be lost when not at least one " + VirtualNamesPanel.VIRTUAL.toLowerCase() + " is assiged.";
        }
    }

    class VirtualPlatformNode
    extends IdTreeNode<String> {
        public VirtualPlatformNode(String name) {
            super(name + "_" + VirtualNamesPanel.this.vpcnt++, name, VirtualNamesPanel.this.model, null, icons.getIcon("virtual"), null, null);
        }
    }

    class RootNode
    extends IdTreeNode<String> {
        public RootNode() {
            super("rootnode", "rootnode", VirtualNamesPanel.this.model, Boolean.FALSE, null, null, null);
        }
    }
}

