/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.simcenter;

import jadex.base.SRemoteClock;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.types.simulation.ISimulationService;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.future.SwingIntermediateDefaultResultListener;
import jadex.tools.simcenter.ExponentialSpinnerModel;
import jadex.tools.simcenter.SimCenterPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class ClockPanel
extends JPanel {
    protected SimCenterPanel simp;
    protected JCheckBox update;
    protected JComboBox emode;
    protected JTextField starttime;
    protected JTextField ticksize;
    protected JTextField curticksize;
    protected JSpinner dilation;
    protected JTextField curdilation;
    protected JLabel currenttime;
    protected JLabel tickcount;
    protected JLabel systemtime;
    protected String lastclocktype;
    protected DecimalFormat numberformat;
    protected SRemoteClock.ClockState laststate;

    public ClockPanel(final SimCenterPanel simp) {
        this.setLayout(new GridBagLayout());
        this.simp = simp;
        this.numberformat = new DecimalFormat("#######0.####");
        this.setBorder(new TitledBorder(new EtchedBorder(1), "Clock Settings "));
        int x = 0;
        int y = 0;
        this.update = new JCheckBox("Update clock", true);
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClockPanel.this.setActive(ClockPanel.this.update.isSelected());
            }
        });
        this.add((Component)this.update, new GridBagConstraints(x, y, 2, 1, 0.0, 0.0, 17, 0, new Insets(4, 2, 2, 4), 0, 0));
        this.emode = new JComboBox<String>(new String[]{"System", "Continuous", "Time Stepped", "Event Driven"});
        this.emode.setEditable(false);
        this.add((Component)new JLabel("Execution mode"), new GridBagConstraints(x, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 2, 2, 4), 0, 0));
        this.add((Component)this.emode, new GridBagConstraints(++x, y, 2, 1, 1.0, 0.0, 13, 2, new Insets(4, 2, 2, 4), 0, 0));
        this.starttime = new JTextField(8);
        this.starttime.setEditable(false);
        x = 0;
        this.add((Component)new JLabel("Start time"), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 2, 2, 4), 0, 0));
        this.add((Component)this.starttime, new GridBagConstraints(++x, y, 2, 1, 1.0, 0.0, 13, 2, new Insets(4, 2, 2, 4), 0, 0));
        this.ticksize = new JTextField(8);
        this.curticksize = new JTextField(4);
        this.curticksize.setEditable(false);
        x = 0;
        this.add((Component)new JLabel("Tick size"), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 2, 2, 4), 0, 0));
        this.add((Component)this.curticksize, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 13, 2, new Insets(4, 2, 2, 4), 0, 0));
        this.add((Component)this.ticksize, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 13, 2, new Insets(4, 2, 2, 4), 0, 0));
        this.dilation = new JSpinner(new ExponentialSpinnerModel(1.0, 2.0)){

            @Override
            public void commitEdit() throws ParseException {
            }
        };
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.dilation.getEditor();
        JFormattedTextField tf = editor.getTextField();
        tf.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(this.numberformat)));
        tf.setEditable(true);
        this.curdilation = new JTextField(3);
        this.curdilation.setEditable(false);
        x = 0;
        this.add((Component)new JLabel("Dilation"), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 2, 2, 4), 0, 0));
        this.add((Component)this.curdilation, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 13, 2, new Insets(4, 2, 2, 4), 0, 0));
        this.add((Component)this.dilation, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 13, 2, new Insets(4, 2, 2, 4), 0, 0));
        this.currenttime = new JLabel();
        x = 0;
        this.add((Component)new JLabel("Model time"), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 2, 2, 4), 0, 0));
        this.add((Component)this.currenttime, new GridBagConstraints(++x, y, 2, 1, 1.0, 0.0, 13, 2, new Insets(4, 2, 2, 4), 0, 0));
        this.tickcount = new JLabel();
        x = 0;
        this.add((Component)new JLabel("Tick count"), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 2, 2, 4), 0, 0));
        this.add((Component)this.tickcount, new GridBagConstraints(++x, y, 2, 1, 1.0, 0.0, 13, 2, new Insets(4, 2, 2, 4), 0, 0));
        this.systemtime = new JLabel();
        x = 0;
        this.add((Component)new JLabel("System time"), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 2, 2, 4), 0, 0));
        this.add((Component)this.systemtime, new GridBagConstraints(++x, y, 2, 1, 1.0, 0.0, 13, 2, new Insets(4, 2, 2, 4), 0, 0));
        this.emode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if ("System".equals(ClockPanel.this.emode.getSelectedItem())) {
                    if (!"system".equals(ClockPanel.this.lastclocktype)) {
                        simp.getSimulationService().setClockType("system");
                        simp.updateView();
                    }
                } else if ("Continuous".equals(ClockPanel.this.emode.getSelectedItem())) {
                    if (!"continuous".equals(ClockPanel.this.lastclocktype)) {
                        simp.getSimulationService().setClockType("continuous");
                        simp.updateView();
                    }
                } else if ("Time Stepped".equals(ClockPanel.this.emode.getSelectedItem())) {
                    if (!"time_driven".equals(ClockPanel.this.lastclocktype)) {
                        simp.getSimulationService().setClockType("time_driven");
                        simp.updateView();
                    }
                } else if ("Event Driven".equals(ClockPanel.this.emode.getSelectedItem()) && !"event_driven".equals(ClockPanel.this.lastclocktype)) {
                    simp.getSimulationService().setClockType("event_driven");
                    simp.updateView();
                }
            }
        });
        this.dilation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!"continuous".equals(ClockPanel.this.lastclocktype)) {
                    return;
                }
                try {
                    SRemoteClock.setDilation((double)((Double)ClockPanel.this.dilation.getValue()), (IExternalAccess)simp.getJCC().getPlatformAccess());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.ticksize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SRemoteClock.setDelta((long)Long.parseLong(ClockPanel.this.ticksize.getText()), (IExternalAccess)simp.getJCC().getPlatformAccess());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.setActive(true);
    }

    public void updateView() {
        if (this.laststate != null) {
            this.updateView(this.laststate);
        }
    }

    public void updateView(SRemoteClock.ClockState state) {
        String dstring_new;
        String dstring;
        String ststring_new;
        String ststring;
        this.laststate = state;
        this.emode.setEnabled(state.changeallowed);
        String tsstring = this.curticksize.getText();
        String tsstring_new = "" + this.numberformat.format(state.delta);
        if (!tsstring.equals(tsstring_new)) {
            this.curticksize.setText(tsstring_new);
        }
        if (!(ststring = this.starttime.getText()).equals(ststring_new = this.simp.formatTime(state.starttime))) {
            this.starttime.setText(ststring_new);
        }
        this.currenttime.setText(this.simp.formatTime(state.time));
        this.tickcount.setText("" + state.tick);
        this.systemtime.setText(this.simp.formatTime(System.currentTimeMillis()));
        if (state.type.equals("continuous") && !(dstring = this.curdilation.getText()).equals(dstring_new = "" + state.dilation)) {
            this.curdilation.setText(dstring_new);
        }
        if (this.lastclocktype == null || !this.lastclocktype.equals(state.type)) {
            this.lastclocktype = state.type;
            if (this.lastclocktype.equals("system")) {
                this.emode.setSelectedItem("System");
            } else if (this.lastclocktype.equals("continuous")) {
                this.emode.setSelectedItem("Continuous");
            } else if (this.lastclocktype.equals("time_driven")) {
                this.emode.setSelectedItem("Time Stepped");
            } else if (this.lastclocktype.equals("event_driven")) {
                this.emode.setSelectedItem("Event Driven");
            }
            if (this.lastclocktype.equals("continuous")) {
                this.dilation.setEnabled(true);
                ((JSpinner.DefaultEditor)this.dilation.getEditor()).getTextField().setEditable(true);
                this.dilation.setValue(state.dilation);
            } else {
                this.dilation.setEnabled(false);
                ((JSpinner.DefaultEditor)this.dilation.getEditor()).getTextField().setEditable(false);
                this.dilation.setValue(0.0);
                this.curdilation.setText("");
            }
        }
    }

    public void setActive(boolean active) {
        if (this.update.isSelected() != active) {
            this.update.setSelected(active);
        } else {
            String id = "ClockPanel" + this.hashCode() + "@" + this.simp.jcc.getJCCAccess().getComponentIdentifier();
            ISimulationService simservice = this.simp.getSimulationService();
            if (active) {
                SRemoteClock.addClockListener((String)id, (ISimulationService)simservice, (IExternalAccess)this.simp.getJCC().getPlatformAccess()).addResultListener((IResultListener)new SwingIntermediateDefaultResultListener<SRemoteClock.ClockState>((Component)this){

                    public void customIntermediateResultAvailable(SRemoteClock.ClockState result) {
                        ClockPanel.this.updateView(result);
                    }
                });
            } else {
                SRemoteClock.removeClockListener((String)id, (ISimulationService)simservice, (IExternalAccess)this.simp.getJCC().getPlatformAccess());
            }
        }
    }
}

