/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.simcenter;

import jadex.base.SRemoteClock;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.types.simulation.ISimulationService;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.ToolTipAction;
import jadex.commons.gui.future.SwingIntermediateDefaultResultListener;
import jadex.tools.simcenter.SimCenterPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ContextPanel
extends JPanel {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"start", SGUI.makeIcon(ContextPanel.class, (String)"/jadex/tools/common/images/start.png"), "step_event", SGUI.makeIcon(ContextPanel.class, (String)"/jadex/tools/common/images/single_step_event.png"), "step_time", SGUI.makeIcon(ContextPanel.class, (String)"/jadex/tools/common/images/single_step_time.png"), "pause", SGUI.makeIcon(ContextPanel.class, (String)"/jadex/tools/common/images/pause.png")});
    protected SimCenterPanel simp;
    public final Action START = new ToolTipAction(null, icons.getIcon("start"), "Start the execution of the application"){

        public void actionPerformed(ActionEvent e) {
            ContextPanel.this.simp.getSimulationService().start();
        }
    };
    public final Action STEP_EVENT = new ToolTipAction(null, icons.getIcon("step_event"), "Execute one timer entry."){

        public void actionPerformed(ActionEvent e) {
            ContextPanel.this.simp.getSimulationService().stepEvent();
        }
    };
    public final Action STEP_TIME = new ToolTipAction(null, icons.getIcon("step_time"), "Execute all timer entries belonging to the current time point."){

        public void actionPerformed(ActionEvent e) {
            ContextPanel.this.simp.getSimulationService().stepTime();
        }
    };
    public final Action PAUSE = new ToolTipAction(null, icons.getIcon("pause"), "Pause the current execution."){

        public void actionPerformed(ActionEvent e) {
            ContextPanel.this.simp.getSimulationService().pause();
        }
    };

    public ContextPanel(SimCenterPanel simp) {
        this.setLayout(new FlowLayout());
        this.simp = simp;
        this.setBorder(new TitledBorder(new EtchedBorder(1), " Execution Control "));
        JToolBar toolbar = new JToolBar("Simulation Control");
        toolbar.add(this.START);
        toolbar.add(this.STEP_EVENT);
        toolbar.add(this.STEP_TIME);
        toolbar.add(this.PAUSE);
        this.add(toolbar);
        this.setActive(true);
    }

    public void updateView(SRemoteClock.SimulationState state) {
        boolean startenabled = !state.executing;
        boolean pauseenabled = state.executing;
        boolean stepenabled = !state.executing && state.clockok && !"continuous".equals(state.clocktype) && !"system".equals(state.clocktype);
        this.START.setEnabled(startenabled);
        this.STEP_EVENT.setEnabled(stepenabled);
        this.STEP_TIME.setEnabled(stepenabled);
        this.PAUSE.setEnabled(pauseenabled);
    }

    public void setActive(boolean active) {
        String id = "ContextPanel" + this.hashCode() + "@" + this.simp.jcc.getJCCAccess().getComponentIdentifier();
        ISimulationService simservice = this.simp.getSimulationService();
        if (active) {
            SRemoteClock.addSimulationListener((String)id, (ISimulationService)simservice, (IExternalAccess)this.simp.getJCC().getPlatformAccess()).addResultListener((IResultListener)new SwingIntermediateDefaultResultListener<SRemoteClock.SimulationState>((Component)this){

                public void customIntermediateResultAvailable(SRemoteClock.SimulationState result) {
                    ContextPanel.this.updateView(result);
                }
            });
        } else {
            SRemoteClock.removeSimulationListener((String)id, (ISimulationService)simservice, (IExternalAccess)this.simp.getJCC().getPlatformAccess());
        }
    }
}

