/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.simcenter;

import jadex.base.gui.plugin.IControlCenter;
import jadex.bridge.service.types.simulation.ISimulationService;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.TimeFormat;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.tools.simcenter.ClockPanel;
import jadex.tools.simcenter.ContextPanel;
import jadex.tools.simcenter.TimerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIDefaults;

public class SimCenterPanel
extends JPanel {
    protected static UIDefaults icons = new UIDefaults(new Object[0]);
    protected IControlCenter jcc;
    protected ISimulationService simservice;
    protected ClockPanel clockp;
    protected ContextPanel contextp;
    protected TimerPanel timerp;
    protected DateFormat dateformat;
    protected int timemode;

    public SimCenterPanel(IControlCenter jcc, ISimulationService simservice) {
        super(new BorderLayout());
        this.simservice = simservice;
        this.jcc = jcc;
        this.timemode = 2;
        this.dateformat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss S");
        this.clockp = new ClockPanel(this);
        this.contextp = new ContextPanel(this);
        JPanel left = new JPanel(new BorderLayout());
        left.add((Component)this.clockp, "North");
        left.add((Component)this.contextp, "South");
        this.timerp = new TimerPanel(this);
        JSplitPane sp = new JSplitPane(1);
        sp.setOneTouchExpandable(true);
        sp.add(left);
        sp.add(this.timerp);
        this.add((Component)sp, "Center");
    }

    public ContextPanel getContextPanel() {
        return this.contextp;
    }

    public ISimulationService getSimulationService() {
        return this.simservice;
    }

    public IControlCenter getJCC() {
        return this.jcc;
    }

    public String formatTime(long time) {
        String ret = this.timemode == 0 ? "" + time : (this.timemode == 1 ? TimeFormat.format((long)time) : this.dateformat.format(new Date(time)));
        return ret;
    }

    public int getTimeMode() {
        return this.timemode;
    }

    public void setTimemode(int timemode) {
        this.timemode = timemode;
    }

    public void updateView() {
        this.clockp.updateView();
        this.timerp.updateView();
    }

    public IFuture<Void> setProperties(Properties ps) {
        int timemode = ps.getProperty("timemode") != null ? ps.getIntProperty("timemode") : 2;
        this.setTimemode(timemode);
        this.updateView();
        return IFuture.DONE;
    }

    public IFuture<Properties> getProperties() {
        Properties props = new Properties();
        props.addProperty(new Property("timemode", Integer.toString(this.getTimeMode())));
        return new Future((Object)props);
    }

    public IFuture<Void> shutdown() {
        this.clockp.setActive(false);
        this.timerp.setActive(false);
        return IFuture.DONE;
    }
}

