/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.simcenter;

import jadex.bridge.service.IService;
import jadex.bridge.service.types.simulation.ISimulationService;
import jadex.commons.Properties;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDelegationResultListener;
import jadex.tools.generic.AbstractServicePlugin;
import jadex.tools.simcenter.SimCenterPanel;
import jadex.tools.simcenter.SimServiceViewerPanel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIDefaults;

public class SimulationServicePlugin
extends AbstractServicePlugin {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"simcenter_sel", SGUI.makeIcon(SimulationServicePlugin.class, (String)"/jadex/tools/common/images/stopwatch_sel.png"), "simcenter", SGUI.makeIcon(SimulationServicePlugin.class, (String)"/jadex/tools/common/images/stopwatch.png")});
    protected JRadioButtonMenuItem time_long;
    protected JRadioButtonMenuItem time_rel;
    protected JRadioButtonMenuItem time_date;

    public Class getServiceType() {
        return ISimulationService.class;
    }

    public IFuture createServicePanel(IService service) {
        final Future ret = new Future();
        final SimServiceViewerPanel stp = new SimServiceViewerPanel();
        stp.init(this.getJCC(), service).addResultListener((IResultListener)new DelegationResultListener(ret){

            public void customResultAvailable(Object result) {
                ret.setResult((Object)stp);
            }
        });
        return ret;
    }

    @Override
    public Icon getToolIcon(boolean selected) {
        return selected ? icons.getIcon("simcenter_sel") : icons.getIcon("simcenter");
    }

    public JMenu[] createMenuBar() {
        ButtonGroup group = new ButtonGroup();
        JMenu menu = new JMenu("Time Settings");
        this.time_long = new JRadioButtonMenuItem(new AbstractAction("Long value"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimulationServicePlugin.this.getSelectorPanel().getCurrentPanel() != null) {
                    SimCenterPanel scpanel = (SimCenterPanel)SimulationServicePlugin.this.getSelectorPanel().getCurrentPanel().getComponent();
                    scpanel.setTimemode(0);
                    scpanel.updateView();
                }
            }
        });
        group.add(this.time_long);
        menu.add(this.time_long);
        this.time_rel = new JRadioButtonMenuItem(new AbstractAction("Relative value"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimulationServicePlugin.this.getSelectorPanel().getCurrentPanel() != null) {
                    SimCenterPanel scpanel = (SimCenterPanel)SimulationServicePlugin.this.getSelectorPanel().getCurrentPanel().getComponent();
                    scpanel.setTimemode(1);
                    scpanel.updateView();
                }
            }
        });
        group.add(this.time_rel);
        menu.add(this.time_rel);
        this.time_date = new JRadioButtonMenuItem(new AbstractAction("Date value"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimulationServicePlugin.this.getSelectorPanel().getCurrentPanel() != null) {
                    SimCenterPanel scpanel = (SimCenterPanel)SimulationServicePlugin.this.getSelectorPanel().getCurrentPanel().getComponent();
                    scpanel.setTimemode(2);
                    scpanel.updateView();
                }
            }
        });
        group.add(this.time_date);
        menu.add(this.time_date);
        this.updateMenu();
        return new JMenu[]{menu};
    }

    protected void updateMenu() {
        if (this.getSelectorPanel().getCurrentPanel() != null) {
            SimCenterPanel scpanel = (SimCenterPanel)this.getSelectorPanel().getCurrentPanel().getComponent();
            if (scpanel.getTimeMode() == 0) {
                this.time_long.setSelected(true);
            } else if (scpanel.getTimeMode() == 1) {
                this.time_rel.setSelected(true);
            } else if (scpanel.getTimeMode() == 2) {
                this.time_date.setSelected(true);
            }
        }
    }

    @Override
    public IFuture setProperties(Properties props) {
        final Future ret = new Future();
        super.setProperties(props).addResultListener((IResultListener)new SwingDelegationResultListener(ret){

            public void customResultAvailable(Object result) {
                SimulationServicePlugin.this.updateMenu();
                ret.setResult(null);
            }
        });
        return ret;
    }
}

