/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.simcenter;

import jadex.base.SRemoteClock;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.types.simulation.ISimulationService;
import jadex.commons.collection.SCollection;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.future.SwingIntermediateDefaultResultListener;
import jadex.commons.gui.jtable.ObjectTableModel;
import jadex.tools.simcenter.SimCenterPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class TimerPanel
extends JPanel {
    protected SimCenterPanel simp;
    protected long eventcnt;
    protected ObjectTableModel model;
    protected JTable timerst;
    protected JCheckBox update;
    protected Map<Long, Color> rowcols;
    protected SRemoteClock.TimerEntries lastentries;

    public TimerPanel(SimCenterPanel simp) {
        assert (SwingUtilities.isEventDispatchThread());
        this.simp = simp;
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(1), "Active Timers "));
        this.model = new ObjectTableModel(new String[]{"Timepoint", "Timed Object"});
        this.timerst = new JTable((TableModel)this.model);
        JScrollPane sp = new JScrollPane(this.timerst);
        this.rowcols = SCollection.createHashMap();
        this.update = new JCheckBox("Update timer events", true);
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                assert (SwingUtilities.isEventDispatchThread());
                TimerPanel.this.setActive(TimerPanel.this.update.isSelected());
                if (!TimerPanel.this.update.isSelected()) {
                    TimerPanel.this.model.removeAllRows();
                }
            }
        });
        this.add((Component)this.update, "North");
        this.add((Component)sp, "Center");
        this.eventcnt = 0L;
        this.timerst.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
                assert (SwingUtilities.isEventDispatchThread());
                Component comp = super.getTableCellRendererComponent(table, value, selected, focus, row, column);
                this.setOpaque(true);
                if (!selected) {
                    Color col = TimerPanel.this.rowcols.get(TimerPanel.this.model.getObjectForRow(row));
                    if (col != null) {
                        comp.setBackground(col);
                    } else {
                        comp.setBackground(table.getBackground());
                    }
                }
                return comp;
            }
        });
        this.setActive(true);
    }

    public void updateView() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.lastentries != null) {
            this.updateView(this.lastentries);
        }
    }

    public void updateView(SRemoteClock.TimerEntries entries) {
        assert (SwingUtilities.isEventDispatchThread());
        this.lastentries = entries;
        if (this.update.isSelected()) {
            this.model.removeAllRows();
            Color first = Color.WHITE;
            Color sec = new Color(224, 226, 229);
            for (int i = 0; i < entries.times.length; ++i) {
                this.model.addRow((Object[])new String[]{this.simp.formatTime(entries.times[i]), entries.objects[i]}, (Object)entries.times[i]);
                Color col = this.rowcols.get(entries.times[i]);
                if (col == null) {
                    if (i == 0) {
                        col = first;
                    } else {
                        boolean same;
                        Color tmp = this.rowcols.get(entries.times[i - 1]);
                        boolean bl = same = entries.times[i] == entries.times[i - 1];
                        Color color = same ? tmp : (col = tmp == first ? sec : first);
                    }
                }
                if (i == 0) {
                    this.rowcols.clear();
                }
                this.rowcols.put(entries.times[i], col);
            }
        }
    }

    public void setActive(boolean active) {
        if (this.update.isSelected() != active) {
            this.update.setSelected(active);
        } else {
            String id = "TimerPanel" + this.hashCode() + "@" + this.simp.jcc.getJCCAccess().getComponentIdentifier();
            ISimulationService simservice = this.simp.getSimulationService();
            if (active) {
                SRemoteClock.addTimerListener((String)id, (ISimulationService)simservice, (IExternalAccess)this.simp.getJCC().getPlatformAccess()).addResultListener((IResultListener)new SwingIntermediateDefaultResultListener<SRemoteClock.TimerEntries>(){

                    public void customIntermediateResultAvailable(SRemoteClock.TimerEntries result) {
                        TimerPanel.this.updateView(result);
                    }
                });
            } else {
                SRemoteClock.removeTimerListener((String)id, (ISimulationService)simservice, (IExternalAccess)this.simp.getJCC().getPlatformAccess());
            }
        }
    }
}

