/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.starter;

import jadex.base.SRemoteGui;
import jadex.base.gui.ComponentSelectorDialog;
import jadex.base.gui.ParserValidator;
import jadex.base.gui.plugin.IControlCenter;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IErrorReport;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IResourceIdentifier;
import jadex.bridge.ResourceIdentifier;
import jadex.bridge.modelinfo.ConfigurationInfo;
import jadex.bridge.modelinfo.IArgument;
import jadex.bridge.modelinfo.IModelInfo;
import jadex.bridge.modelinfo.UnparsedExpression;
import jadex.bridge.service.ProvidedServiceInfo;
import jadex.bridge.service.RequiredServiceInfo;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.bridge.service.types.factory.SComponentFactory;
import jadex.bridge.service.types.monitoring.IMonitoringService;
import jadex.commons.FixedJComboBox;
import jadex.commons.IValidator;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.collection.MultiCollection;
import jadex.commons.collection.SCollection;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.BrowserPane;
import jadex.commons.gui.JSplitPanel;
import jadex.commons.gui.JValidatorTextField;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.future.SwingDelegationResultListener;
import jadex.commons.gui.future.SwingExceptionDelegationResultListener;
import jadex.commons.gui.future.SwingResultListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class StarterPanel
extends JLayeredPane {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"overlay_check", SGUI.makeIcon(StarterPanel.class, (String)"/jadex/tools/common/images/overlay_check.png"), "Browse", SGUI.makeIcon(StarterPanel.class, (String)"/jadex/tools/common/images/dots_small.png"), "delete", SGUI.makeIcon(StarterPanel.class, (String)"/jadex/tools/common/images/delete_small.png"), "loading", SGUI.makeIcon(StarterPanel.class, (String)"/jadex/tools/common/images/loading.png")});
    protected IModelInfo model;
    protected String error;
    protected String lastfile;
    protected IResourceIdentifier lastrid;
    protected IComponentIdentifier parent;
    protected JTextField filename;
    protected JComboBox config;
    protected JTextField componentname;
    protected JLabel componentnamel;
    protected JTextField parenttf;
    protected JCheckBox suspend;
    protected JCheckBox mastercb;
    protected JCheckBox daemoncb;
    protected JCheckBox autosdcb;
    protected JCheckBox synccb;
    protected JCheckBox perscb;
    protected JComboBox monicb;
    protected JLabel confl;
    protected JLabel confdummy = new JLabel("Component Name");
    protected JLabel filenamel;
    protected JCheckBox genname;
    protected JPanel arguments;
    protected List argelems;
    protected String[] loadargs;
    protected String loadconfig;
    protected String loadname;
    protected JPanel results;
    protected List reselems;
    protected JCheckBox storeresults;
    protected JComboBox selectavail;
    protected MultiCollection<String, Object> resultsets;
    protected JButton start;
    protected JPanel componentpanel;
    protected JComponent content;
    protected JComponent loading;
    protected JPanel apppanel;
    protected IControlCenter jcc;
    protected JSpinner numcomponents;
    protected JPanel requiredservices;
    protected JPanel providedservices;
    protected BrowserPane details;
    protected JSplitPanel splitpanel;
    protected double lastdivloc;
    protected boolean closed;

    public StarterPanel(final IControlCenter jcc) {
        this.jcc = jcc;
        this.resultsets = new MultiCollection();
        this.closed = true;
        this.lastdivloc = 0.5;
        this.content = new JPanel(new GridBagLayout());
        this.filename = new JTextField();
        this.filename.setEditable(false);
        this.config = new JComboBox();
        this.config.setToolTipText("Choose the configuration to start with");
        this.config.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StarterPanel.this.refreshArguments();
                StarterPanel.this.refreshDefaultResults();
                StarterPanel.this.refreshFlags();
            }
        });
        this.suspend = new JCheckBox("Start suspended");
        this.suspend.setToolTipText("Start in suspended mode");
        this.componentname = new JTextField();
        this.genname = new JCheckBox("Auto generate", false);
        this.genname.setToolTipText("Auto generate the component instance name");
        this.genname.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StarterPanel.this.componentname.setEditable(!StarterPanel.this.genname.isSelected());
                StarterPanel.this.numcomponents.setEnabled(StarterPanel.this.genname.isSelected());
            }
        });
        this.numcomponents = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        ((JSpinner.DefaultEditor)this.numcomponents.getEditor()).getTextField().setColumns(4);
        this.numcomponents.setEnabled(this.genname.isSelected());
        this.arguments = new JPanel(new GridBagLayout());
        this.results = new JPanel(new GridBagLayout());
        this.requiredservices = new JPanel(new BorderLayout());
        this.providedservices = new JPanel(new BorderLayout());
        JButton reload = new JButton("Reload");
        reload.setToolTipText("Reload the current model");
        reload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StarterPanel.this.reloadModel();
            }
        });
        int mw = (int)reload.getMinimumSize().getWidth();
        int pw = (int)reload.getPreferredSize().getWidth();
        int mh = (int)reload.getMinimumSize().getHeight();
        int ph = (int)reload.getPreferredSize().getHeight();
        this.start = new JButton("Start");
        this.start.setToolTipText("Start selected model");
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (StarterPanel.this.model != null) {
                    HashMap<String, String> rawargs = new HashMap<String, String>();
                    for (int i = 0; i < StarterPanel.this.argelems.size(); ++i) {
                        String argname = ((JLabel)StarterPanel.this.arguments.getComponent(i * 4 + 1)).getText();
                        String argval = ((JTextField)StarterPanel.this.arguments.getComponent(i * 4 + 3)).getText();
                        rawargs.put(argname, argval);
                    }
                    final IResourceIdentifier modelrid = StarterPanel.this.model.getResourceIdentifier();
                    SRemoteGui.parseArgs(rawargs, (IResourceIdentifier)modelrid, (IExternalAccess)jcc.getPlatformAccess()).addResultListener((IResultListener)new SwingDefaultResultListener<Map<String, Object>>((Component)StarterPanel.this){

                        public void customResultAvailable(Map<String, Object> args) {
                            String typename = StarterPanel.this.filename.getText();
                            String fullname = StarterPanel.this.model.getFullName();
                            IModelInfo mymodel = StarterPanel.this.model;
                            boolean dokilllis = StarterPanel.this.storeresults != null && StarterPanel.this.storeresults.isSelected();
                            String an = StarterPanel.this.genname.isSelected() ? null : StarterPanel.this.componentname.getText();
                            String configname = (String)StarterPanel.this.config.getModel().getSelectedItem();
                            int max = (Integer)StarterPanel.this.numcomponents.getValue();
                            if (an == null) {
                                for (int i = 0; i < max; ++i) {
                                    Future fut = new Future();
                                    KillListener killlistener = dokilllis ? new KillListener(mymodel, fullname, fut, StarterPanel.this) : null;
                                    StarterPanel.createComponent(StarterPanel.this.jcc, modelrid, typename, null, configname, args, StarterPanel.this.suspend.isSelected() ? Boolean.TRUE : Boolean.FALSE, StarterPanel.this.mastercb.isSelected() ? Boolean.TRUE : Boolean.FALSE, StarterPanel.this.daemoncb.isSelected() ? Boolean.TRUE : Boolean.FALSE, StarterPanel.this.autosdcb.isSelected() ? Boolean.TRUE : Boolean.FALSE, StarterPanel.this.synccb.isSelected() ? Boolean.TRUE : Boolean.FALSE, StarterPanel.this.perscb.isSelected() ? Boolean.TRUE : Boolean.FALSE, (IMonitoringService.PublishEventLevel)StarterPanel.this.monicb.getSelectedItem(), (IResultListener)killlistener, StarterPanel.this.parent, StarterPanel.this).addResultListener((IResultListener)new DelegationResultListener(fut));
                                }
                            } else {
                                Future fut = new Future();
                                KillListener killlistener = dokilllis ? new KillListener(mymodel, fullname, fut, StarterPanel.this) : null;
                                StarterPanel.createComponent(StarterPanel.this.jcc, modelrid, typename, an, configname, args, StarterPanel.this.suspend.isSelected() ? Boolean.TRUE : Boolean.FALSE, StarterPanel.this.mastercb.isSelected() ? Boolean.TRUE : Boolean.FALSE, StarterPanel.this.daemoncb.isSelected() ? Boolean.TRUE : Boolean.FALSE, StarterPanel.this.autosdcb.isSelected() ? Boolean.TRUE : Boolean.FALSE, StarterPanel.this.synccb.isSelected() ? Boolean.TRUE : Boolean.FALSE, StarterPanel.this.perscb.isSelected() ? Boolean.TRUE : Boolean.FALSE, (IMonitoringService.PublishEventLevel)StarterPanel.this.monicb.getSelectedItem(), (IResultListener)killlistener, StarterPanel.this.parent, StarterPanel.this).addResultListener((IResultListener)new DelegationResultListener(fut));
                            }
                        }
                    });
                }
            }
        });
        this.start.setMinimumSize(new Dimension(mw, mh));
        this.start.setPreferredSize(new Dimension(pw, ph));
        JButton reset = new JButton("Reset");
        reset.setToolTipText("Reset all fields");
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StarterPanel.this.reset();
            }
        });
        reset.setMinimumSize(new Dimension(mw, mh));
        reset.setPreferredSize(new Dimension(pw, ph));
        this.filename.setMinimumSize(this.filename.getMinimumSize());
        int y = 0;
        this.componentpanel = new JPanel(new GridBagLayout());
        this.componentnamel = new JLabel("Component name");
        this.componentpanel.add((Component)this.componentnamel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 2), 0, 0));
        JPanel tmp = new JPanel(new BorderLayout());
        tmp.add((Component)this.componentname, "Center");
        JPanel tmp2 = new JPanel(new BorderLayout());
        tmp2.add((Component)this.genname, "West");
        tmp2.add((Component)this.numcomponents, "East");
        tmp.add((Component)tmp2, "East");
        this.componentpanel.add((Component)tmp, new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 13, 1, new Insets(0, 2, 2, 2), 0, 0));
        this.componentpanel.add((Component)new JLabel("Parent"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 0, 0, 2), 0, 0));
        this.parenttf = new JTextField();
        this.parenttf.setEditable(false);
        this.componentpanel.add((Component)this.parenttf, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 13, 1, new Insets(2, 2, 0, 2), 0, 0));
        JButton chooseparent = new JButton(icons.getIcon("Browse"));
        chooseparent.setMargin(new Insets(0, 0, 0, 0));
        chooseparent.setToolTipText("Choose parent");
        this.componentpanel.add((Component)chooseparent, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(2, 2, 0, 2), 0, 0));
        final ComponentSelectorDialog agentselector = new ComponentSelectorDialog((Component)this, jcc.getPlatformAccess(), jcc.getJCCAccess(), jcc.getCMSHandler(), jcc.getPropertyHandler(), jcc.getIconCache());
        chooseparent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IComponentIdentifier paid = StarterPanel.this.parent;
                IComponentIdentifier newparent = agentselector.selectAgent(paid);
                if (newparent != null) {
                    StarterPanel.this.setParent(newparent);
                }
            }
        });
        JButton clearparent = new JButton(icons.getIcon("delete"));
        clearparent.setMargin(new Insets(0, 0, 0, 0));
        clearparent.setToolTipText("Clear parent");
        this.componentpanel.add((Component)clearparent, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(2, 2, 0, 2), 0, 0));
        clearparent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StarterPanel.this.setParent(null);
            }
        });
        JPanel flags = new JPanel(new FlowLayout(2, 0, 0));
        this.mastercb = new JCheckBox("Master");
        this.mastercb.setToolTipText("If a master component terminates the parent is killed as well");
        this.daemoncb = new JCheckBox("Daemon");
        this.daemoncb.setToolTipText("A daemon component does not prevent the parent component to terminate");
        this.autosdcb = new JCheckBox("Auto Shutdown");
        this.autosdcb.setToolTipText("Auto shutdown terminates a composite components when all (non daemon) components have terminated");
        this.monicb = new JComboBox<Object>(new Object[]{IMonitoringService.PublishEventLevel.OFF, IMonitoringService.PublishEventLevel.COARSE, IMonitoringService.PublishEventLevel.MEDIUM, IMonitoringService.PublishEventLevel.FINE});
        this.monicb.setToolTipText("Monitor the component. If turned on it will push events to the IMonitoringService of the platform.");
        this.synccb = new JCheckBox("Synchronous");
        this.synccb.setToolTipText("Run the component synchronously on the thread of its parent.");
        this.perscb = new JCheckBox("Persistable");
        this.perscb.setToolTipText("Persistable components are subject to auto persistence to free memory.");
        flags.add(this.suspend);
        flags.add(this.mastercb);
        flags.add(this.daemoncb);
        flags.add(this.autosdcb);
        flags.add(this.synccb);
        flags.add(new JLabel("Monitor "));
        flags.add(this.monicb);
        this.componentpanel.add((Component)new JLabel("Flags"), new GridBagConstraints(0, 2, 1, 0, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 2), 0, 0));
        this.componentpanel.add((Component)flags, new GridBagConstraints(1, 2, 4, 0, 0.0, 0.0, 17, 1, new Insets(2, 2, 0, 2), 0, 0));
        JPanel upper = new JPanel(new GridBagLayout());
        upper.setBorder(new TitledBorder(new EtchedBorder(1), " Settings "));
        this.filenamel = new JLabel("Filename");
        upper.add((Component)this.filenamel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        upper.add((Component)this.filename, new GridBagConstraints(1, y, 4, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.confl = new JLabel("Configuration");
        upper.add((Component)this.confl, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        upper.add((Component)this.config, new GridBagConstraints(1, y, 4, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        upper.add((Component)this.componentpanel, new GridBagConstraints(0, ++y, 5, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel middle = new JPanel(new GridBagLayout());
        y = 0;
        middle.add((Component)this.arguments, new GridBagConstraints(0, ++y, 5, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        middle.add((Component)this.results, new GridBagConstraints(0, ++y, 5, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        middle.add((Component)this.requiredservices, new GridBagConstraints(0, ++y, 5, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        middle.add((Component)this.providedservices, new GridBagConstraints(0, ++y, 5, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel buts = new JPanel(new GridBagLayout());
        buts.add((Component)this.start, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        buts.add((Component)reload, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        buts.add((Component)reset, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        upper.add((Component)buts, new GridBagConstraints(0, ++y, 5, 1, 1.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        y = 0;
        this.content.add((Component)upper, new GridBagConstraints(0, y, 5, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.componentnamel.setMinimumSize(this.confdummy.getMinimumSize());
        this.componentnamel.setPreferredSize(this.confdummy.getPreferredSize());
        this.filenamel.setMinimumSize(this.confdummy.getMinimumSize());
        this.filenamel.setPreferredSize(this.confdummy.getPreferredSize());
        this.confl.setMinimumSize(this.confdummy.getMinimumSize());
        this.confl.setPreferredSize(this.confdummy.getPreferredSize());
        this.details = new BrowserPane();
        this.splitpanel = new JSplitPanel(0);
        this.splitpanel.add((Component)new JScrollPane(middle));
        this.splitpanel.add((Component)new JScrollPane((Component)this.details));
        this.splitpanel.setOneTouchExpandable(true);
        this.splitpanel.setDividerLocation(0.3);
        this.content.add((Component)this.splitpanel, new GridBagConstraints(0, ++y, 5, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.loading = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }
        };
        JLabel label = new JLabel("Loading...", icons.getIcon("loading"), 0);
        label.setVerticalTextPosition(3);
        label.setHorizontalTextPosition(0);
        label.setForeground(Color.WHITE);
        label.setFont(label.getFont().deriveFont((float)label.getFont().getSize() * 2.0f));
        this.loading.add((Component)label, "Center");
        this.loading.setOpaque(false);
        this.loading.setBackground(new Color(0, 0, 0, 128));
        this.loading.setVisible(false);
        this.add((Component)this.content, (Object)0);
        this.add((Component)this.loading, (Object)1);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Container comp;
                int i;
                Rectangle bounds = StarterPanel.this.getBounds();
                Insets insets = StarterPanel.this.getInsets();
                bounds.x = insets.left;
                bounds.y = insets.top;
                bounds.width -= insets.left + insets.right;
                bounds.height -= insets.top + insets.bottom;
                StarterPanel.this.content.setBounds(bounds);
                StarterPanel.this.loading.setBounds(bounds);
                ArrayList<Component> comps = new ArrayList<Component>();
                comps.add(StarterPanel.this.content);
                comps.add(StarterPanel.this.loading);
                for (i = 0; i < comps.size(); ++i) {
                    comp = (Container)comps.get(i);
                    comp.invalidate();
                    for (int j = 0; j < comp.getComponentCount(); ++j) {
                        if (!(comp.getComponent(j) instanceof Container)) continue;
                        comps.add(i + 1, comp.getComponent(j));
                    }
                }
                for (i = 0; i < comps.size(); ++i) {
                    comp = (Container)comps.get(i);
                    comp.doLayout();
                    comp.repaint();
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    public void reloadModel() {
        if (this.lastfile == null) {
            return;
        }
        String toload = this.lastfile;
        IResourceIdentifier rid = this.lastrid;
        this.lastfile = null;
        this.lastrid = null;
        this.loadModel(toload, rid);
    }

    public IFuture loadModel(final String adf, final IResourceIdentifier rid) {
        final Future ret = new Future();
        if (adf != null && this.lastfile != null && SUtil.convertPathToRelative((String)adf).equals(SUtil.convertPathToRelative((String)this.lastfile))) {
            ret.setResult(null);
        } else {
            this.suspend.setSelected(false);
            this.daemoncb.setSelected(false);
            this.mastercb.setSelected(false);
            this.autosdcb.setSelected(false);
            this.synccb.setSelected(false);
            this.perscb.setSelected(false);
            this.monicb.setSelectedItem(IMonitoringService.PublishEventLevel.OFF);
            this.genname.setSelected(false);
            this.numcomponents.setValue(1);
            this.lastfile = adf;
            this.lastrid = rid;
            if (adf != null) {
                this.showLoading((IFuture)ret);
                SComponentFactory.isLoadable((IExternalAccess)this.jcc.getPlatformAccess(), (String)adf, (IResourceIdentifier)rid).addResultListener((IResultListener)new SwingDelegationResultListener(ret){

                    public void customResultAvailable(Object result) {
                        if (((Boolean)result).booleanValue()) {
                            SComponentFactory.loadModel((IExternalAccess)StarterPanel.this.jcc.getPlatformAccess(), (String)adf, (IResourceIdentifier)rid).addResultListener((IResultListener)new SwingDelegationResultListener(ret){

                                public void customResultAvailable(Object result) {
                                    StarterPanel.this.model = (IModelInfo)result;
                                    StarterPanel.this.updateGuiForNewModel(adf);
                                    ret.setResult(null);
                                }

                                public void customExceptionOccurred(Exception exception) {
                                    StarterPanel.this.model = null;
                                    StringWriter sw = new StringWriter();
                                    exception.printStackTrace(new PrintWriter(sw));
                                    StarterPanel.this.error = sw.toString();
                                    StarterPanel.this.updateGuiForNewModel(adf);
                                    ret.setResult(null);
                                }
                            });
                        } else {
                            StarterPanel.this.model = null;
                            StarterPanel.this.updateGuiForNewModel(adf);
                            ret.setResult(null);
                        }
                    }
                });
            } else {
                this.model = null;
                this.error = null;
                this.updateGuiForNewModel(null);
                ret.setResult(null);
            }
        }
        return ret;
    }

    protected void showLoading(IFuture fut) {
        this.loading.setVisible(true);
        this.loading.repaint();
        fut.addResultListener((IResultListener)new SwingDefaultResultListener(){

            public void customResultAvailable(Object result) {
                StarterPanel.this.loading.setVisible(false);
                StarterPanel.this.loading.repaint();
            }

            public void customExceptionOccurred(Exception exception) {
                StarterPanel.this.loading.setVisible(false);
                StarterPanel.this.loading.repaint();
            }
        });
    }

    void updateGuiForNewModel(String adf) {
        IErrorReport report;
        assert (SwingUtilities.isEventDispatchThread());
        ItemListener[] lis = this.config.getItemListeners();
        for (int i = 0; i < lis.length; ++i) {
            this.config.removeItemListener(lis[i]);
        }
        this.config.removeAllItems();
        String[] confignames = this.model != null ? this.model.getConfigurationNames() : SUtil.EMPTY_STRING_ARRAY;
        for (int i = 0; i < confignames.length; ++i) {
            ((DefaultComboBoxModel)this.config.getModel()).addElement(confignames[i]);
        }
        if (this.loadconfig != null) {
            this.config.getModel().setSelectedItem(this.loadconfig);
            this.loadconfig = null;
        } else if (confignames.length > 0) {
            this.config.getModel().setSelectedItem(confignames[0]);
        }
        if (this.model != null && this.model.isStartable() && this.model.getReport() == null) {
            this.createArguments();
            this.createResults();
            this.createRequiredServices();
            this.createProvidedServices();
            this.arguments.setVisible(true);
            this.results.setVisible(true);
            this.componentpanel.setVisible(true);
            this.start.setVisible(true);
            this.filenamel.setMinimumSize(this.confdummy.getMinimumSize());
            this.filenamel.setPreferredSize(this.confdummy.getPreferredSize());
            this.confl.setMinimumSize(this.confdummy.getMinimumSize());
            this.confl.setPreferredSize(this.confdummy.getPreferredSize());
            this.componentnamel.setMinimumSize(this.confdummy.getMinimumSize());
            this.componentnamel.setPreferredSize(this.confdummy.getPreferredSize());
            this.componentname.setText(this.loadname != null ? this.loadname : this.model.getName());
            this.loadname = null;
        } else {
            this.arguments.setVisible(false);
            this.results.setVisible(false);
            this.componentpanel.setVisible(false);
            this.start.setVisible(false);
            this.filenamel.setMinimumSize(this.confdummy.getMinimumSize());
            this.filenamel.setPreferredSize(this.confdummy.getPreferredSize());
            this.confl.setMinimumSize(this.confdummy.getMinimumSize());
            this.confl.setPreferredSize(this.confdummy.getPreferredSize());
            this.componentname.setText("");
        }
        this.filename.setText(adf);
        if (this.model != null) {
            this.refreshFlags();
        }
        IErrorReport iErrorReport = report = this.model != null ? this.model.getReport() : null;
        if (report != null) {
            this.details.setExternals(report.getDocuments());
            this.details.setText(report.getErrorHTML());
        } else if (this.model != null) {
            this.details.setExternals(null);
            this.details.setText(this.model.getDescription());
        } else if (this.error != null) {
            this.details.setExternals(null);
            this.details.setText("<pre>" + this.error + "</pre>");
        } else {
            this.details.setExternals(null);
            this.details.setText("");
        }
        this.start.setEnabled(this.model != null && this.model.isStartable() && report == null);
        for (int i = 0; i < lis.length; ++i) {
            this.config.addItemListener(lis[i]);
        }
        if (this.arguments.getComponentCount() == 0 && this.results.getComponentCount() == 0 && this.providedservices.getComponentCount() == 0 && this.requiredservices.getComponentCount() == 0) {
            if (!this.closed) {
                this.lastdivloc = this.splitpanel.getProportionalDividerLocation();
                this.closed = true;
            }
            this.splitpanel.setDividerLocation(0);
        } else if (this.closed) {
            this.splitpanel.setDividerLocation(this.lastdivloc);
            this.closed = false;
        }
    }

    protected void refreshFlags() {
        if (this.model != null) {
            String c = (String)this.config.getSelectedItem();
            boolean s = this.model.getSuspend(c) == null ? this.suspend.isSelected() : this.model.getSuspend(c).booleanValue();
            boolean m = this.model.getMaster(c) == null ? this.mastercb.isSelected() : this.model.getMaster(c).booleanValue();
            boolean d = this.model.getDaemon(c) == null ? this.daemoncb.isSelected() : this.model.getDaemon(c).booleanValue();
            boolean a = this.model.getAutoShutdown(c) == null ? this.autosdcb.isSelected() : this.model.getAutoShutdown(c).booleanValue();
            boolean sy = this.model.getSynchronous(c) == null ? this.synccb.isSelected() : this.model.getSynchronous(c).booleanValue();
            boolean pe = this.model.getPersistable(c) == null ? this.perscb.isSelected() : this.model.getPersistable(c).booleanValue();
            IMonitoringService.PublishEventLevel mo = this.model.getMonitoring(c) == null ? (IMonitoringService.PublishEventLevel)this.monicb.getSelectedItem() : this.model.getMonitoring(c);
            this.suspend.setSelected(s);
            this.mastercb.setSelected(m);
            this.daemoncb.setSelected(d);
            this.autosdcb.setSelected(a);
            this.monicb.setSelectedItem(mo);
            this.synccb.setSelected(sy);
        }
    }

    public IFuture<Properties> getProperties() {
        final Future ret = new Future();
        Future mfut = new Future();
        if (this.filename.getText().length() == 0) {
            mfut.setResult(null);
        } else {
            SRemoteGui.localizeModel((IExternalAccess)this.jcc.getPlatformAccess(), (String)this.filename.getText(), (IResourceIdentifier)this.lastrid).addResultListener((IResultListener)new DelegationResultListener(mfut));
        }
        mfut.addResultListener((IResultListener)new SwingExceptionDelegationResultListener<Tuple2<String, String>, Properties>(ret){

            public void customResultAvailable(Tuple2<String, String> result) {
                String c;
                Properties props = new Properties();
                if (result != null) {
                    props.addProperty(new Property("model", (String)result.getFirstEntity()));
                    props.addProperty(new Property("ridurl", (String)result.getSecondEntity()));
                    String id = StarterPanel.this.lastrid != null && StarterPanel.this.lastrid.getGlobalIdentifier() != null && StarterPanel.this.lastrid.getGlobalIdentifier().getResourceId() != null && !ResourceIdentifier.isHashGid((IResourceIdentifier)StarterPanel.this.lastrid) ? StarterPanel.this.lastrid.getGlobalIdentifier().getResourceId() : null;
                    props.addProperty(new Property("globalrid", id));
                }
                if ((c = (String)StarterPanel.this.config.getSelectedItem()) != null) {
                    props.addProperty(new Property("config", c));
                }
                props.addProperty(new Property("startsuspended", "" + StarterPanel.this.suspend.isSelected()));
                props.addProperty(new Property("autogenerate", "" + StarterPanel.this.genname.isSelected()));
                props.addProperty(new Property("number", "" + StarterPanel.this.numcomponents.getValue()));
                props.addProperty(new Property("name", StarterPanel.this.componentname.getText()));
                for (int i = 0; StarterPanel.this.argelems != null && i < StarterPanel.this.argelems.size(); ++i) {
                    JTextField valt = (JTextField)StarterPanel.this.arguments.getComponent(i * 4 + 3);
                    props.addProperty(new Property("argument", valt.getText()));
                }
                ret.setResult((Object)props);
            }
        });
        return ret;
    }

    public IFuture<Void> setProperties(final Properties props) {
        final Future ret = new Future();
        String ridurl = props.getStringProperty("ridurl");
        String globalrid = props.getStringProperty("globalrid");
        SRemoteGui.createResourceIdentifier((IExternalAccess)this.jcc.getPlatformAccess(), (String)ridurl, (String)globalrid).addResultListener((IResultListener)new SwingExceptionDelegationResultListener<IResourceIdentifier, Void>(ret){

            public void customResultAvailable(IResourceIdentifier rid) {
                StarterPanel.this.lastrid = rid;
                Property[] aargs = props.getProperties("argument");
                StarterPanel.this.loadargs = new String[aargs.length];
                for (int i = 0; i < aargs.length; ++i) {
                    StarterPanel.this.loadargs[i] = aargs[i].getValue();
                }
                String mo = props.getStringProperty("model");
                if (mo != null) {
                    StarterPanel.this.lastfile = mo;
                    StarterPanel.this.loadconfig = props.getStringProperty("config");
                    StarterPanel.this.loadname = props.getStringProperty("name");
                    StarterPanel.this.reloadModel();
                }
                StarterPanel.this.setStartSuspended(props.getBooleanProperty("startsuspended"));
                StarterPanel.this.setAutoGenerate(props.getBooleanProperty("autogenerate"));
                StarterPanel.this.numcomponents.setValue(props.getIntProperty("number"));
                ret.setResult(null);
            }
        });
        return ret;
    }

    public void reset() {
        this.loadargs = null;
        this.filename.setText("");
        this.loadModel(null, null);
        this.config.removeAllItems();
        this.clearArguments();
        this.clearResults();
        this.setComponentName("");
    }

    protected void selectConfiguration(String conf) {
        if (conf != null) {
            this.config.getModel().setSelectedItem(conf);
        }
    }

    protected void refreshArguments() {
        if (this.model == null || this.arguments == null || this.argelems == null) {
            return;
        }
        for (int i = 0; this.argelems != null && i < this.argelems.size(); ++i) {
            JTextField valt = (JTextField)this.arguments.getComponent(i * 4 + 2);
            valt.setText(this.getDefaultValue(this.model, ((IArgument)this.argelems.get(i)).getName(), (String)this.config.getSelectedItem()));
        }
    }

    protected void refreshDefaultResults() {
        if (this.model == null || this.results == null || this.reselems == null) {
            return;
        }
        for (int i = 0; this.reselems != null && i < this.reselems.size(); ++i) {
            JTextField valt = (JTextField)this.results.getComponent(i * 4 + 2);
            valt.setText(this.getResultDefaultValue(this.model, ((IArgument)this.reselems.get(i)).getName(), (String)this.config.getSelectedItem()));
        }
    }

    protected void clearArguments() {
        if (this.arguments == null || this.argelems == null) {
            return;
        }
        for (int i = 0; i < this.argelems.size(); ++i) {
            JTextField valt = (JTextField)this.arguments.getComponent(i * 4 + 3);
            valt.setText("");
        }
    }

    protected void createArguments() {
        this.argelems = SCollection.createArrayList();
        this.arguments.removeAll();
        this.arguments.setBorder(null);
        if (this.model != null) {
            IArgument[] args = this.model.getArguments();
            for (int i = 0; i < args.length; ++i) {
                this.argelems.add(args[i]);
                this.createArgumentGui(args[i], i);
            }
            this.loadargs = null;
            if (args.length > 0) {
                this.arguments.setBorder(new TitledBorder(new EtchedBorder(1), " Arguments "));
            }
        }
    }

    protected void refreshResults() {
        if (this.model == null || this.results == null || this.reselems == null) {
            return;
        }
        Map mres = null;
        int sel = this.selectavail.getSelectedIndex();
        if (sel > 0) {
            List rs = (List)this.resultsets.get((Object)this.model.getFullName());
            Object[] r = rs != null && sel - 1 < rs.size() ? (Object[])rs.get(sel - 1) : null;
            mres = r != null ? (Map)r[1] : null;
        }
        for (int i = 0; this.reselems != null && i < this.reselems.size(); ++i) {
            IArgument arg = (IArgument)this.reselems.get(i);
            String value = mres != null ? mres.get(arg.getName()) : "";
            JTextField valt = (JTextField)this.results.getComponent(i * 4 + 3);
            valt.setText("" + value);
        }
    }

    protected void clearResults() {
        if (this.results == null || this.reselems == null) {
            return;
        }
        for (int i = 0; i < this.reselems.size(); ++i) {
            JTextField valt = (JTextField)this.results.getComponent(i * 4 + 3);
            valt.setText("");
        }
    }

    protected void createResults() {
        this.reselems = SCollection.createArrayList();
        this.results.removeAll();
        this.results.setBorder(null);
        if (this.model != null) {
            IArgument[] res = this.model.getResults();
            for (int i = 0; i < res.length; ++i) {
                this.reselems.add(res[i]);
                this.createResultGui(res[i], i);
            }
            if (res.length > 0) {
                this.results.setBorder(new TitledBorder(new EtchedBorder(1), " Results "));
                JLabel sr = new JLabel("Store results");
                this.storeresults = new JCheckBox();
                JButton cr = new JButton("Clear results");
                JLabel sa = new JLabel("Select component instance");
                this.selectavail = new FixedJComboBox();
                this.selectavail.addItem("- no instance selected -");
                cr.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StarterPanel.this.storeresults.removeAll();
                        StarterPanel.this.selectavail.removeAllItems();
                        StarterPanel.this.selectavail.addItem("- no instance selected -");
                        StarterPanel.this.clearResults();
                    }
                });
                List rs = (List)this.resultsets.get((Object)this.model.getFullName());
                if (rs != null) {
                    for (int i = 0; i < rs.size(); ++i) {
                        Object[] r = (Object[])rs.get(i);
                        this.selectavail.addItem(r[0]);
                    }
                    this.selectavail.setSelectedIndex(0);
                }
                this.selectavail.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StarterPanel.this.refreshResults();
                    }
                });
                int y = res.length;
                this.results.add((Component)sr, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 1, new Insets(2, 2, 2, 0), 0, 0));
                this.results.add((Component)this.storeresults, new GridBagConstraints(1, y, 2, 1, 0.0, 0.0, 17, 1, new Insets(2, 0, 2, 2), 0, 0));
                this.results.add((Component)cr, new GridBagConstraints(3, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 2), 0, 0));
                this.results.add((Component)sa, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
                this.results.add((Component)this.selectavail, new GridBagConstraints(1, y, 3, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
            }
        }
    }

    protected void createArgumentGui(IArgument arg, int y) {
        JLabel namel = new JLabel(arg.getName());
        final JValidatorTextField valt = new JValidatorTextField(this.loadargs != null && this.loadargs.length > y ? this.loadargs[y] : "", 15);
        this.jcc.getClassLoader(this.model.getResourceIdentifier()).addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<ClassLoader>(){

            public void resultAvailable(ClassLoader result) {
                try {
                    valt.setValidator((IValidator)new ParserValidator(result));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void exceptionOccurred(Exception exception) {
            }
        }));
        String configname = (String)this.config.getSelectedItem();
        JTextField mvalt = new JTextField(this.getDefaultValue(this.model, arg.getName(), configname));
        mvalt.setEditable(false);
        JLabel typel = new JLabel(arg.getClazz() != null ? arg.getClazz().getTypeName() : "undefined");
        String description = arg.getDescription();
        if (description != null) {
            namel.setToolTipText(description);
            valt.setToolTipText(description);
            mvalt.setToolTipText(description);
        }
        int x = 0;
        this.arguments.add((Component)typel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.arguments.add((Component)namel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.arguments.add((Component)mvalt, new GridBagConstraints(x++, y, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.arguments.add((Component)valt, new GridBagConstraints(x++, y, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    protected void createResultGui(IArgument arg, int y) {
        JLabel namel = new JLabel(arg.getName());
        JTextField valt = new JTextField();
        valt.setEditable(false);
        String configname = (String)this.config.getSelectedItem();
        JTextField mvalt = new JTextField(this.getResultDefaultValue(this.model, arg.getName(), configname));
        mvalt.setEditable(false);
        JLabel typel = new JLabel(arg.getClazz() != null ? arg.getClazz().getTypeName() : "undefined");
        String description = arg.getDescription();
        if (description != null) {
            namel.setToolTipText(description);
            valt.setToolTipText(description);
            mvalt.setToolTipText(description);
        }
        int x = 0;
        this.results.add((Component)typel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.results.add((Component)namel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.results.add((Component)mvalt, new GridBagConstraints(x++, y, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.results.add((Component)valt, new GridBagConstraints(x++, y, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    protected void createRequiredServices() {
        this.requiredservices.removeAll();
        this.requiredservices.setBorder(null);
        if (this.model != null) {
            RequiredServiceInfo[] required = this.model.getRequiredServices();
            if (required.length > 0) {
                JTable requiredt = new JTable(new DefaultTableModel(new String[]{"Name", "Interface", "Multiple"}, 0));
                requiredt.setEnabled(false);
                this.requiredservices.add((Component)requiredt.getTableHeader(), "North");
                this.requiredservices.add((Component)requiredt, "Center");
                for (int i = 0; i < required.length; ++i) {
                    ((DefaultTableModel)requiredt.getModel()).addRow(new Object[]{required[i].getName(), SReflect.getUnqualifiedTypeName((String)required[i].getType().getTypeName()), required[i].isMultiple()});
                }
            }
            if (required.length > 0) {
                this.requiredservices.setBorder(new TitledBorder(new EtchedBorder(1), " Required Services "));
            }
        }
    }

    protected void createProvidedServices() {
        this.providedservices.removeAll();
        this.providedservices.setBorder(null);
        if (this.model != null) {
            ProvidedServiceInfo[] provided = this.model.getProvidedServices();
            if (provided.length > 0) {
                JTable providedt = new JTable(new DefaultTableModel(new String[]{"Interface", "Creation Expression"}, 0));
                providedt.setEnabled(false);
                this.providedservices.add((Component)providedt.getTableHeader(), "North");
                this.providedservices.add((Component)providedt, "Center");
                for (int i = 0; i < provided.length; ++i) {
                    ((DefaultTableModel)providedt.getModel()).addRow(new Object[]{provided[i] != null ? SReflect.getUnqualifiedTypeName((String)provided[i].getType().getTypeName()) : "unknown service type (class definition missing)", provided[i] != null ? provided[i].getImplementation() : ""});
                }
            }
            if (provided.length > 0) {
                this.providedservices.setBorder(new TitledBorder(new EtchedBorder(1), " Provided Services "));
            }
        }
    }

    protected void setComponentName(String name) {
        if (name != null) {
            this.componentname.setText(name);
        }
    }

    protected void clearApplicationName() {
    }

    protected void setAutoGenerate(boolean autogen) {
        this.genname.setSelected(autogen);
        this.componentname.setEditable(!autogen);
        this.numcomponents.setEnabled(autogen);
    }

    protected void setStartSuspended(boolean startsuspended) {
        this.suspend.setSelected(startsuspended);
    }

    public void setParent(IComponentIdentifier parent) {
        this.parent = parent;
        this.parenttf.setText(parent != null ? parent.getName() : "");
    }

    public static IFuture createComponent(final IControlCenter jcc, final IResourceIdentifier rid, final String type, final String name, final String configname, final Map arguments, final Boolean suspend, final Boolean master, final Boolean daemon, final Boolean autosd, final Boolean sync, final Boolean pers, final IMonitoringService.PublishEventLevel moni, final IResultListener killlistener, final IComponentIdentifier parco, JComponent panel) {
        final Future ret = new Future();
        SServiceProvider.getService((IExternalAccess)jcc.getPlatformAccess(), IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new SwingDefaultResultListener<IComponentManagementService>((Component)panel){

            public void customResultAvailable(IComponentManagementService cms) {
                cms.createComponent(name, type, new CreationInfo(configname, arguments, parco, suspend, master, daemon, autosd, sync, pers, moni, null, null, rid), killlistener).addResultListener(new IResultListener(){

                    public void resultAvailable(Object result) {
                        ret.setResult(result);
                        jcc.setStatusText("Created component: " + ((IComponentIdentifier)result).getLocalName());
                    }

                    public void exceptionOccurred(Exception exception) {
                        ret.setException(exception);
                        jcc.displayError("Problem Starting Component", "Component could not be started.", exception);
                    }
                });
            }
        });
        return ret;
    }

    public String getDefaultValue(IModelInfo model, String arg, String config) {
        IArgument iarg;
        ConfigurationInfo ci;
        String ret = null;
        ConfigurationInfo configurationInfo = ci = config != null ? model.getConfiguration(config) : null;
        if (ci != null) {
            UnparsedExpression[] upes = ci.getArguments();
            for (int i = 0; ret == null && i < upes.length; ++i) {
                if (!upes[i].getName().equals(arg)) continue;
                ret = upes[i].getValue() != null ? upes[i].getValue() : "";
            }
        }
        if (ret == null && (iarg = model.getArgument(arg)) != null) {
            String string = iarg.getDefaultValue() instanceof UnparsedExpression ? (iarg.getDefaultValue().getValue() != null ? iarg.getDefaultValue().getValue() : "") : (ret = "" + iarg.getDefaultValue());
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public String getResultDefaultValue(IModelInfo model, String arg, String config) {
        IArgument iarg;
        ConfigurationInfo ci;
        String ret = null;
        ConfigurationInfo configurationInfo = ci = config != null ? model.getConfiguration(config) : null;
        if (ci != null) {
            UnparsedExpression[] upes = ci.getResults();
            for (int i = 0; ret == null && i < upes.length; ++i) {
                if (!upes[i].getName().equals(arg)) continue;
                ret = upes[i].getValue() != null ? upes[i].getValue() : "";
            }
        }
        if (ret == null && (iarg = model.getResult(arg)) != null) {
            String string = iarg.getDefaultValue() instanceof UnparsedExpression ? (iarg.getDefaultValue().getValue() != null ? iarg.getDefaultValue().getValue() : "") : (ret = "" + iarg.getDefaultValue());
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public class KillListener
    extends SwingDefaultResultListener<Collection<Tuple2<String, Object>>> {
        protected IModelInfo model;
        protected String fullname;
        protected IComponentIdentifier cid;

        public KillListener(IModelInfo model, String fullname, Future fut, Component parent) {
            super(parent);
            this.model = model;
            this.fullname = fullname;
            fut.addResultListener(new IResultListener(){

                public void resultAvailable(Object result) {
                    KillListener.this.cid = (IComponentIdentifier)result;
                }

                public void exceptionOccurred(Exception exception) {
                }
            });
        }

        public void customResultAvailable(Collection<Tuple2<String, Object>> result) {
            HashMap<Object, Object> res = null;
            if (result != null) {
                res = new HashMap<Object, Object>();
                for (Tuple2<String, Object> tup : result) {
                    res.put(tup.getFirstEntity(), tup.getSecondEntity());
                }
            }
            if (this.cid != null) {
                String tmp = this.model.getFullName();
                StarterPanel.this.resultsets.add((Object)tmp, (Object)new Object[]{this.cid, res});
                if (this.fullname.equals(this.model.getFullName())) {
                    StarterPanel.this.selectavail.addItem(this.cid);
                    StarterPanel.this.refreshResults();
                }
            } else {
                this.exceptionOccurred(new RuntimeException("Unknown component identifier."));
            }
        }
    }
}

