/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.starter;

import jadex.base.gui.ComponentIdentifierDialog;
import jadex.base.gui.modeltree.AddPathAction;
import jadex.base.gui.modeltree.AddRIDAction;
import jadex.base.gui.modeltree.CollapseAllAction;
import jadex.base.gui.modeltree.RemovePathAction;
import jadex.base.gui.plugin.AbstractJCCPlugin;
import jadex.base.gui.plugin.SJCC;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.Properties;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.SGUI;
import jadex.tools.starter.StarterPluginPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;

public class StarterPlugin
extends AbstractJCCPlugin {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"starter", SGUI.makeIcon(StarterPlugin.class, (String)"/jadex/tools/common/images/new_starter.png"), "starter_sel", SGUI.makeIcon(StarterPlugin.class, (String)"/jadex/tools/common/images/new_starter_sel.png"), "add_remote_component", SGUI.makeIcon(StarterPlugin.class, (String)"/jadex/tools/common/images/add_remote_component.png"), "kill_platform", SGUI.makeIcon(StarterPlugin.class, (String)"/jadex/tools/common/images/new_killplatform.png")});
    final AbstractAction KILL_PLATFORM = new AbstractAction("Kill platform", icons.getIcon("kill_platform")){

        @Override
        public void actionPerformed(ActionEvent e) {
            SJCC.killPlattform((IExternalAccess)StarterPlugin.this.getJCC().getPlatformAccess(), (Component)StarterPlugin.this.getView());
        }
    };
    final AbstractAction ADD_REMOTE_COMPONENT = new AbstractAction("Add remote component", icons.getIcon("add_remote_component")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComponentIdentifierDialog dia = new ComponentIdentifierDialog((Component)StarterPlugin.this.getView(), StarterPlugin.this.jcc.getPlatformAccess());
            final IComponentIdentifier cid = dia.getComponentIdentifier(null);
            if (cid != null) {
                final HashMap<String, IComponentIdentifier> args = new HashMap<String, IComponentIdentifier>();
                args.put("component", cid);
                SServiceProvider.getService((IExternalAccess)StarterPlugin.this.getJCC().getPlatformAccess(), IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new DefaultResultListener(){

                    public void resultAvailable(Object result) {
                        IComponentManagementService cms = (IComponentManagementService)result;
                        cms.createComponent(cid.getLocalName(), "jadex/platform/service/remote/ProxyAgent.class", new CreationInfo(args), null).addResultListener(new IResultListener(){

                            public void resultAvailable(Object result) {
                                StarterPlugin.this.getJCC().setStatusText("Created component: " + ((IComponentIdentifier)result).getLocalName());
                            }

                            public void exceptionOccurred(Exception exception) {
                                StarterPlugin.this.getJCC().displayError("Problem Starting Component", "Component could not be started.", exception);
                            }
                        });
                    }
                });
            }
        }
    };

    public String getName() {
        return "Starter";
    }

    public IFuture setProperties(Properties props) {
        return ((StarterPluginPanel)this.getView()).setProperties(props);
    }

    public IFuture getProperties() {
        return ((StarterPluginPanel)this.getView()).getProperties();
    }

    public IFuture pushPlatformSettings() {
        return ((StarterPluginPanel)this.getView()).pushPlatformProperties();
    }

    public Icon getToolIcon(boolean selected) {
        return selected ? icons.getIcon("starter_sel") : icons.getIcon("starter");
    }

    public JComponent[] createToolBar() {
        ArrayList<JComponent> ret = new ArrayList<JComponent>();
        JButton b = new JButton(((StarterPluginPanel)this.getView()).getModelTreePanel().getAction(AddPathAction.getName()));
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        ret.add(b);
        Action a = ((StarterPluginPanel)this.getView()).getModelTreePanel().getAction(AddRIDAction.getName());
        b = new JButton(a);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(a.isEnabled());
        ret.add(b);
        b = new JButton(((StarterPluginPanel)this.getView()).getModelTreePanel().getAction(RemovePathAction.getName()));
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        ret.add(b);
        b = new JButton(((StarterPluginPanel)this.getView()).getModelTreePanel().getAction(CollapseAllAction.getName()));
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        ret.add(b);
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setOrientation(1);
        ret.add(separator);
        b = new JButton(this.ADD_REMOTE_COMPONENT);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        ret.add(b);
        return ret.toArray(new JComponent[ret.size()]);
    }

    public JComponent createView() {
        return new StarterPluginPanel(this.getJCC());
    }

    public IFuture<Void> shutdown() {
        ((StarterPluginPanel)this.getView()).dispose();
        return super.shutdown();
    }
}

