/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.starter;

import jadex.base.SRemoteGui;
import jadex.base.gui.asynctree.INodeListener;
import jadex.base.gui.asynctree.ISwingNodeHandler;
import jadex.base.gui.asynctree.ISwingTreeNode;
import jadex.base.gui.asynctree.ITreeNode;
import jadex.base.gui.componenttree.ComponentTreePanel;
import jadex.base.gui.componenttree.IActiveComponentTreeNode;
import jadex.base.gui.filetree.IFileNode;
import jadex.base.gui.modeltree.ModelTreePanel;
import jadex.base.gui.plugin.AbstractJCCPlugin;
import jadex.base.gui.plugin.IControlCenter;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IResourceIdentifier;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.factory.SComponentFactory;
import jadex.bridge.service.types.settings.ISettingsService;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.SUtil;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.JSplitPanel;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.future.SwingDelegationResultListener;
import jadex.commons.gui.future.SwingResultListener;
import jadex.tools.starter.StarterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class StarterPluginPanel
extends JPanel {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"add_remote_component", SGUI.makeIcon(StarterPluginPanel.class, (String)"/jadex/tools/common/images/add_remote_component.png"), "kill_platform", SGUI.makeIcon(StarterPluginPanel.class, (String)"/jadex/tools/common/images/new_killplatform.png"), "starter", SGUI.makeIcon(StarterPluginPanel.class, (String)"/jadex/tools/common/images/new_starter.png"), "starter_sel", SGUI.makeIcon(StarterPluginPanel.class, (String)"/jadex/tools/common/images/new_starter_sel.png"), "start_component", SGUI.makeIcon(StarterPluginPanel.class, (String)"/jadex/tools/common/images/start.png"), "checking_menu", SGUI.makeIcon(StarterPluginPanel.class, (String)"/jadex/tools/common/images/new_agent_broken.png")});
    protected StarterPanel spanel;
    protected ModelTreePanel mpanel;
    protected ComponentTreePanel comptree;
    protected JSplitPanel lsplit;
    protected JSplitPanel csplit;
    protected IControlCenter jcc;

    public StarterPluginPanel(final IControlCenter jcc) {
        super(new BorderLayout());
        this.jcc = jcc;
        this.csplit = new JSplitPanel(1, true);
        this.csplit.setOneTouchExpandable(true);
        this.lsplit = new JSplitPanel(0, true);
        this.lsplit.setOneTouchExpandable(true);
        this.lsplit.setResizeWeight(0.7);
        this.mpanel = new ModelTreePanel(jcc.getPlatformAccess(), jcc.getJCCAccess(), !SUtil.equals((Object)jcc.getPlatformAccess().getComponentIdentifier().getPlatformName(), (Object)jcc.getJCCAccess().getComponentIdentifier().getPlatformName())){

            public void removeTopLevelNode(ISwingTreeNode node) {
                super.removeTopLevelNode(node);
                if (node instanceof IFileNode && StarterPluginPanel.this.spanel != null && StarterPluginPanel.this.spanel.lastfile != null) {
                    String path = ((IFileNode)node).getFilePath();
                    final String model = StarterPluginPanel.this.spanel.lastfile;
                    SRemoteGui.matchModel((String)path, (String)model, (IExternalAccess)jcc.getPlatformAccess()).addResultListener((IResultListener)new SwingDefaultResultListener<Boolean>(){

                        public void customResultAvailable(Boolean result) {
                            if (result.booleanValue() && model.equals(StarterPluginPanel.this.spanel.lastfile)) {
                                StarterPluginPanel.this.spanel.loadModel(null, null);
                            }
                        }

                        public void customExceptionOccurred(Exception exception) {
                        }
                    });
                }
            }
        };
        this.mpanel.getModel().addNodeListener(new INodeListener(){

            public void nodeRemoved(ITreeNode node) {
                StarterPluginPanel.this.pushPlatformProperties();
            }

            public void nodeAdded(ITreeNode node) {
                StarterPluginPanel.this.pushPlatformProperties();
            }
        });
        this.mpanel.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object node = StarterPluginPanel.this.mpanel.getTree().getLastSelectedPathComponent();
                String filename = null;
                if (node instanceof IFileNode) {
                    StarterPluginPanel.this.mpanel.setCursor(Cursor.getPredefinedCursor(3));
                    filename = ((IFileNode)node).getFilePath();
                }
                if (filename != null) {
                    final String ffilename = filename;
                    StarterPluginPanel.this.createResourceIdentifier().addResultListener((IResultListener)new SwingResultListener((IResultListener)new IResultListener<IResourceIdentifier>(){

                        public void resultAvailable(final IResourceIdentifier rid) {
                            SComponentFactory.isLoadable((IExternalAccess)jcc.getPlatformAccess(), (String)ffilename, (IResourceIdentifier)rid).addResultListener((IResultListener)new SwingDefaultResultListener(StarterPluginPanel.this.spanel){

                                public void customResultAvailable(Object result) {
                                    if (((Boolean)result).booleanValue()) {
                                        StarterPluginPanel.this.spanel.loadModel(ffilename, rid);
                                    }
                                    StarterPluginPanel.this.mpanel.setCursor(Cursor.getPredefinedCursor(0));
                                }
                            });
                        }

                        public void exceptionOccurred(Exception exception) {
                            jcc.setStatusText("Error refreshing selection: " + exception.getMessage());
                        }
                    }));
                }
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Object node;
                int row = StarterPluginPanel.this.mpanel.getTree().getRowForLocation(e.getX(), e.getY());
                if (row != -1 && e.getClickCount() == 2 && (node = StarterPluginPanel.this.mpanel.getTree().getLastSelectedPathComponent()) instanceof IFileNode) {
                    if (((IFileNode)node).isDirectory()) {
                        if (StarterPluginPanel.this.mpanel.getTree().isExpanded(row)) {
                            StarterPluginPanel.this.mpanel.getTree().collapseRow(row);
                        } else {
                            StarterPluginPanel.this.mpanel.getTree().expandRow(row);
                        }
                    } else {
                        StarterPluginPanel.this.mpanel.setCursor(Cursor.getPredefinedCursor(3));
                        final String filename = ((IFileNode)node).getFilePath();
                        StarterPluginPanel.this.createResourceIdentifier().addResultListener((IResultListener)new SwingDefaultResultListener<IResourceIdentifier>((Component)StarterPluginPanel.this.mpanel){

                            public void customResultAvailable(final IResourceIdentifier rid) {
                                SComponentFactory.isStartable((IExternalAccess)jcc.getPlatformAccess(), (String)filename, (IResourceIdentifier)rid).addResultListener((IResultListener)new SwingDefaultResultListener(StarterPluginPanel.this.spanel){

                                    public void customResultAvailable(Object result) {
                                        if (((Boolean)result).booleanValue()) {
                                            StarterPanel.createComponent(jcc, rid, filename, null, null, null, null, false, null, null, null, null, null, null, null, StarterPluginPanel.this);
                                        }
                                        StarterPluginPanel.this.mpanel.setCursor(Cursor.getPredefinedCursor(0));
                                    }
                                });
                            }
                        });
                    }
                }
            }
        };
        this.mpanel.getTree().addMouseListener(ml);
        this.comptree = new ComponentTreePanel(jcc.getPlatformAccess(), jcc.getJCCAccess(), jcc.getCMSHandler(), jcc.getPropertyHandler(), jcc.getIconCache(), 1);
        this.comptree.setMinimumSize(new Dimension(0, 0));
        this.comptree.getModel().addNodeListener(new INodeListener(){

            public void nodeRemoved(ITreeNode node) {
                if (node instanceof IActiveComponentTreeNode && ((IActiveComponentTreeNode)node).getDescription().getName().equals(StarterPluginPanel.this.spanel.parent)) {
                    StarterPluginPanel.this.spanel.setParent(null);
                }
            }

            public void nodeAdded(ITreeNode node) {
            }
        });
        this.comptree.addNodeHandler((ISwingNodeHandler)new AbstractJCCPlugin.ShowRemoteControlCenterHandler(jcc, (Component)this));
        this.lsplit.add((Component)this.mpanel);
        this.lsplit.add((Component)this.comptree);
        this.lsplit.setResizeWeight(0.7);
        this.lsplit.setDividerLocation(0.7);
        this.csplit.add((Component)this.lsplit);
        this.spanel = new StarterPanel(jcc);
        this.csplit.add((Component)this.spanel);
        this.csplit.setResizeWeight(0.3);
        this.csplit.setDividerLocation(0.3);
        this.add((Component)this.csplit, "Center");
        this.loadPlatformProperties();
    }

    public IFuture<IResourceIdentifier> createResourceIdentifier() {
        TreePath selpath = this.mpanel.getTree().getSelectionModel().getSelectionPath();
        ITreeNode root = (ITreeNode)selpath.getPathComponent(1);
        String filename = ((IFileNode)root).getFilePath();
        return ModelTreePanel.createResourceIdentifier((IExternalAccess)this.jcc.getPlatformAccess(), (String)filename);
    }

    public ModelTreePanel getModelTreePanel() {
        return this.mpanel;
    }

    public ComponentTreePanel getComponentTreePanel() {
        return this.comptree;
    }

    public IFuture loadPlatformProperties() {
        final Future ret = new Future();
        SServiceProvider.getService((IExternalAccess)this.jcc.getPlatformAccess(), ISettingsService.class, (String)"platform").addResultListener((IResultListener)new SwingDelegationResultListener(ret){

            public void customResultAvailable(Object result) {
                ISettingsService settings = (ISettingsService)result;
                settings.getProperties("StarterServicePanel").addResultListener((IResultListener)new SwingDelegationResultListener(ret){

                    public void customResultAvailable(Object result) {
                        if (result != null) {
                            final Properties props = (Properties)result;
                            StarterPluginPanel.this.mpanel.setProperties(props.getSubproperty("mpanel")).addResultListener((IResultListener)new SwingDelegationResultListener(ret){

                                public void customResultAvailable(Object result) {
                                    StarterPluginPanel.this.spanel.setProperties(props.getSubproperty("spanel")).addResultListener((IResultListener)new DelegationResultListener(ret));
                                }
                            });
                        } else {
                            ret.setResult(null);
                        }
                    }
                });
            }

            public void customExceptionOccurred(Exception exception) {
                ret.setResult(null);
            }
        });
        return ret;
    }

    public IFuture pushPlatformProperties() {
        final Future ret = new Future();
        SServiceProvider.getService((IExternalAccess)this.jcc.getPlatformAccess(), ISettingsService.class, (String)"platform").addResultListener((IResultListener)new SwingDelegationResultListener(ret){

            public void customResultAvailable(Object result) {
                final ISettingsService settings = (ISettingsService)result;
                StarterPluginPanel.this.mpanel.getProperties().addResultListener((IResultListener)new SwingDelegationResultListener(ret){

                    public void customResultAvailable(Object result) {
                        final Properties props = new Properties();
                        props.addSubproperties("mpanel", (Properties)result);
                        StarterPluginPanel.this.spanel.getProperties().addResultListener((IResultListener)new SwingDelegationResultListener(ret){

                            public void customResultAvailable(Object result) {
                                props.addSubproperties("spanel", (Properties)result);
                                settings.setProperties("StarterServicePanel", props).addResultListener((IResultListener)new SwingDelegationResultListener(ret));
                            }
                        });
                    }
                });
            }

            public void customExceptionOccurred(Exception exception) {
                ret.setResult(null);
            }
        });
        return ret;
    }

    public IFuture setProperties(Properties props) {
        double dl = props.getDoubleProperty("leftsplit_location");
        if (dl > 0.0) {
            this.lsplit.setDividerLocation(dl);
            this.lsplit.setResizeWeight(dl);
        }
        if ((dl = props.getDoubleProperty("mainsplit_location")) > 0.0) {
            this.csplit.setDividerLocation(dl);
            this.csplit.setResizeWeight(dl);
        }
        return IFuture.DONE;
    }

    public IFuture getProperties() {
        Properties props = new Properties();
        props.addProperty(new Property("leftsplit_location", "" + this.lsplit.getProportionalDividerLocation()));
        props.addProperty(new Property("mainsplit_location", "" + this.csplit.getProportionalDividerLocation()));
        return new Future((Object)props);
    }

    public void dispose() {
        this.comptree.dispose();
    }
}

