/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.testcenter;

import jadex.base.SRemoteGui;
import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IResourceIdentifier;
import jadex.bridge.ResourceIdentifier;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.future.CollectionResultListener;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IRemoteResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.BrowserPane;
import jadex.commons.gui.EditableList;
import jadex.commons.gui.JSplitPanel;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.ScrollablePanel;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.future.SwingDelegationResultListener;
import jadex.commons.gui.future.SwingExceptionDelegationResultListener;
import jadex.tools.testcenter.TestCenterPlugin;
import jadex.xml.PropertiesXMLHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;

public class TestCenterPanel
extends JSplitPanel {
    public static final String FILEEXTENSION_TESTS = ".tests";
    protected EditableList teststable;
    protected TestCenterPlugin plugin;
    protected TestSuite testsuite;
    protected JButton startabort;
    protected JButton clearreport;
    protected JProgressBar progress;
    protected JLabel statelabel;
    protected JTextPane details;
    protected JTextField tfto;
    protected JComboBox tfpar;
    protected JCheckBox allowduplicates;
    protected String report;
    protected int concurrency;
    protected long timeout;
    protected List<Tuple2<String, IResourceIdentifier>> tests;
    protected JFileChooser loadsavechooser;

    public TestCenterPanel(final TestCenterPlugin plugin) {
        this.plugin = plugin;
        this.concurrency = 1;
        this.tests = new ArrayList<Tuple2<String, IResourceIdentifier>>();
        this.setResizeWeight(0.5);
        ScrollablePanel testcases = new ScrollablePanel(null, false, true);
        testcases.setLayout(new GridBagLayout());
        testcases.setBorder(new TitledBorder(new EtchedBorder(1), " Test suite settings "));
        this.teststable = new EditableList("Test cases", true);
        this.teststable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int row;
                if (e.getType() == -1 && (row = e.getFirstRow()) != -1) {
                    TestCenterPanel.this.tests.remove(row);
                }
            }
        });
        JScrollPane scroll = new JScrollPane((Component)this.teststable);
        this.teststable.setPreferredScrollableViewportSize(new Dimension(400, 200));
        this.tfto = new JTextField("", 6);
        this.tfto.setMinimumSize(this.tfto.getPreferredSize());
        this.tfto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TestCenterPanel.this.setTimeout(TestCenterPanel.this.tfto.getText());
            }
        });
        this.tfto.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent fe) {
                TestCenterPanel.this.setTimeout(TestCenterPanel.this.tfto.getText());
            }
        });
        this.tfpar = new JComboBox<String>(new String[]{"1", "5", "10", "all"});
        this.tfpar.setPreferredSize(new Dimension(this.tfto.getPreferredSize().width, this.tfpar.getPreferredSize().height));
        this.tfpar.setEditable(true);
        this.tfpar.setMinimumSize(this.tfpar.getPreferredSize());
        this.tfpar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TestCenterPanel.this.extractConcurrencyValue((String)TestCenterPanel.this.tfpar.getModel().getSelectedItem());
            }
        });
        this.tfpar.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent fe) {
                TestCenterPanel.this.extractConcurrencyValue((String)TestCenterPanel.this.tfpar.getModel().getSelectedItem());
            }
        });
        this.tfpar.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TestCenterPanel.this.extractConcurrencyValue((String)TestCenterPanel.this.tfpar.getModel().getSelectedItem());
            }
        });
        this.allowduplicates = new JCheckBox("Allow including the same test more than once");
        this.allowduplicates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TestCenterPanel.this.teststable.setAllowDuplicates(TestCenterPanel.this.allowduplicates.isSelected());
            }
        });
        JButton load = new JButton("Load");
        load.setToolTipText("Load a test suite");
        JButton save = new JButton("Save");
        save.setToolTipText("Save a test suite");
        JButton clear = new JButton("Clear");
        clear.setToolTipText("Clear the test suite");
        testcases.add((Component)scroll, new GridBagConstraints(0, 0, 7, 1, 1.0, 1.0, 18, 1, new Insets(4, 2, 2, 4), 0, 0));
        testcases.add((Component)this.allowduplicates, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        testcases.add((Component)new JLabel("Testcase timeout [ms]:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 2, 0), 0, 0));
        testcases.add((Component)this.tfto, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 0), 0, 0));
        testcases.add((Component)new JLabel("Testcase concurrency:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 0), 0, 0));
        testcases.add((Component)this.tfpar, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 0), 0, 0));
        testcases.add((Component)new JLabel(), new GridBagConstraints(2, 1, 1, 2, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        testcases.add((Component)load, new GridBagConstraints(3, 2, 1, 2, 0.0, 0.0, 15, 0, new Insets(4, 2, 2, 4), 0, 0));
        testcases.add((Component)save, new GridBagConstraints(4, 2, 1, 2, 0.0, 0.0, 15, 0, new Insets(4, 2, 2, 4), 0, 0));
        testcases.add((Component)clear, new GridBagConstraints(5, 2, 1, 2, 0.0, 0.0, 15, 0, new Insets(4, 2, 2, 4), 0, 0));
        JPanel testperformer = new JPanel(new GridBagLayout());
        testperformer.setBorder(new TitledBorder(new EtchedBorder(1), " Test suite execution "));
        this.progress = new JProgressBar(0);
        this.startabort = new JButton("Start");
        JButton savereport = new JButton("Save");
        this.clearreport = new JButton("Clear");
        this.startabort.setToolTipText("Start the execution of the test suite.");
        savereport.setToolTipText("Save the current test suite report.");
        this.clearreport.setToolTipText("Clear the current test suite report.");
        this.statelabel = new JLabel("State: Idle");
        testperformer.add((Component)this.statelabel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 13, 0, new Insets(4, 2, 2, 4), 0, 0));
        testperformer.add((Component)this.progress, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 18, 2, new Insets(4, 2, 2, 4), 0, 0));
        testperformer.add((Component)this.startabort, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(4, 2, 2, 4), 0, 0));
        testperformer.add((Component)savereport, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 2, 2, 4), 0, 0));
        testperformer.add((Component)this.clearreport, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 2, 2, 4), 0, 0));
        SGUI.adjustComponentSizes((JComponent[])new JButton[]{load, save, clear, this.startabort, savereport, new JButton("Abort")});
        this.progress.setPreferredSize(new Dimension(this.progress.getPreferredSize().width, load.getPreferredSize().height));
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (TestCenterPanel.this.loadsavechooser == null) {
                    TestCenterPanel.this.loadsavechooser = new JFileChooser(".");
                    TestCenterPanel.this.loadsavechooser.addChoosableFileFilter(new FileFilter(){

                        @Override
                        public String getDescription() {
                            return "Testcases (*.tests)";
                        }

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory() || f.getName().endsWith(TestCenterPanel.FILEEXTENSION_TESTS);
                        }
                    });
                }
                if (TestCenterPanel.this.loadsavechooser.showDialog(SGUI.getWindowParent((Component)((Object)TestCenterPanel.this)), "Save") == 0) {
                    plugin.getJCC().getClassLoader(null).addResultListener((IResultListener)new SwingDefaultResultListener<ClassLoader>((Component)((Object)TestCenterPanel.this)){

                        public void customResultAvailable(ClassLoader cl) {
                            File file = TestCenterPanel.this.loadsavechooser.getSelectedFile();
                            if (file != null) {
                                if (!file.getName().endsWith(TestCenterPanel.FILEEXTENSION_TESTS)) {
                                    file = new File(file.getParentFile(), file.getName() + TestCenterPanel.FILEEXTENSION_TESTS);
                                    TestCenterPanel.this.loadsavechooser.setSelectedFile(file);
                                }
                                final File f = file;
                                TestCenterPanel.this.getProperties().addResultListener((IResultListener)new SwingDefaultResultListener<Properties>(){

                                    public void customResultAvailable(Properties result) {
                                        try {
                                            FileWriter fos = new FileWriter(f);
                                            fos.write(PropertiesXMLHelper.write((Object)result, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
                                            fos.close();
                                        }
                                        catch (Exception e) {
                                            this.customExceptionOccurred(e);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
        load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (TestCenterPanel.this.loadsavechooser == null) {
                    TestCenterPanel.this.loadsavechooser = new JFileChooser(".");
                    TestCenterPanel.this.loadsavechooser.addChoosableFileFilter(new FileFilter(){

                        @Override
                        public String getDescription() {
                            return "Testcases (*.tests)";
                        }

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory() || f.getName().endsWith(TestCenterPanel.FILEEXTENSION_TESTS);
                        }
                    });
                }
                if (TestCenterPanel.this.loadsavechooser.showDialog(SGUI.getWindowParent((Component)((Object)TestCenterPanel.this)), "Load") == 0) {
                    plugin.getJCC().getClassLoader(null).addResultListener((IResultListener)new SwingDefaultResultListener<ClassLoader>((Component)((Object)TestCenterPanel.this)){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void customResultAvailable(ClassLoader cl) {
                            File file = TestCenterPanel.this.loadsavechooser.getSelectedFile();
                            if (file != null) {
                                FileInputStream fis = null;
                                try {
                                    fis = new FileInputStream(file);
                                    TestCenterPanel.this.setProperties((Properties)PropertiesXMLHelper.read((InputStream)fis, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
                                }
                                catch (Exception exception) {
                                }
                                finally {
                                    if (fis != null) {
                                        try {
                                            fis.close();
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                            }
                        }
                    });
                }
            }
        });
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TestCenterPanel.this.clearTests();
            }
        });
        this.startabort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (TestCenterPanel.this.testsuite == null || !TestCenterPanel.this.testsuite.isRunning()) {
                    TestCenterPanel.this.testsuite = new TestSuite(TestCenterPanel.this.tests.toArray(new Tuple2[0]));
                    TestCenterPanel.this.testsuite.start();
                } else {
                    TestCenterPanel.this.testsuite.abort();
                }
            }
        });
        savereport.addActionListener(new ActionListener(){
            JFileChooser saverepchooser;

            @Override
            public void actionPerformed(ActionEvent ev) {
                File file;
                if (this.saverepchooser == null) {
                    this.saverepchooser = new JFileChooser(".");
                    this.saverepchooser.setSelectedFile(new File("test_report.html"));
                    this.saverepchooser.setAcceptAllFileFilterUsed(true);
                    FileFilter savereport_filter = new FileFilter(){

                        @Override
                        public String getDescription() {
                            return "HTMLs (*.html)";
                        }

                        @Override
                        public boolean accept(File f) {
                            String name = f.getName();
                            return f.isDirectory() || name.toLowerCase().endsWith("html") || name.toLowerCase().endsWith("htm");
                        }
                    };
                    this.saverepchooser.addChoosableFileFilter(savereport_filter);
                    this.saverepchooser.setMultiSelectionEnabled(true);
                }
                if (this.saverepchooser.showDialog(SGUI.getWindowParent((Component)((Object)TestCenterPanel.this)), "Save Report") == 0 && (file = this.saverepchooser.getSelectedFile()) != null) {
                    try {
                        FileWriter fw = new FileWriter(file);
                        fw.write(TestCenterPanel.this.report);
                        fw.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.clearreport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TestCenterPanel.this.testsuite != null && !TestCenterPanel.this.testsuite.isRunning()) {
                    TestCenterPanel.this.testsuite = null;
                    TestCenterPanel.this.updateProgress();
                    TestCenterPanel.this.updateDetails();
                }
            }
        });
        JPanel top = new JPanel(new BorderLayout());
        JScrollPane scrollx = new JScrollPane((Component)testcases);
        scrollx.setBorder(null);
        top.add("Center", scrollx);
        top.add("South", testperformer);
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.setBorder(new TitledBorder(new EtchedBorder(1), " Details "));
        this.details = new BrowserPane();
        this.details.setMinimumSize(new Dimension(400, 100));
        this.details.setPreferredSize(new Dimension(400, 100));
        JScrollPane scroll2 = new JScrollPane(this.details);
        bottom.add("Center", scroll2);
        this.setOrientation(0);
        this.setOneTouchExpandable(true);
        this.setDividerLocation(0.7);
        this.setResizeWeight(0.7);
        this.setTopComponent(top);
        this.setBottomComponent(bottom);
        this.reset();
    }

    public IFuture<Void> setProperties(Properties props) {
        final Future ret = new Future();
        this.reset();
        this.teststable.setAllowDuplicates(props.getBooleanProperty("allowduplicates"));
        this.allowduplicates.setSelected(props.getBooleanProperty("allowduplicates"));
        String timeout = props.getProperty("timeout") != null ? props.getStringProperty("timeout") : "20000";
        this.setTimeout(timeout);
        this.tfto.setText(timeout);
        if (props.getProperty("concurrency") != null) {
            this.concurrency = props.getIntProperty("concurrency");
            if (this.concurrency == -1) {
                this.tfpar.getModel().setSelectedItem("all");
            } else {
                this.tfpar.getModel().setSelectedItem("" + this.concurrency);
            }
        }
        Properties[] entries = props.getSubproperties("entry");
        final CollectionResultListener crl = new CollectionResultListener(entries.length, false, (IResultListener)new SwingExceptionDelegationResultListener<Collection<Tuple2<String, IResourceIdentifier>>, Void>(ret){

            public void customResultAvailable(Collection<Tuple2<String, IResourceIdentifier>> result) {
                for (Tuple2<String, IResourceIdentifier> tup : result) {
                    TestCenterPanel.this.addTest((String)tup.getFirstEntity(), (IResourceIdentifier)tup.getSecondEntity());
                }
                ret.setResult(null);
            }
        });
        for (int i = 0; i < entries.length; ++i) {
            final String name = entries[i].getStringProperty("model");
            String ridurl = entries[i].getStringProperty("ridurl");
            String globalrid = entries[i].getStringProperty("globalrid");
            SRemoteGui.createResourceIdentifier((IExternalAccess)this.plugin.getJCC().getPlatformAccess(), (String)ridurl, (String)globalrid).addResultListener((IResultListener)new ExceptionDelegationResultListener<IResourceIdentifier, Void>(ret){

                public void customResultAvailable(IResourceIdentifier result) {
                    crl.resultAvailable((Object)new Tuple2((Object)name, (Object)result));
                }
            });
        }
        return ret;
    }

    protected String[] getTestNames() {
        String[] ret = new String[this.tests.size()];
        for (int i = 0; i < this.tests.size(); ++i) {
            ret[i] = (String)this.tests.get(i).getFirstEntity();
        }
        return ret;
    }

    public IFuture<Properties> getProperties() {
        final Future ret = new Future();
        CollectionResultListener crl = new CollectionResultListener(this.tests.size(), false, (IResultListener)new SwingExceptionDelegationResultListener<Collection<Tuple2<String, String>>, Properties>(ret){

            public void customResultAvailable(Collection<Tuple2<String, String>> result) {
                Properties props = new Properties();
                Iterator<Tuple2<String, String>> it = result.iterator();
                for (int i = 0; i < TestCenterPanel.this.tests.size(); ++i) {
                    Tuple2<String, String> local = it.next();
                    Properties entry = new Properties();
                    entry.addProperty(new Property("model", (String)local.getFirstEntity()));
                    entry.addProperty(new Property("ridurl", (String)local.getSecondEntity()));
                    IResourceIdentifier rid = (IResourceIdentifier)TestCenterPanel.this.tests.get(i).getSecondEntity();
                    String id = rid != null && rid.getGlobalIdentifier() != null && rid.getGlobalIdentifier().getResourceId() != null && !ResourceIdentifier.isHashGid((IResourceIdentifier)rid) ? rid.getGlobalIdentifier().getResourceId() : null;
                    entry.addProperty(new Property("globalrid", id));
                    props.addSubproperties("entry", entry);
                }
                props.addProperty(new Property("timeout", TestCenterPanel.this.tfto.getText()));
                props.addProperty(new Property("concurrency", "" + TestCenterPanel.this.concurrency));
                props.addProperty(new Property("allowduplicates", "" + TestCenterPanel.this.allowduplicates.isSelected()));
                ret.setResult((Object)props);
            }
        });
        for (int i = 0; i < this.tests.size(); ++i) {
            SRemoteGui.localizeModel((IExternalAccess)this.plugin.getJCC().getPlatformAccess(), (String)((String)this.tests.get(i).getFirstEntity()), (IResourceIdentifier)((IResourceIdentifier)this.tests.get(i).getSecondEntity())).addResultListener((IResultListener)crl);
        }
        return ret;
    }

    protected void updateProgress() {
        if (this.testsuite != null) {
            Testcase[] testcases = this.testsuite.getTestcases();
            int performed = 0;
            int failed = 0;
            for (int i = 0; i < testcases.length; ++i) {
                if (testcases[i] == null || !testcases[i].isPerformed()) continue;
                ++performed;
                if (testcases[i].isSucceeded()) continue;
                ++failed;
            }
            this.progress.setMinimum(0);
            this.progress.setMaximum(testcases.length);
            this.progress.setStringPainted(true);
            this.progress.setValue(performed);
            if (failed == 0) {
                this.progress.setForeground(Color.green);
            } else {
                this.progress.setForeground(Color.red);
            }
            long alldur = System.currentTimeMillis() - this.testsuite.getStartTime();
            this.progress.setString("Performed: " + performed + "/" + testcases.length + " in " + SUtil.getDurationHMS((long)alldur) + "     Failed: " + failed + "/" + testcases.length);
        } else {
            this.progress.setStringPainted(false);
            this.progress.setMinimum(0);
            this.progress.setMaximum(100);
            this.progress.setValue(0);
            this.progress.setForeground(new JProgressBar().getForeground());
        }
        this.progress.repaint();
        if (this.testsuite == null) {
            this.statelabel.setText("State: Idle");
        } else if (this.testsuite.isRunning()) {
            this.statelabel.setText("State: Running");
        } else if (this.testsuite.isAborted()) {
            this.statelabel.setText("State: Aborted");
        } else {
            this.statelabel.setText("State: Finished");
        }
        if (this.testsuite != null && this.testsuite.isRunning()) {
            this.startabort.setText("Abort");
            this.startabort.setToolTipText("Abort the execution of the test suite.");
        } else {
            this.startabort.setText("Start");
            this.startabort.setToolTipText("Start the execution of the test suite.");
        }
    }

    protected String generateReport(TestSuite suite) {
        int i;
        Tuple2<String, IResourceIdentifier>[] names = suite.getTestcaseNames();
        Testcase[] testcases = suite.getTestcases();
        int performed = 0;
        for (int i2 = 0; i2 < testcases.length; ++i2) {
            if (testcases[i2] == null || !testcases[i2].isPerformed()) continue;
            ++performed;
        }
        StringBuffer text = new StringBuffer();
        text.append("<a name=\"top\"></a>");
        if (suite.isRunning()) {
            text.append("<h3>Performed ");
            text.append(performed);
            text.append(" of ");
            text.append(testcases.length);
            text.append(" Test Cases</h3>\n");
        } else if (suite.isAborted()) {
            text.append("<h3>Aborted after ");
            text.append(performed);
            text.append(" of ");
            text.append(testcases.length);
            text.append(" Test Cases</h3>\n");
        } else {
            text.append("<h3>Performed ");
            text.append(testcases.length);
            text.append(" Test Cases</h3>\n");
        }
        text.append("<table>\n");
        for (i = 0; i < names.length; ++i) {
            text.append("<tr>\n");
            text.append("<td width=\"25\" align=\"right\"><strong>");
            text.append(i + 1);
            text.append("&nbsp;</strong></td>\n");
            if (testcases[i] != null && testcases[i].isPerformed()) {
                text.append("<td><a href=\"#");
                text.append((String)names[i].getFirstEntity());
                text.append(i);
                text.append("\">");
                text.append((String)names[i].getFirstEntity());
                text.append("</a></td>\n");
            } else {
                text.append("<td>");
                text.append((String)names[i].getFirstEntity());
                text.append("</td>\n");
            }
            if (testcases[i] != null) {
                if (testcases[i].isPerformed() && testcases[i].isSucceeded()) {
                    text.append("<td align=\"left\" style=\"color: #00FF00\">");
                    text.append("<strong>O&nbsp;</strong>");
                } else if (testcases[i].isPerformed() && !testcases[i].isSucceeded()) {
                    text.append("<td align=\"left\" style=\"color: #FF0000\">");
                    text.append("<strong>X&nbsp;</strong>");
                } else {
                    text.append("<td align=\"left\" style=\"color: #444444\">");
                    text.append("<strong>?&nbsp;</strong>");
                }
                text.append("</td>\n");
            } else if (suite.isAborted()) {
                text.append("<td align=\"left\" style=\"color: #444444\">");
                text.append("<strong>?&nbsp;</strong>");
                text.append("</td>\n");
            } else {
                text.append("<td align=\"left\">&nbsp;</td>\n");
            }
            if (testcases[i] != null && testcases[i].isPerformed()) {
                text.append("<td>");
                text.append(SUtil.getDurationHMS((long)testcases[i].getDuration()));
                text.append("</td>\n");
            } else {
                text.append("<td>&nbsp;</td>\n");
            }
            text.append("</tr>\n");
        }
        text.append("</table>\n");
        for (i = 0; i < testcases.length; ++i) {
            if (testcases[i] == null || !testcases[i].isPerformed()) continue;
            text.append("<p>\n<a name=\"");
            text.append((String)names[i].getFirstEntity());
            text.append(i);
            text.append("\"></a>\n");
            text.append(testcases[i].getHTMLFragment(i + 1, (String)names[i].getFirstEntity()));
            text.append("<a href=\"#top\">Back to top.</a> &nbsp;\n");
        }
        return text.toString();
    }

    protected void updateDetails() {
        this.report = this.testsuite != null ? this.generateReport(this.testsuite) : "";
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    final Point pos = ((JViewport)TestCenterPanel.this.details.getParent()).getViewPosition();
                    TestCenterPanel.this.details.setText(TestCenterPanel.this.report);
                    TestCenterPanel.this.details.repaint();
                    ((JViewport)TestCenterPanel.this.details.getParent()).setViewPosition(pos);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JViewport)TestCenterPanel.this.details.getParent()).setViewPosition(pos);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addTest(String model, final IResourceIdentifier rid) {
        SRemoteGui.localizeModel((IExternalAccess)this.plugin.getJCC().getPlatformAccess(), (String)model, (IResourceIdentifier)rid).addResultListener((IResultListener)new SwingDefaultResultListener<Tuple2<String, String>>(){

            public void customResultAvailable(Tuple2<String, String> result) {
                TestCenterPanel.this.tests.add((Tuple2<String, IResourceIdentifier>)new Tuple2(result.getFirstEntity(), (Object)rid));
                TestCenterPanel.this.teststable.addEntry((String)result.getFirstEntity());
            }
        });
    }

    public void removeTest(String model, IResourceIdentifier rid) {
        this.tests.remove(new Tuple2((Object)model, (Object)rid));
        this.teststable.removeEntry(model);
    }

    public void clearTests() {
        this.tests.clear();
        this.teststable.setEntries(new String[0]);
    }

    public void setTests(List<Tuple2<String, IResourceIdentifier>> tests) {
        this.tests = tests;
        this.teststable.setEntries(this.getTestNames());
    }

    public void reset() {
        if (this.testsuite != null && this.testsuite.isRunning()) {
            this.testsuite.abort();
        }
        this.testsuite = null;
        this.updateProgress();
        this.updateDetails();
        this.clearTests();
        this.teststable.setAllowDuplicates(false);
        this.allowduplicates.setSelected(false);
        this.tfto.setText("20000");
        this.setTimeout("20000");
    }

    public boolean allowDuplicates() {
        return this.teststable.isAllowDuplicates();
    }

    protected void setTimeout(String text) {
        try {
            this.timeout = Long.parseLong(text);
        }
        catch (Exception e) {
            this.showTimoutValueWarning(e);
        }
    }

    protected void showTimoutValueWarning(final Exception e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String msg = SUtil.wrapText((String)("No integer timeout: " + e.getMessage()));
                JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)((Object)TestCenterPanel.this)), msg, "Settings problem", 1);
            }
        });
    }

    protected void extractConcurrencyValue(String text) {
        if (text.equals("all")) {
            this.concurrency = -1;
        } else {
            try {
                this.concurrency = Integer.parseInt(text);
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String msg = SUtil.wrapText((String)("No integer concurrency: " + e.getMessage()));
                        JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)((Object)TestCenterPanel.this)), msg, "Settings problem", 1);
                    }
                });
            }
            if (this.concurrency <= 0) {
                this.concurrency = 1;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String msg = SUtil.wrapText((String)"Concurrency must be greater zero.");
                        JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)((Object)TestCenterPanel.this)), msg, "Settings problem", 1);
                    }
                });
            }
        }
    }

    public static void main(String[] args) {
        TestCenterPanel p = new TestCenterPanel(null);
        JFrame f = new JFrame();
        f.add("Center", (Component)((Object)p));
        f.pack();
        f.setVisible(true);
    }

    public class TestSuite {
        protected Tuple2<String, IResourceIdentifier>[] names;
        protected Testcase[] results;
        protected Map<Tuple2<String, IResourceIdentifier>, IComponentIdentifier> testcases;
        protected boolean running;
        protected boolean aborted;
        protected long starttime;

        public TestSuite(Tuple2<String, IResourceIdentifier>[] names) {
            this.names = names;
            this.results = new Testcase[names.length];
            this.testcases = new HashMap<Tuple2<String, IResourceIdentifier>, IComponentIdentifier>();
            this.running = false;
        }

        public boolean isRunning() {
            return this.running;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public Tuple2<String, IResourceIdentifier>[] getTestcaseNames() {
            return this.names;
        }

        public Testcase[] getTestcases() {
            return this.results;
        }

        public long getStartTime() {
            return this.starttime;
        }

        public void start() {
            this.starttime = System.currentTimeMillis();
            this.aborted = false;
            this.startNextTestcases();
        }

        public void abort() {
            assert (SwingUtilities.isEventDispatchThread());
            this.aborted = true;
            CounterResultListener crl = new CounterResultListener(this.testcases.size(), (IResultListener)new SwingDefaultResultListener<Void>((Component)((Object)TestCenterPanel.this)){

                public void customResultAvailable(Void result) {
                    TestCenterPanel.this.updateProgress();
                    TestCenterPanel.this.updateDetails();
                }

                public void customExceptionOccurred(Exception exception) {
                    super.customExceptionOccurred(exception);
                    this.customResultAvailable(null);
                }
            });
            for (IComponentIdentifier testcase : this.testcases.values()) {
                if (testcase != null) {
                    this.abortTestcase(testcase).addResultListener((IResultListener)crl);
                    continue;
                }
                crl.resultAvailable(null);
            }
        }

        protected void startNextTestcases() {
            assert (SwingUtilities.isEventDispatchThread());
            for (int i = 0; !(this.aborted || i >= this.results.length || TestCenterPanel.this.concurrency != -1 && this.testcases.size() >= TestCenterPanel.this.concurrency); ++i) {
                if (this.testcases.containsKey(this.names[i]) || this.results[i] != null) continue;
                final Tuple2<String, IResourceIdentifier> name = this.names[i];
                this.testcases.put(name, null);
                TestResultListener res = new TestResultListener(name);
                TestCenterPanel.this.plugin.getJCC().setStatusText("Performing test " + name);
                Future ret = new Future();
                SServiceProvider.getService((IExternalAccess)TestCenterPanel.this.plugin.getJCC().getPlatformAccess(), IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new SwingDelegationResultListener(ret, (IResultListener)res, ret){
                    final /* synthetic */ IResultListener val$res;
                    final /* synthetic */ Future val$ret;
                    {
                        this.val$res = iResultListener;
                        this.val$ret = future;
                        super(x0);
                    }

                    public void customResultAvailable(Object result) {
                        IComponentManagementService cms = (IComponentManagementService)result;
                        HashMap<String, Long> args = new HashMap<String, Long>();
                        args.put("timeout", TestCenterPanel.this.timeout);
                        CreationInfo ci = new CreationInfo(args, TestCenterPanel.this.plugin.getJCC().getPlatformAccess().getComponentIdentifier());
                        ci.setResourceIdentifier((IResourceIdentifier)name.getSecondEntity());
                        cms.createComponent(null, (String)name.getFirstEntity(), ci, this.val$res).addResultListener((IResultListener)new SwingDelegationResultListener(this.val$ret));
                    }
                });
                ret.addResultListener((IResultListener)new SwingDefaultResultListener((Component)((Object)TestCenterPanel.this)){

                    public void customResultAvailable(Object result) {
                        if (TestSuite.this.testcases.containsKey(name)) {
                            TestSuite.this.testcases.put((Tuple2<String, IResourceIdentifier>)name, (IComponentIdentifier)result);
                        } else {
                            TestSuite.this.abortTestcase((IComponentIdentifier)result);
                        }
                        TestSuite.this.startNextTestcases();
                        TestCenterPanel.this.updateProgress();
                        TestCenterPanel.this.updateDetails();
                    }
                });
            }
            this.running = !this.testcases.isEmpty();
        }

        protected IFuture<Void> abortTestcase(final IComponentIdentifier testcase) {
            final Future ret = new Future();
            SServiceProvider.getService((IExternalAccess)TestCenterPanel.this.plugin.getJCC().getJCCAccess(), IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new SwingExceptionDelegationResultListener<IComponentManagementService, Void>(ret){

                public void customResultAvailable(IComponentManagementService cms) {
                    cms.destroyComponent(testcase).addResultListener((IResultListener)new SwingExceptionDelegationResultListener<Map<String, Object>, Void>(ret){

                        public void customResultAvailable(Map<String, Object> result) {
                            ret.setResult(null);
                        }
                    });
                }
            });
            return ret;
        }

        public class TestResultListener
        implements IRemoteResultListener<Collection<Tuple2<String, Object>>> {
            protected Tuple2<String, IResourceIdentifier> name;

            public TestResultListener(Tuple2<String, IResourceIdentifier> name) {
                this.name = name;
            }

            public void exceptionOccurred(Exception exception) {
                Testcase res = new Testcase(1, new TestReport[]{new TestReport("creation", "Test center report", exception)});
                this.testFinished(res);
            }

            public void resultAvailable(Collection<Tuple2<String, Object>> result) {
                HashMap<Object, Object> resmap = null;
                Testcase res = null;
                if (result != null) {
                    resmap = new HashMap<Object, Object>();
                    for (Tuple2<String, Object> tup : result) {
                        resmap.put(tup.getFirstEntity(), tup.getSecondEntity());
                    }
                    res = (Testcase)resmap.get("testresults");
                }
                if (res == null) {
                    res = new Testcase(1, new TestReport[]{new TestReport("#1", "Test execution", false, "Component did not produce a result.")});
                }
                this.testFinished(res);
            }

            protected void testFinished(final Testcase result) {
                System.out.println("finished: " + result);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (TestSuite.this.testcases.containsKey(TestResultListener.this.name)) {
                            for (int i = 0; i < TestSuite.this.names.length; ++i) {
                                if (!TestResultListener.this.name.equals(TestSuite.this.names[i])) continue;
                                TestSuite.this.results[i] = result;
                            }
                            TestSuite.this.testcases.remove(TestResultListener.this.name);
                            TestSuite.this.startNextTestcases();
                            TestCenterPanel.this.updateProgress();
                            TestCenterPanel.this.updateDetails();
                        }
                    }
                });
            }
        }
    }
}

