/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.testcenter;

import jadex.base.SRemoteGui;
import jadex.base.gui.asynctree.INodeListener;
import jadex.base.gui.asynctree.ITreeNode;
import jadex.base.gui.filetree.IFileNode;
import jadex.base.gui.modeltree.AddPathAction;
import jadex.base.gui.modeltree.ModelTreePanel;
import jadex.base.gui.modeltree.RemovePathAction;
import jadex.base.gui.plugin.AbstractJCCPlugin;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IResourceIdentifier;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.settings.ISettingsService;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.collection.SCollection;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.JSplitPanel;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.ToolTipAction;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.future.SwingDelegationResultListener;
import jadex.tools.testcenter.TestCenterPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.tree.TreePath;

public class TestCenterPlugin
extends AbstractJCCPlugin {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"testcenter_sel", SGUI.makeIcon(TestCenterPlugin.class, (String)"/jadex/tools/common/images/new_testcenter_sel.png"), "testcenter", SGUI.makeIcon(TestCenterPlugin.class, (String)"/jadex/tools/common/images/new_testcenter.png"), "arrow_right", SGUI.makeIcon(TestCenterPlugin.class, (String)"/jadex/tools/common/images/arrow_right.png"), "test_small", SGUI.makeIcon(TestCenterPlugin.class, (String)"/jadex/tools/common/images/new_agent_testable.png"), "add_agent", SGUI.makeIcon(TestCenterPlugin.class, (String)"/jadex/tools/common/images/new_add_agent_testable.png"), "add_package", SGUI.makeIcon(TestCenterPlugin.class, (String)"/jadex/tools/common/images/new_add_package_testable.png"), "remove_agent", SGUI.makeIcon(TestCenterPlugin.class, (String)"/jadex/tools/common/images/new_remove_agent_testable.png"), "remove_package", SGUI.makeIcon(TestCenterPlugin.class, (String)"/jadex/tools/common/images/new_remove_package_testable.png")});
    protected ModelTreePanel mpanel;
    protected TestCenterPanel tcpanel;
    public final Action ADD_TESTCASE = new ToolTipAction("Add Testcase", icons.getIcon("add_agent"), "Add this file as testcase"){

        public void actionPerformed(ActionEvent e) {
            IFileNode node = (IFileNode)TestCenterPlugin.this.mpanel.getTree().getLastSelectedPathComponent();
            TestCenterPlugin.this.addTestcases(node);
        }

        public boolean isEnabled() {
            IFileNode node = (IFileNode)TestCenterPlugin.this.mpanel.getTree().getLastSelectedPathComponent();
            return node != null && !node.isDirectory();
        }
    };
    public final Action ADD_TESTCASES = new ToolTipAction("Add All Testcases", icons.getIcon("add_package"), "Add recursively contained files as testcases."){

        public void actionPerformed(ActionEvent e) {
            IFileNode node = (IFileNode)TestCenterPlugin.this.mpanel.getTree().getLastSelectedPathComponent();
            if (node != null) {
                TestCenterPlugin.this.addTestcases(node);
            }
        }

        public boolean isEnabled() {
            IFileNode node = (IFileNode)TestCenterPlugin.this.mpanel.getTree().getLastSelectedPathComponent();
            return node != null && node.isDirectory();
        }
    };
    public final Action REMOVE_TESTCASE = new ToolTipAction("Remove Testcase", icons.getIcon("remove_agent"), "Remove this file as testcase"){

        public void actionPerformed(ActionEvent e) {
            IFileNode node = (IFileNode)TestCenterPlugin.this.mpanel.getTree().getLastSelectedPathComponent();
            TestCenterPlugin.this.removeTestcases(node);
        }

        public boolean isEnabled() {
            IFileNode node = (IFileNode)TestCenterPlugin.this.mpanel.getTree().getLastSelectedPathComponent();
            return node != null && !node.isDirectory();
        }
    };
    public final Action REMOVE_TESTCASES = new ToolTipAction("Remove All Testcases", icons.getIcon("remove_package"), "Remove recursively contained files as testcases."){

        public void actionPerformed(ActionEvent e) {
            IFileNode node = (IFileNode)TestCenterPlugin.this.mpanel.getTree().getLastSelectedPathComponent();
            if (node != null) {
                TestCenterPlugin.this.removeTestcases(node);
            }
        }

        public boolean isEnabled() {
            IFileNode node = (IFileNode)TestCenterPlugin.this.mpanel.getTree().getLastSelectedPathComponent();
            return node != null && node.isDirectory();
        }
    };

    public String getName() {
        return "Test Center";
    }

    public Icon getToolIcon(boolean selected) {
        return selected ? icons.getIcon("testcenter_sel") : icons.getIcon("testcenter");
    }

    public String getHelpID() {
        return "tools.testcenter";
    }

    public JComponent[] createToolBar() {
        JComponent[] ret = new JComponent[5];
        JButton b = new JButton(this.mpanel.getAction(AddPathAction.getName()));
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        ret[0] = b;
        b = new JButton(this.mpanel.getAction(RemovePathAction.getName()));
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        ret[1] = b;
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setOrientation(1);
        ret[2] = separator;
        b = new JButton(this.ADD_TESTCASES);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        ret[3] = b;
        b = new JButton(this.REMOVE_TESTCASES);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        ret[4] = b;
        return ret;
    }

    public JComponent createView() {
        this.mpanel = new ModelTreePanel(this.getJCC().getPlatformAccess(), this.jcc.getJCCAccess(), !this.getJCC().getJCCAccess().getComponentIdentifier().getPlatformName().equals(this.getJCC().getPlatformAccess().getComponentIdentifier().getPlatformName()));
        this.mpanel.getModel().addNodeListener(new INodeListener(){

            public void nodeRemoved(ITreeNode node) {
                TestCenterPlugin.this.pushPlatformSettings();
            }

            public void nodeAdded(ITreeNode node) {
                TestCenterPlugin.this.pushPlatformSettings();
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = TestCenterPlugin.this.mpanel.getTree().getRowForLocation(e.getX(), e.getY());
                if (row != -1 && e.getClickCount() == 2) {
                    TreePath selpath = TestCenterPlugin.this.mpanel.getTree().getPathForRow(row);
                    Object node = TestCenterPlugin.this.mpanel.getTree().getPathForRow(row).getLastPathComponent();
                    if (node instanceof IFileNode) {
                        if (((IFileNode)node).isDirectory()) {
                            if (TestCenterPlugin.this.mpanel.getTree().isExpanded(row)) {
                                TestCenterPlugin.this.mpanel.getTree().collapseRow(row);
                            } else {
                                TestCenterPlugin.this.mpanel.getTree().expandRow(row);
                            }
                        } else {
                            TestCenterPlugin.this.mpanel.setCursor(Cursor.getPredefinedCursor(3));
                            final String model = ((IFileNode)node).getFilePath();
                            TestCenterPlugin.this.createResourceIdentifier((IFileNode)selpath.getPathComponent(1)).addResultListener((IResultListener)new SwingDefaultResultListener<IResourceIdentifier>((Component)TestCenterPlugin.this.mpanel){

                                public void customResultAvailable(final IResourceIdentifier rid) {
                                    SRemoteGui.isTestcase((String)model, (IExternalAccess)TestCenterPlugin.this.getJCC().getPlatformAccess(), (IResourceIdentifier)rid).addResultListener((IResultListener)new SwingDefaultResultListener((Component)TestCenterPlugin.this.mpanel){

                                        public void customResultAvailable(Object result) {
                                            if (((Boolean)result).booleanValue()) {
                                                TestCenterPlugin.this.tcpanel.addTest(model, rid);
                                            } else {
                                                TestCenterPlugin.this.jcc.setStatusText("Component is not a testcase: " + model);
                                            }
                                            TestCenterPlugin.this.mpanel.setCursor(Cursor.getPredefinedCursor(0));
                                        }
                                    });
                                }
                            });
                        }
                    }
                }
            }
        };
        this.mpanel.getTree().addMouseListener(ml);
        this.tcpanel = new TestCenterPanel(this);
        JSplitPanel mainpanel = new JSplitPanel(1);
        mainpanel.setOneTouchExpandable(true);
        mainpanel.setResizeWeight(0.3);
        mainpanel.setDividerLocation(0.3);
        mainpanel.add((Component)this.mpanel);
        mainpanel.add((Component)((Object)this.tcpanel));
        this.loadPlatformProperties();
        return mainpanel;
    }

    public IFuture loadPlatformProperties() {
        final Future ret = new Future();
        SServiceProvider.getService((IExternalAccess)this.getJCC().getPlatformAccess(), ISettingsService.class, (String)"platform").addResultListener((IResultListener)new SwingDelegationResultListener(ret){

            public void customResultAvailable(Object result) {
                ISettingsService settings = (ISettingsService)result;
                settings.getProperties("TestCenterPlugin").addResultListener((IResultListener)new SwingDelegationResultListener(ret){

                    public void customResultAvailable(Object result) {
                        if (result != null) {
                            final Properties props = (Properties)result;
                            TestCenterPlugin.this.mpanel.setProperties(props.getSubproperty("mpanel")).addResultListener((IResultListener)new SwingDelegationResultListener(ret){

                                public void customResultAvailable(Object result) {
                                    TestCenterPlugin.this.tcpanel.setProperties(props.getSubproperty("tcpanel")).addResultListener((IResultListener)new SwingDelegationResultListener(ret));
                                }
                            });
                        } else {
                            ret.setResult(null);
                        }
                    }
                });
            }

            public void customExceptionOccurred(Exception exception) {
                ret.setResult(null);
            }
        });
        return ret;
    }

    public IFuture pushPlatformSettings() {
        final Future ret = new Future();
        SServiceProvider.getService((IExternalAccess)this.getJCC().getPlatformAccess(), ISettingsService.class, (String)"platform").addResultListener((IResultListener)new SwingDelegationResultListener(ret){

            public void customResultAvailable(Object result) {
                final ISettingsService settings = (ISettingsService)result;
                TestCenterPlugin.this.mpanel.getProperties().addResultListener((IResultListener)new SwingDelegationResultListener(ret){

                    public void customResultAvailable(Object result) {
                        final Properties props = new Properties();
                        props.addSubproperties("mpanel", (Properties)result);
                        TestCenterPlugin.this.tcpanel.getProperties().addResultListener((IResultListener)new SwingDelegationResultListener(ret){

                            public void customResultAvailable(Object result) {
                                props.addSubproperties("tcpanel", (Properties)result);
                                settings.setProperties("TestCenterPlugin", props).addResultListener((IResultListener)new SwingDelegationResultListener(ret));
                            }
                        });
                    }
                });
            }

            public void customExceptionOccurred(Exception exception) {
                ret.setResult(null);
            }
        });
        return ret;
    }

    public IFuture setProperties(Properties props) {
        double dl = props.getDoubleProperty("tcsplit_location");
        if (dl != 0.0) {
            this.tcpanel.setDividerLocation(dl);
            this.tcpanel.setResizeWeight(dl);
        }
        if ((dl = props.getDoubleProperty("mainsplit_location")) != 0.0) {
            ((JSplitPane)this.getView()).setDividerLocation(dl);
            ((JSplitPane)this.getView()).setResizeWeight(dl);
        }
        return IFuture.DONE;
    }

    public IFuture getProperties() {
        Properties props = new Properties();
        props.addProperty(new Property("mainsplit_location", Double.toString(((JSplitPanel)this.getView()).getProportionalDividerLocation())));
        props.addProperty(new Property("tcsplit_location", Double.toString(this.tcpanel.getProportionalDividerLocation())));
        return new Future((Object)props);
    }

    protected IFuture getLeafChildren(IFileNode node) {
        final Future fut = new Future();
        if (node.isDirectory()) {
            node.getChildren().addResultListener((IResultListener)new SwingDelegationResultListener(fut){

                public void customResultAvailable(Object result) {
                    List children = (List)result;
                    final ArrayList list = new ArrayList();
                    CounterResultListener crl = new CounterResultListener(children.size(), (IResultListener)new SwingDelegationResultListener(fut){

                        public void customResultAvailable(Object result) {
                            fut.setResult((Object)list);
                        }
                    }){

                        public void intermediateResultAvailable(Object result) {
                            list.addAll((Collection)result);
                        }
                    };
                    for (int i = 0; i < children.size(); ++i) {
                        TestCenterPlugin.this.getLeafChildren((IFileNode)children.get(i)).addResultListener((IResultListener)crl);
                    }
                }
            });
        } else {
            fut.setResult(Collections.singletonList(node));
        }
        return fut;
    }

    protected void addTestcases(IFileNode node) {
        this.getLeafChildren(node).addResultListener((IResultListener)new SwingDefaultResultListener((Component)this.mpanel){

            public void customResultAvailable(Object result) {
                final List leafs = (List)result;
                final int[] cnt = new int[1];
                for (int i = 0; i < leafs.size(); ++i) {
                    IFileNode node;
                    IFileNode base = node = (IFileNode)leafs.get(i);
                    while (base.getParent() != null && base.getParent().getParent() != null) {
                        base = base.getParent();
                    }
                    final String model = node.getFilePath();
                    TestCenterPlugin.this.createResourceIdentifier(base).addResultListener((IResultListener)new SwingDefaultResultListener<IResourceIdentifier>((Component)TestCenterPlugin.this.mpanel){

                        public void customResultAvailable(final IResourceIdentifier rid) {
                            SRemoteGui.isTestcase((String)model, (IExternalAccess)TestCenterPlugin.this.getJCC().getPlatformAccess(), (IResourceIdentifier)rid).addResultListener((IResultListener)new SwingDefaultResultListener((Component)TestCenterPlugin.this.mpanel){

                                public void customResultAvailable(Object result) {
                                    cnt[0] = cnt[0] + 1;
                                    String text = "Scanned file " + cnt[0] + " of " + leafs.size() + " (" + cnt[0] * 100 / leafs.size() + "%): " + model;
                                    TestCenterPlugin.this.getJCC().setStatusText(text);
                                    if (((Boolean)result).booleanValue()) {
                                        TestCenterPlugin.this.tcpanel.addTest(model, rid);
                                    }
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    protected void removeTestcases(final IFileNode node) {
        this.createResourceIdentifier(node).addResultListener((IResultListener)new SwingDefaultResultListener<IResourceIdentifier>(){

            public void customResultAvailable(IResourceIdentifier rid) {
                ArrayList nodes = SCollection.createArrayList();
                nodes.add(node);
                while (nodes.size() > 0) {
                    IFileNode n = (IFileNode)nodes.remove(0);
                    if (n.isDirectory()) {
                        for (int i = 0; i < n.getChildCount(); ++i) {
                            nodes.add(n.getChild(i));
                        }
                        continue;
                    }
                    String model = n.getFilePath();
                    TestCenterPlugin.this.tcpanel.removeTest(model, rid);
                }
            }
        });
    }

    public IFuture<IResourceIdentifier> createResourceIdentifier(IFileNode node) {
        IFileNode root = node;
        while (root.getParent() != null && root.getParent().getParent() != null) {
            root = root.getParent();
        }
        String filepath = root.getFilePath();
        return ModelTreePanel.createResourceIdentifier((IExternalAccess)this.jcc.getPlatformAccess(), (String)filepath);
    }
}

