/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.writer;

import jadex.commons.collection.Tree;
import jadex.commons.collection.TreeNode;
import jadex.xml.IPreProcessor;
import jadex.xml.SXML;
import jadex.xml.StackElement;
import jadex.xml.TypeInfo;
import jadex.xml.stax.QName;
import jadex.xml.writer.AWriteContext;
import jadex.xml.writer.AWriter;
import jadex.xml.writer.IObjectWriterHandler;
import jadex.xml.writer.WriteContextDesktop;
import jadex.xml.writer.WriteObjectInfo;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

public class Writer
extends AWriter {
    protected static final XMLOutputFactory FACTORY = XMLOutputFactory.newInstance();
    protected boolean genids;
    protected boolean indent;
    protected boolean newline;

    public Writer() {
        this(true);
    }

    public Writer(boolean genids) {
        this(genids, true, true);
    }

    public Writer(boolean genids, boolean indent, boolean newline) {
        this.genids = genids;
        this.indent = indent;
        this.newline = newline;
    }

    @Override
    public void write(IObjectWriterHandler handler, Object object, OutputStream out, ClassLoader classloader, Object context) throws Exception {
        this.write(handler, object, "utf-8", out, classloader, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(IObjectWriterHandler handler, Object object, String encoding, OutputStream out, ClassLoader classloader, Object context) throws Exception {
        XMLStreamWriter writer;
        XMLOutputFactory xMLOutputFactory = FACTORY;
        synchronized (xMLOutputFactory) {
            writer = FACTORY.createXMLStreamWriter(out, encoding);
        }
        if (encoding != null) {
            writer.writeStartDocument(encoding, "1.0");
        }
        this.writeNewline(writer);
        WriteContextDesktop wc = new WriteContextDesktop(handler, writer, context, object, classloader);
        this.writeObject(wc, object, null);
        writer.writeEndDocument();
        writer.close();
    }

    protected void writeObject(WriteContextDesktop wc, Object object, QName tag) throws Exception {
        int i;
        XMLStreamWriter writer = Writer.getWriter(wc);
        List<StackElement> stack = wc.getStack();
        if (object == null) {
            this.writeStartObject(writer, SXML.NULL, stack.size());
            this.writeEndObject(writer, stack.size());
            return;
        }
        TypeInfo typeinfo = wc.getHandler().getTypeInfo(object, this.getXMLPath(stack), wc);
        QName[] path = new QName[]{};
        IPreProcessor[] preprocs = wc.getHandler().getPreProcessors(object, typeinfo);
        if (preprocs != null && preprocs.length > 0) {
            for (i = 0; i < preprocs.length; ++i) {
                object = preprocs[i].preProcess(wc, object);
            }
        }
        if ((tag == null || tag.getNamespaceURI().startsWith("typeinfo:")) && typeinfo != null) {
            tag = typeinfo.getXMLTag();
            if (typeinfo.getXMLInfo() != null) {
                path = typeinfo.getXMLInfo().getXMLPathElements();
                i = 0;
                while (i + 1 < path.length) {
                    this.writeStartObject(writer, path[i], stack.size());
                    stack.add(new StackElement(path[i], object));
                    this.writeNewline(writer);
                    ++i;
                }
            }
        }
        if (tag == null) {
            tag = wc.getHandler().getTagName(object, wc);
        }
        if (!"".equals(tag.getNamespaceURI()) && "".equals(tag.getPrefix())) {
            tag = wc.getHandler().getTagWithPrefix(tag, wc);
        }
        if (this.genids && wc.getWrittenObjects().containsKey(object)) {
            this.writeStartObject(writer, tag, stack.size());
            writer.writeAttribute("__IDREF", (String)wc.getWrittenObjects().get(object));
            this.writeEndObject(writer, 0);
        } else {
            boolean subs;
            String content;
            WriteObjectInfo wi;
            String comment;
            if (wc.getWrittenObjects().containsKey(object)) {
                boolean rec = false;
                for (int i2 = 0; i2 < stack.size() && !rec; ++i2) {
                    if (!object.equals(stack.get(i2).getObject())) continue;
                    throw new RuntimeException("Object structure contains cycles: Enable 'genids' mode for serialization.");
                }
            }
            if ((comment = (wi = wc.getHandler().getObjectWriteInfo(object, typeinfo, wc)).getComment()) != null) {
                this.writeIndentation(writer, stack.size());
                writer.writeComment(comment);
                this.writeNewline(writer);
            }
            this.writeStartObject(writer, tag, stack.size());
            int curid = wc.getId();
            StackElement topse = new StackElement(tag, object);
            stack.add(topse);
            wc.getWrittenObjects().put(object, "" + curid);
            if (this.genids) {
                writer.writeAttribute("__ID", "" + curid);
            }
            wc.setId(curid + 1);
            Map<Object, String> attrs = wi.getAttributes();
            if (attrs != null) {
                for (Object propname : attrs.keySet()) {
                    String value = attrs.get(propname);
                    if (propname instanceof String) {
                        writer.writeAttribute((String)propname, value);
                        continue;
                    }
                    if (!(propname instanceof QName)) continue;
                    QName attrname = (QName)propname;
                    if (!"".equals(attrname.getNamespaceURI()) && "".equals(attrname.getPrefix())) {
                        attrname = wc.getHandler().getTagWithPrefix(tag, wc);
                    }
                    String uri = attrname.getNamespaceURI();
                    String prefix = attrname.getPrefix();
                    String localname = attrname.getLocalPart();
                    if (!"".equals(uri)) {
                        if (!prefix.equals(writer.getPrefix(uri))) {
                            writer.writeAttribute(prefix, uri, localname, value);
                            writer.writeNamespace(prefix, uri);
                            continue;
                        }
                        writer.writeAttribute(prefix, uri, localname, value);
                        continue;
                    }
                    writer.writeAttribute(localname, value);
                }
            }
            if (wi.getContent() != null && (content = wi.getContent()) != null) {
                if ((content.indexOf("<") != -1 || content.indexOf(">") != -1 || content.indexOf("&") != -1) && content.indexOf("<![CDATA[") == -1) {
                    writer.writeCData(content);
                } else {
                    writer.writeCharacters(content);
                }
            }
            boolean bl = subs = wi.getSubobjects() != null && !wi.getSubobjects().isEmpty();
            if (subs) {
                Tree subobs = wi.getSubobjects();
                this.writeNewline(writer);
                this.writeSubobjects(wc, subobs.getRootNode(), typeinfo);
            }
            this.writeEndObject(writer, subs ? stack.size() - 1 : 0);
            stack.remove(stack.size() - 1);
            int i3 = 0;
            while (i3 + 1 < path.length) {
                this.writeEndObject(writer, stack.size() - 1);
                stack.remove(stack.size() - 1);
                ++i3;
            }
        }
    }

    protected void writeSubobjects(WriteContextDesktop wc, TreeNode node, TypeInfo typeinfo) throws Exception {
        XMLStreamWriter writer = Writer.getWriter(wc);
        List<StackElement> stack = wc.getStack();
        List children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            TreeNode subnode = (TreeNode)children.get(i);
            Object tmp = subnode.getData();
            if (tmp instanceof QName) {
                QName subtag = (QName)tmp;
                this.writeStartObject(writer, subtag, stack.size());
                this.writeNewline(writer);
                stack.add(new StackElement(subtag, null));
                this.writeSubobjects(wc, subnode, typeinfo);
                stack.remove(stack.size() - 1);
                this.writeEndObject(writer, stack.size());
                continue;
            }
            this.writeObject(wc, ((Object[])tmp)[1], (QName)((Object[])tmp)[0]);
        }
    }

    protected void writeStartObject(XMLStreamWriter writer, QName tag, int level) throws Exception {
        this.writeIndentation(writer, level);
        String uri = tag.getNamespaceURI();
        String prefix = tag.getPrefix();
        if (!"".equals(uri)) {
            if (!prefix.equals(writer.getPrefix(uri))) {
                writer.writeStartElement(tag.getPrefix(), tag.getLocalPart(), uri);
                writer.writeNamespace(tag.getPrefix(), tag.getNamespaceURI());
            } else {
                writer.writeStartElement(tag.getPrefix(), tag.getLocalPart(), uri);
            }
        } else {
            writer.writeStartElement(tag.getLocalPart());
        }
    }

    protected void writeEndObject(XMLStreamWriter writer, int level) throws Exception {
        this.writeIndentation(writer, level);
        writer.writeEndElement();
        this.writeNewline(writer);
    }

    protected void writeIndentation(XMLStreamWriter writer, int level) throws Exception {
        if (this.indent) {
            for (int i = 0; i < level; ++i) {
                writer.writeCharacters("\t");
            }
        }
    }

    protected void writeNewline(XMLStreamWriter writer) throws Exception {
        if (this.newline) {
            writer.writeCharacters(SXML.lf);
        }
    }

    protected QName[] getXMLPath(List<StackElement> stack) {
        QName[] ret = new QName[stack.size()];
        for (int i = 0; i < stack.size(); ++i) {
            ret[i] = stack.get(i).getTag();
        }
        return ret;
    }

    public static XMLStreamWriter getWriter(AWriteContext context) {
        return (XMLStreamWriter)context.getWriter();
    }
}

