/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml;

import jadex.commons.Tuple;
import jadex.xml.AbstractInfo;
import jadex.xml.AccessInfo;
import jadex.xml.AttributeInfo;
import jadex.xml.IPostProcessor;
import jadex.xml.IPreProcessor;
import jadex.xml.LinkingInfo;
import jadex.xml.MappingInfo;
import jadex.xml.ObjectInfo;
import jadex.xml.SubobjectInfo;
import jadex.xml.XMLInfo;
import jadex.xml.reader.IObjectReaderHandler;
import jadex.xml.stax.QName;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TypeInfo
extends AbstractInfo {
    protected IObjectReaderHandler readerhandler;
    protected ObjectInfo objectinfo;
    protected MappingInfo mapinfo;
    protected LinkingInfo linkinfo;
    protected Map<Object, AttributeInfo> attributeinfos;
    protected Map<AccessInfo, SubobjectInfo> subobjectinfoswrite;
    protected Map<QName, TreeSet<SubobjectInfo>> subobjectinfosread;

    public TypeInfo(XMLInfo xmlinfo, ObjectInfo objectinfo) {
        this(xmlinfo, objectinfo, null);
    }

    public TypeInfo(XMLInfo xmlinfo, ObjectInfo objectinfo, MappingInfo mapinfo) {
        this(xmlinfo, objectinfo, mapinfo, null);
    }

    public TypeInfo(XMLInfo xmlinfo, ObjectInfo objectinfo, MappingInfo mapinfo, LinkingInfo linkinfo) {
        this(xmlinfo, objectinfo, mapinfo, linkinfo, null);
    }

    public TypeInfo(XMLInfo xmlinfo, ObjectInfo objectinfo, MappingInfo mapinfo, LinkingInfo linkinfo, IObjectReaderHandler readerhandler) {
        super(xmlinfo);
        this.objectinfo = objectinfo;
        this.mapinfo = mapinfo;
        this.linkinfo = linkinfo;
        this.readerhandler = readerhandler;
        if (mapinfo != null && mapinfo.getAttributeInfos() != null) {
            this.attributeinfos = this.createAttributeInfos(mapinfo.getAttributeInfos());
        }
        if (mapinfo != null && mapinfo.getSubobjectInfos() != null) {
            this.subobjectinfoswrite = this.createSubobjectInfosWrite(mapinfo.getSubobjectInfos());
        }
        this.subobjectinfosread = this.createSubobjectInfosRead(mapinfo == null ? null : mapinfo.getSubobjectInfos());
    }

    public Object getTypeInfo() {
        return this.getObjectInfo() != null && this.getObjectInfo().getTypeInfo() != null ? this.getObjectInfo().getTypeInfo() : (this.mapinfo != null && this.mapinfo.getSupertype() != null ? this.mapinfo.getSupertype().getTypeInfo() : null);
    }

    public ObjectInfo getObjectInfo() {
        return this.objectinfo != null ? this.objectinfo : (this.mapinfo != null && this.mapinfo.getSupertype() != null ? this.mapinfo.getSupertype().getObjectInfo() : null);
    }

    public MappingInfo getMappingInfo() {
        return this.mapinfo;
    }

    public LinkingInfo getLinkInfo() {
        return this.linkinfo;
    }

    public TypeInfo getSupertype() {
        return this.mapinfo != null ? this.mapinfo.getSupertype() : null;
    }

    public Object getCommentInfo() {
        Object cominfo;
        Object object = cominfo = this.mapinfo != null ? this.mapinfo.getCommentInfo() : null;
        return cominfo != null ? cominfo : (this.getSupertype() != null ? this.getSupertype().getCommentInfo() : null);
    }

    public Object getContentInfo() {
        Object coninfo;
        Object object = coninfo = this.mapinfo != null ? this.mapinfo.getContentInfo() : null;
        return coninfo != null ? coninfo : (this.getSupertype() != null ? this.getSupertype().getContentInfo() : null);
    }

    public boolean isIncludeFields() {
        return this.mapinfo != null ? this.mapinfo.getIncludeFields() != null && this.mapinfo.getIncludeFields().booleanValue() : false;
    }

    public boolean isIncludeMethods() {
        return this.mapinfo != null ? this.mapinfo.getIncludeMethods() != null && this.mapinfo.getIncludeMethods().booleanValue() : false;
    }

    public Object getAttributeInfo(Object xmlname) {
        Object ret;
        Object object = ret = this.attributeinfos == null ? null : this.attributeinfos.get(xmlname);
        if (ret == null && this.getSupertype() != null) {
            ret = this.getSupertype().getAttributeInfo(xmlname);
        }
        return ret;
    }

    public Set<Object> getXMLAttributeNames() {
        HashSet<Object> ret;
        HashSet<Object> hashSet = ret = this.attributeinfos == null ? new HashSet<Object>() : new HashSet<Object>(this.attributeinfos.keySet());
        if (this.getSupertype() != null) {
            ret.addAll(this.getSupertype().getXMLAttributeNames());
        }
        return ret;
    }

    public Collection<AttributeInfo> getAttributeInfos() {
        HashSet<AttributeInfo> ret;
        HashSet<AttributeInfo> hashSet = ret = this.attributeinfos == null ? new HashSet<AttributeInfo>() : new HashSet<AttributeInfo>(this.attributeinfos.values());
        if (this.getSupertype() != null) {
            ret.addAll(this.getSupertype().getAttributeInfos());
        }
        return ret;
    }

    public AttributeInfo[] getDeclaredAttributeInfos() {
        return this.attributeinfos == null ? null : this.attributeinfos.values().toArray(new AttributeInfo[0]);
    }

    public SubobjectInfo[] getDeclaredSubobjectInfos() {
        return this.subobjectinfoswrite == null ? null : this.subobjectinfoswrite.values().toArray(new SubobjectInfo[0]);
    }

    public IPostProcessor getPostProcessor() {
        IPostProcessor ret;
        IPostProcessor iPostProcessor = ret = this.objectinfo != null ? this.objectinfo.getPostProcessor() : null;
        return ret != null ? ret : (this.getSupertype() != null ? this.getSupertype().getPostProcessor() : null);
    }

    public IPreProcessor getPreProcessor() {
        IPreProcessor ret;
        IPreProcessor iPreProcessor = ret = this.xmlinfo != null ? this.xmlinfo.getPreProcessor() : null;
        return ret != null ? ret : (this.getSupertype() != null ? this.getSupertype().getPreProcessor() : null);
    }

    public Collection<SubobjectInfo> getSubobjectInfos() {
        LinkedHashSet<SubobjectInfo> ret;
        LinkedHashSet<SubobjectInfo> linkedHashSet = ret = this.subobjectinfoswrite != null ? new LinkedHashSet<SubobjectInfo>(this.subobjectinfoswrite.values()) : new LinkedHashSet();
        if (this.getSupertype() != null) {
            ret.addAll(this.getSupertype().getSubobjectInfos());
        }
        return ret;
    }

    public SubobjectInfo getSubobjectInfoWrite(Object attr) {
        SubobjectInfo ret;
        SubobjectInfo subobjectInfo = ret = this.subobjectinfoswrite != null ? this.subobjectinfoswrite.get(attr) : null;
        if (ret == null && this.getSupertype() != null) {
            ret = this.getSupertype().getSubobjectInfoWrite(attr);
        }
        return ret;
    }

    public SubobjectInfo getSubobjectInfoRead(QName tag, QName[] fullpath, Map<String, String> rawattributes) {
        SubobjectInfo ret = null;
        Set subobjects = this.subobjectinfosread != null ? (Set)this.subobjectinfosread.get(tag) : null;
        ret = this.findSubobjectInfo(subobjects, fullpath, rawattributes);
        return ret;
    }

    public boolean isCreateFromTag() {
        return this.xmlinfo != null ? this.xmlinfo.isCreateFromTag() : false;
    }

    public Object getLinker() {
        return this.linkinfo != null ? this.linkinfo.getLinker() : (this.mapinfo != null && this.mapinfo.getSupertype() != null ? this.mapinfo.getSupertype().getLinker() : null);
    }

    public boolean isBulkLink() {
        return this.linkinfo != null ? this.linkinfo.isBulkLink() : false;
    }

    protected SubobjectInfo findSubobjectInfo(Set<SubobjectInfo> soinfos, QName[] fullpath, Map<String, String> rawattributes) {
        SubobjectInfo ret = null;
        if (soinfos != null) {
            Iterator<SubobjectInfo> it = soinfos.iterator();
            while (ret == null && it.hasNext()) {
                SubobjectInfo si = it.next();
                QName[] tmp = si.getXMLPathElementsWithoutElement();
                boolean ok = !(si.getFilter() != null && !si.getFilter().filter(rawattributes) || tmp != null && tmp.length > fullpath.length);
                for (int i = 1; ok && tmp != null && i <= tmp.length; ++i) {
                    ok = tmp[tmp.length - i].equals(fullpath[fullpath.length - i - 1]);
                }
                if (!ok) continue;
                ret = si;
            }
        }
        return ret;
    }

    protected Map<AccessInfo, SubobjectInfo> createSubobjectInfosWrite(SubobjectInfo[] subobjectinfos) {
        LinkedHashMap<AccessInfo, SubobjectInfo> ret = new LinkedHashMap<AccessInfo, SubobjectInfo>();
        for (int i = 0; i < subobjectinfos.length; ++i) {
            ret.put(subobjectinfos[i].getAccessInfo(), subobjectinfos[i]);
        }
        return ret;
    }

    protected Map<QName, TreeSet<SubobjectInfo>> createSubobjectInfosRead(SubobjectInfo[] subobjectinfos) {
        HashMap<QName, TreeSet<SubobjectInfo>> ret = new HashMap<QName, TreeSet<SubobjectInfo>>();
        if (subobjectinfos != null) {
            for (int i = 0; i < subobjectinfos.length; ++i) {
                TreeSet<AbstractInfo> subobjects = (TreeSet<AbstractInfo>)ret.get(subobjectinfos[i].getXMLTag());
                if (subobjects == null) {
                    subobjects = new TreeSet<AbstractInfo>(new AbstractInfo.SpecificityComparator());
                    ret.put(subobjectinfos[i].getXMLTag(), subobjects);
                }
                subobjects.add(subobjectinfos[i]);
            }
        }
        if (this.getSupertype() != null) {
            Collection<SubobjectInfo> soinfos = this.getSupertype().getSubobjectInfos();
            for (SubobjectInfo soinfo : soinfos) {
                TreeSet<AbstractInfo> subobjects = (TreeSet<AbstractInfo>)ret.get(soinfo.getXMLTag());
                if (subobjects == null) {
                    subobjects = new TreeSet<AbstractInfo>(new AbstractInfo.SpecificityComparator());
                    ret.put(soinfo.getXMLTag(), subobjects);
                }
                subobjects.add(soinfo);
            }
        }
        return ret;
    }

    protected Map<Object, AttributeInfo> createAttributeInfos(AttributeInfo[] attributeinfos) {
        LinkedHashMap<Object, AttributeInfo> ret = new LinkedHashMap<Object, AttributeInfo>();
        for (int i = 0; i < attributeinfos.length; ++i) {
            QName[] xmlnames = attributeinfos[i].getXMLAttributeNames();
            if (xmlnames != null) {
                LinkedList<QName> key = new LinkedList<QName>();
                for (int j = xmlnames.length - 1; j >= 0; --j) {
                    key.add(0, xmlnames[j]);
                }
                ret.put(key.size() == 1 ? (Serializable)key.get(0) : new Tuple(key.toArray()), attributeinfos[i]);
                continue;
            }
            Object attrid = attributeinfos[i].getAttributeIdentifier();
            if (attrid == null) continue;
            ret.put(new QName(attrid.toString()), attributeinfos[i]);
        }
        return ret;
    }

    public void setReaderHandler(IObjectReaderHandler readerhandler) {
        this.readerhandler = readerhandler;
    }

    public IObjectReaderHandler getReaderHandler() {
        return this.readerhandler != null ? this.readerhandler : (this.getSupertype() != null ? this.getSupertype().getReaderHandler() : null);
    }
}

