/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.bean;

import jadex.commons.IFilter;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.transformation.BasicTypeConverter;
import jadex.commons.transformation.IStringObjectConverter;
import jadex.commons.transformation.STransformation;
import jadex.commons.transformation.annotations.Classname;
import jadex.commons.transformation.binaryserializer.BeanIntrospectorFactory;
import jadex.commons.transformation.traverser.BeanProperty;
import jadex.commons.transformation.traverser.IBeanIntrospector;
import jadex.xml.AccessInfo;
import jadex.xml.AttributeInfo;
import jadex.xml.IAttributeConverter;
import jadex.xml.IPostProcessor;
import jadex.xml.IReturnValueCommand;
import jadex.xml.ISubObjectConverter;
import jadex.xml.ObjectInfo;
import jadex.xml.SXML;
import jadex.xml.SubobjectInfo;
import jadex.xml.TypeInfo;
import jadex.xml.TypeInfoTypeManager;
import jadex.xml.bean.BeanAccessInfo;
import jadex.xml.bean.IBeanObjectCreator;
import jadex.xml.reader.AReadContext;
import jadex.xml.reader.AReader;
import jadex.xml.reader.IObjectReaderHandler;
import jadex.xml.reader.LinkData;
import jadex.xml.stax.QName;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class BeanObjectReaderHandler
implements IObjectReaderHandler {
    protected TypeInfoTypeManager titmanager;
    protected Set<Object> no_typeinfos;
    protected IBeanIntrospector introspector = BeanIntrospectorFactory.getInstance().getBeanIntrospector();
    protected Map<IFilter<Object>, IPostProcessor> postprocessors;

    public BeanObjectReaderHandler() {
    }

    public BeanObjectReaderHandler(Set<TypeInfo> typeinfos) {
        this.titmanager = new TypeInfoTypeManager(typeinfos);
    }

    @Override
    public synchronized TypeInfo getTypeInfo(Object object, QName[] fullpath, AReadContext context) {
        TypeInfo ret = null;
        if (this.titmanager != null) {
            Object type = this.getObjectType(object, context);
            if ((this.no_typeinfos == null || !this.no_typeinfos.contains(type)) && (ret = this.titmanager.getTypeInfo(type, fullpath)) == null && type instanceof Class) {
                ArrayList tocheck = new ArrayList();
                tocheck.add((Class)type);
                for (int i = 0; i < tocheck.size() && ret == null; ++i) {
                    Class clazz = (Class)tocheck.get(i);
                    ret = this.titmanager.getTypeInfo(clazz, fullpath);
                    if (ret != null) continue;
                    Class<?>[] interfaces = clazz.getInterfaces();
                    for (int j = 0; j < interfaces.length; ++j) {
                        tocheck.add(interfaces[j]);
                    }
                    if ((clazz = clazz.getSuperclass()) == null) continue;
                    tocheck.add(clazz);
                }
                if (ret == null && ((Class)type).isArray()) {
                    ret = this.titmanager.getTypeInfo(Object[].class, fullpath);
                }
                if (ret != null) {
                    ObjectInfo cri = ret.getObjectInfo();
                    ObjectInfo cricpy = cri != null ? new ObjectInfo(type, cri.getPostProcessor()) : new ObjectInfo(type);
                    TypeInfo ti = new TypeInfo(ret.getXMLInfo(), cricpy, ret.getMappingInfo(), ret.getLinkInfo());
                    this.titmanager.addTypeInfo(ti);
                } else {
                    if (this.no_typeinfos == null) {
                        this.no_typeinfos = new HashSet<Object>();
                    }
                    this.no_typeinfos.add(type);
                }
            }
        }
        return ret;
    }

    @Override
    public Object createObject(Object type, boolean root, AReadContext context, Map<String, String> rawattributes) throws Exception {
        Object ret = null;
        if (type instanceof QName) {
            QName tag = (QName)type;
            if (tag.equals(SXML.NULL)) {
                ret = AReader.NULL;
            } else {
                String pck = tag.getNamespaceURI().substring("typeinfo:".length());
                String clazzname = pck.length() > 0 ? pck + "." + tag.getLocalPart().replace("-", "$") : tag.getLocalPart().replace("-", "$");
                int idx = clazzname.indexOf("__");
                int dim = 0;
                int len = 0;
                if (idx != -1) {
                    String strlens = clazzname.substring(idx + 2);
                    clazzname = clazzname.substring(0, idx);
                    clazzname = STransformation.getClassname((String)clazzname);
                    StringTokenizer stok = new StringTokenizer(strlens, "__");
                    dim = Integer.parseInt(stok.nextToken());
                    for (int i = 0; i < dim - 1; ++i) {
                        clazzname = clazzname + "[]";
                    }
                    len = Integer.parseInt(rawattributes.get("__len"));
                } else {
                    clazzname = STransformation.getClassname((String)clazzname);
                }
                Class<?> clazz = SReflect.classForName((String)clazzname, (ClassLoader)context.getClassLoader());
                if (dim > 0) {
                    ret = Array.newInstance(clazz, len);
                } else if (!BasicTypeConverter.isBuiltInType((Class)clazz)) {
                    Constructor<Object> c;
                    if (clazz.isAnonymousClass()) {
                        if ((clazz = this.getCorrectAnonymousInnerClass(clazz, rawattributes, context.getClassLoader())) != null) {
                            try {
                                c = clazz.getDeclaredConstructors()[0];
                                c.setAccessible(true);
                                Class<?>[] paramtypes = c.getParameterTypes();
                                Object[] paramvalues = new Object[paramtypes.length];
                                for (int i = 0; i < paramtypes.length; ++i) {
                                    if (paramtypes[i].equals(Boolean.TYPE)) {
                                        paramvalues[i] = Boolean.FALSE;
                                        continue;
                                    }
                                    if (!SReflect.isBasicType(paramtypes[i])) continue;
                                    paramvalues[i] = 0;
                                }
                                ret = c.newInstance(paramvalues);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            context.getReporter().report("Anonymous class problem.", "Creation problem.", context, context.getLocation());
                        }
                    } else {
                        c = clazz.getDeclaredConstructor(new Class[0]);
                        if (!Modifier.isPublic(c.getModifiers()) || !Modifier.isPublic(clazz.getModifiers())) {
                            c.setAccessible(true);
                        }
                        ret = c.newInstance(new Object[0]);
                    }
                } else if (String.class.equals((Object)clazz)) {
                    ret = AReader.STRING_MARKER;
                }
            }
        } else if (type instanceof TypeInfo) {
            Object ti = ((TypeInfo)type).getTypeInfo();
            type = ti instanceof Class && ((Class)ti).isInterface() ? ((TypeInfo)type).getXMLTag() : ti;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (!BasicTypeConverter.isBuiltInType((Class)clazz)) {
                try {
                    ret = clazz.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (type instanceof IBeanObjectCreator) {
            ret = ((IBeanObjectCreator)type).createObject(context, rawattributes);
        }
        return ret;
    }

    protected Class<?> getCorrectAnonymousInnerClass(Class<?> clazz, Map<String, String> rawattributes, ClassLoader classloader) {
        Class ret;
        Class clazz2 = ret = this.isCorrectAnonymousInnerClass(clazz, rawattributes) ? clazz : null;
        if (ret == null) {
            String name = clazz.getName();
            int idx = name.lastIndexOf(36);
            String start = name.substring(0, idx + 1);
            String end = name.substring(idx + 1);
            int num = Integer.parseInt(end);
            int i = 1;
            while (ret == null) {
                if (i != num) {
                    String clazzname = start + Integer.toString(i);
                    clazz = SReflect.classForName0((String)clazzname, (ClassLoader)classloader);
                    if (clazz == null) break;
                    if (this.isCorrectAnonymousInnerClass(clazz, rawattributes)) {
                        ret = clazz;
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    protected boolean isCorrectAnonymousInnerClass(Class<?> clazz, Map<String, String> rawattributes) {
        boolean ret = true;
        String rawclname = rawattributes.get("XML_CLASSNAME");
        if (rawclname != null) {
            Classname xmlc;
            try {
                Field f = clazz.getField("XML_CLASSNAME");
                f.setAccessible(true);
                String clname = (String)f.get(null);
                ret = rawclname.equals(clname);
            }
            catch (Exception e) {
                ret = false;
            }
            if (!ret && (xmlc = SXML.getXMLClassnameAnnotation(clazz)) != null) {
                ret = rawclname.equals(xmlc.value());
            }
        }
        return ret;
    }

    public Object getObjectType(Object object, AReadContext context) {
        return object.getClass();
    }

    @Override
    public Object convertContentObject(String value, QName tag, AReadContext context) throws Exception {
        String clazzname;
        Class clazz;
        Object ret = value;
        if (tag.getNamespaceURI().startsWith("typeinfo:") && (clazz = SReflect.classForName0((String)(clazzname = tag.getNamespaceURI().substring("typeinfo:".length()) + "." + tag.getLocalPart()), (ClassLoader)context.getClassLoader())) != null) {
            if (BasicTypeConverter.isBuiltInType((Class)clazz)) {
                ret = BasicTypeConverter.getBasicStringConverter((Class)clazz).convertString(value, (Object)context);
            } else {
                ret = null;
                context.getReporter().report("No converter known for: " + clazz, "content error", context, context.getLocation());
            }
        }
        return ret;
    }

    @Override
    public void handleAttributeValue(Object object, QName xmlattrname, List<QName> attrpath, String attrval, Object attrinfo, AReadContext context) throws Exception {
        IAttributeConverter converter = attrinfo instanceof AttributeInfo ? ((AttributeInfo)attrinfo).getConverter() : null;
        String id = attrinfo instanceof AttributeInfo ? ((AttributeInfo)attrinfo).getId() : null;
        Object accessinfo = attrinfo instanceof AttributeInfo ? ((AttributeInfo)attrinfo).getAccessInfo() : attrinfo;
        Object val = attrval;
        boolean done = false;
        if (val != null && converter instanceof IStringObjectConverter) {
            try {
                val = ((IStringObjectConverter)converter).convertString((String)val, (Object)context);
            }
            catch (Exception e) {
                done = true;
                context.getReporter().report("Failure in parsing attribute: " + xmlattrname + " of object " + object + ": " + e, "attribute error", context, context.getLocation());
            }
            converter = null;
        }
        if (!done) {
            boolean set;
            if (attrval != null) {
                boolean set2 = this.setElementValue(accessinfo, xmlattrname, object, val, converter, id, context);
                if (!set2) {
                    context.getReporter().report("Failure in setting attribute: " + (xmlattrname != null ? xmlattrname : attrinfo) + " on object: " + object + " (unknown attribute?)", "attribute error", context, context.getLocation());
                }
            } else if (accessinfo instanceof AccessInfo && ((AccessInfo)accessinfo).getDefaultValue() != null && !(set = this.setElementValue(accessinfo, xmlattrname, object, ((AccessInfo)accessinfo).getDefaultValue(), converter, id, context))) {
                context.getReporter().report("Failure in setting attribute: " + (xmlattrname != null ? xmlattrname : attrinfo) + " on object: " + object + " (unknown attribute?)", "attribute error", context, context.getLocation());
            }
        }
    }

    @Override
    public void linkObject(Object object, Object parent, Object linkinfo, QName[] pathname, AReadContext context) throws Exception {
        QName tag = pathname[pathname.length - 1];
        boolean linked = false;
        if (linkinfo instanceof SubobjectInfo) {
            SubobjectInfo sinfo = (SubobjectInfo)linkinfo;
            linked = this.setElementValue(sinfo.getAccessInfo(), tag, parent, object, sinfo.getConverter(), null, context);
        } else if (parent.getClass().isArray()) {
            int cnt = context.getArrayCount(parent);
            if (!AReader.NULL.equals(object)) {
                Array.set(parent, cnt, object);
            }
            linked = true;
        } else {
            for (int i = 0; !linked && i < pathname.length; ++i) {
                linked = this.setElementValue(null, pathname[i], parent, object, null, null, context);
            }
            if (!linked) {
                LinkedList classes = new LinkedList();
                classes.add(object.getClass());
                while (!linked && !classes.isEmpty()) {
                    Class clazz = (Class)classes.remove(0);
                    if (!BasicTypeConverter.isBuiltInType((Class)clazz)) {
                        String name = SReflect.getInnerClassName((Class)clazz);
                        linked = this.setElementValue(name, null, parent, object, null, null, context);
                    }
                    if (linked) continue;
                    if (clazz.getSuperclass() != null) {
                        classes.add(clazz.getSuperclass());
                    }
                    Class<?>[] ifs = clazz.getInterfaces();
                    for (int i = 0; i < ifs.length; ++i) {
                        classes.add(ifs[i]);
                    }
                }
            }
        }
        if (!linked) {
            context.getReporter().report("Could not link: " + object + " " + parent, "link error", context, context.getLocation());
        }
    }

    public void bulkLinkObjects(List<Object> childs, Object parent, Object linkinfo, QName[] pathname, AReadContext context) throws Exception {
        QName tag = pathname[pathname.length - 1];
        boolean linked = false;
        if (linkinfo != null) {
            linked = this.setBulkAttributeValues(linkinfo, tag, parent, childs, null, null, context);
        } else if (parent.getClass().isArray()) {
            for (int i = 0; i < childs.size(); ++i) {
                int cnt = context.getArrayCount(parent);
                Object object = childs.get(i);
                if (AReader.NULL.equals(object)) continue;
                Array.set(parent, cnt, object);
            }
            linked = true;
        } else {
            for (int i = 0; !linked && i < pathname.length; ++i) {
                linked = this.setBulkAttributeValues(null, pathname[i], parent, childs, null, null, context);
            }
            if (!linked) {
                LinkedList classes = new LinkedList();
                classes.add(childs.get(0).getClass());
                while (!linked && !classes.isEmpty()) {
                    Class clazz = (Class)classes.remove(0);
                    if (!BasicTypeConverter.isBuiltInType((Class)clazz)) {
                        String name = SReflect.getInnerClassName((Class)clazz);
                        linked = this.setBulkAttributeValues(name, null, parent, childs, null, null, context);
                    }
                    if (linked) continue;
                    if (clazz.getSuperclass() != null) {
                        classes.add(clazz.getSuperclass());
                    }
                    Class<?>[] ifs = clazz.getInterfaces();
                    for (int i = 0; i < ifs.length; ++i) {
                        classes.add(ifs[i]);
                    }
                }
            }
        }
        if (!linked) {
            context.getReporter().report("Could not bulk link: " + childs + " " + parent, "link error", context, context.getLocation());
        }
    }

    @Override
    public void bulkLinkObjects(Object parent, List<LinkData> children, AReadContext context) throws Exception {
        LinkData linkdata = children.get(0);
        ArrayList<Object> childs = new ArrayList<Object>();
        childs.add(linkdata.getChild());
        Object[] pathname = linkdata.getPathname();
        int startidx = 0;
        for (int i = 1; i < children.size(); ++i) {
            LinkData ld = children.get(i);
            Object[] pn = ld.getPathname();
            if (!Arrays.equals(pathname, pn)) {
                this.handleBulkLinking(childs, parent, context, (QName[])pathname, children, startidx);
                pathname = pn;
                linkdata = ld;
                childs.clear();
                startidx = i;
            }
            childs.add(ld.getChild());
        }
        this.handleBulkLinking(childs, parent, context, (QName[])pathname, children, startidx);
    }

    protected void handleBulkLinking(List<Object> childs, Object parent, AReadContext context, QName[] pathname, List<LinkData> linkdatas, int startidx) throws Exception {
        if (childs.size() > 1) {
            try {
                this.bulkLinkObjects(childs, parent, linkdatas.get(startidx).getLinkinfo(), pathname, context);
            }
            catch (Exception e) {
                context.getReporter().report("Warning. Bulk link initiated but not successful: " + childs + " " + parent + " " + e, "warning", context, context.getLocation());
                for (int i = 0; i < childs.size(); ++i) {
                    this.linkObject(childs.get(i), parent, linkdatas.get(startidx + i).getLinkinfo(), pathname, context);
                }
            }
        } else {
            this.linkObject(childs.get(0), parent, linkdatas.get(startidx).getLinkinfo(), pathname, context);
        }
    }

    protected boolean setElementValue(Object accessinfo, QName xmlname, Object object, Object val, Object converter, String id, AReadContext context) throws Exception {
        Object arg;
        AccessInfo ai;
        boolean set = false;
        if (AReader.NULL.equals(val)) {
            set = true;
        } else if (accessinfo instanceof AccessInfo && ((AccessInfo)accessinfo).getExtraInfo() instanceof BeanAccessInfo) {
            Object arg2;
            ai = (AccessInfo)accessinfo;
            BeanAccessInfo bai = (BeanAccessInfo)ai.getExtraInfo();
            if (bai.getMapName() != null) {
                Object key = null;
                if (bai.getKeyHelp() != null) {
                    Object targetobj;
                    Object kh = bai.getKeyHelp();
                    Object object2 = targetobj = bai.isKeyFromParent() ? object : val;
                    if (kh instanceof Method) {
                        try {
                            key = ((Method)kh).invoke(targetobj, new Object[0]);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (Exception exception) {}
                    } else if (kh instanceof Field) {
                        try {
                            key = ((Field)kh).get(targetobj);
                        }
                        catch (Exception exception) {}
                    } else if (kh instanceof IReturnValueCommand) {
                        key = ((IReturnValueCommand)kh).execute(targetobj);
                    } else {
                        context.getReporter().report("Unknown key help: " + kh, "attribute error", context, context.getLocation());
                    }
                } else {
                    Object object3 = key = ai.getObjectIdentifier() != null ? ai.getObjectIdentifier() : xmlname;
                }
                if (bai.getStoreHelp() != null) {
                    Object sh = bai.getStoreHelp();
                    if (sh instanceof Method) {
                        try {
                            Method m = (Method)sh;
                            Class<?>[] ps = m.getParameterTypes();
                            Object arg3 = this.convertValue(val, ps[1], converter, context, id);
                            m.invoke(object, key, arg3);
                            set = true;
                        }
                        catch (InvocationTargetException m) {
                        }
                        catch (Exception m) {}
                    } else if (sh instanceof Field) {
                        try {
                            Field f = (Field)sh;
                            HashMap map = f.get(object);
                            if (map == null) {
                                map = new HashMap();
                                f.set(object, map);
                            }
                            Object arg4 = this.convertValue(val, null, converter, context, id);
                            ((Map)map).put(key, arg4);
                            set = true;
                        }
                        catch (Exception f) {}
                    } else if (sh instanceof IReturnValueCommand) {
                        arg2 = this.convertValue(val, null, converter, context, id);
                        ((IReturnValueCommand)sh).execute(new Object[]{object, arg2});
                    } else {
                        context.getReporter().report("Unknown map store help: " + sh, "attribute error", context, context.getLocation());
                    }
                } else {
                    String mapname = bai.getMapName().length() == 0 || "__this".equals(bai.getMapName()) ? "" : bai.getMapName().substring(0, 1).toUpperCase() + bai.getMapName().substring(1);
                    String[] prefixes = new String[]{"put", "set", "add"};
                    for (int i = 0; i < prefixes.length && !set; ++i) {
                        Method[] ms = SReflect.getMethods(object.getClass(), (String)(prefixes[i] + mapname));
                        for (int j = 0; j < ms.length && !set; ++j) {
                            Class<?>[] ps = ms[j].getParameterTypes();
                            if (ps.length != 2) continue;
                            Object arg5 = this.convertValue(val, ps[1], converter, context, id);
                            try {
                                ms[j].invoke(object, key, arg5);
                                set = true;
                                continue;
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            } else if (bai.getStoreHelp() != null) {
                Object sh = bai.getStoreHelp();
                if (sh instanceof Method) {
                    Method m = (Method)sh;
                    Class<?>[] ps = m.getParameterTypes();
                    if (ps.length == 1) {
                        Object arg6 = this.convertValue(val, ps[0], converter, context, id);
                        try {
                            m.invoke(object, arg6);
                            set = true;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (Exception exception) {}
                    } else {
                        context.getReporter().report("Read method should have one parameter: " + bai + " " + m, "attribute error", context, context.getLocation());
                    }
                } else if (sh instanceof Field) {
                    try {
                        Field f = (Field)sh;
                        arg2 = this.convertValue(val, f.getType(), converter, context, id);
                        f.set(object, arg2);
                        set = true;
                    }
                    catch (Exception f) {}
                } else if (sh instanceof IReturnValueCommand) {
                    arg = this.convertValue(val, null, converter, context, id);
                    ((IReturnValueCommand)sh).execute(new Object[]{object, arg});
                } else {
                    context.getReporter().report("Unknown store help: " + sh, "attribute error", context, context.getLocation());
                }
            }
        }
        if (!set && accessinfo instanceof AccessInfo) {
            String postfix;
            ai = (AccessInfo)accessinfo;
            String fieldname = ai.getObjectIdentifier() != null ? (String)ai.getObjectIdentifier() : xmlname.getLocalPart();
            set = this.setField(fieldname, object, val, converter, context, id);
            if (!set && !(set = this.invokeSetMethod(new String[]{"set", "add"}, postfix = ai.getObjectIdentifier() != null ? ((String)ai.getObjectIdentifier()).substring(0, 1).toUpperCase() + ((String)ai.getObjectIdentifier()).substring(1) : xmlname.getLocalPart().substring(0, 1).toUpperCase() + xmlname.getLocalPart().substring(1), val, object, context, converter, id))) {
                String oldpostfix = postfix;
                if (!(postfix = SUtil.getSingular((String)postfix)).equals(oldpostfix)) {
                    set = this.invokeSetMethod(new String[]{"set", "add"}, postfix, val, object, context, converter, id);
                }
            }
        } else if (!set) {
            String postfix;
            String fieldname;
            Map props = this.introspector.getBeanProperties(object.getClass(), true, true);
            Object prop = props.get(accessinfo instanceof String ? accessinfo : xmlname.getLocalPart());
            if (prop instanceof BeanProperty && !((BeanProperty)prop).isWritable()) {
                set = true;
            } else if (prop instanceof BeanProperty && ((BeanProperty)prop).isWritable()) {
                BeanProperty bprop = (BeanProperty)prop;
                arg = this.convertValue(val, bprop.getSetterType(), converter, context, id);
                try {
                    if (!"XML_CLASSNAME".equals(bprop.getName())) {
                        bprop.setPropertyValue(object, arg);
                    }
                    set = true;
                }
                catch (Exception arg2) {}
            } else if (prop instanceof Classname) {
                set = true;
            }
            if (!(set || (set = this.setField(fieldname = accessinfo instanceof String ? (String)accessinfo : xmlname.getLocalPart(), object, val, converter, context, id)) || (set = this.invokeSetMethod(new String[]{"set", "add"}, postfix = fieldname.substring(0, 1).toUpperCase() + fieldname.substring(1), val, object, context, converter, id)))) {
                String oldpostfix = postfix;
                if (!(postfix = SUtil.getSingular((String)postfix)).equals(oldpostfix)) {
                    set = this.invokeSetMethod(new String[]{"set", "add"}, postfix, val, object, context, converter, id);
                }
            }
        }
        return set;
    }

    protected boolean setBulkAttributeValues(Object accessinfo, QName xmlattrname, Object object, List<Object> vals, Object converter, String id, AReadContext context) throws Exception {
        AccessInfo ai;
        BeanAccessInfo bai;
        boolean set = false;
        if (accessinfo instanceof AccessInfo && ((AccessInfo)accessinfo).getExtraInfo() instanceof BeanAccessInfo && (bai = (BeanAccessInfo)(ai = (AccessInfo)accessinfo).getExtraInfo()).getStoreHelp() != null) {
            Object sh = bai.getStoreHelp();
            if (sh instanceof Method) {
                Method m = (Method)sh;
                Class<?>[] ps = m.getParameterTypes();
                if (ps.length == 1) {
                    Object arg = this.convertBulkValues(vals, ps[0], converter, context, id);
                    try {
                        m.invoke(object, arg);
                        set = true;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (Exception exception) {}
                } else {
                    context.getReporter().report("Read method should have one parameter: " + bai + " " + m, "attribute error", context, context.getLocation());
                }
            } else if (sh instanceof Field) {
                try {
                    Field f = (Field)sh;
                    Object arg = this.convertBulkValues(vals, f.getType(), converter, context, id);
                    f.set(object, arg);
                    set = true;
                }
                catch (Exception f) {}
            } else {
                context.getReporter().report("Unknown store help: " + sh, "attribute error", context, context.getLocation());
            }
        }
        if (!set && accessinfo instanceof AccessInfo) {
            ai = (AccessInfo)accessinfo;
            String fieldname = ai.getObjectIdentifier() != null ? (String)ai.getObjectIdentifier() : xmlattrname.getLocalPart();
            set = this.setBulkField(fieldname, object, vals, converter, context, id);
            if (!set) {
                String postfix = ai.getObjectIdentifier() != null ? ((String)ai.getObjectIdentifier()).substring(0, 1).toUpperCase() + ((String)ai.getObjectIdentifier()).substring(1) : xmlattrname.getLocalPart().substring(0, 1).toUpperCase() + xmlattrname.getLocalPart().substring(1);
                set = this.invokeBulkSetMethod(new String[]{"set"}, postfix, vals, object, context, converter, id);
            }
        } else if (!set) {
            Map props = this.introspector.getBeanProperties(object.getClass(), true, true);
            BeanProperty prop = (BeanProperty)props.get(accessinfo instanceof String ? accessinfo : xmlattrname.getLocalPart());
            if (prop != null) {
                Object arg = this.convertBulkValues(vals, prop.getSetterType(), null, context, null);
                try {
                    if (prop.isWritable()) {
                        prop.setPropertyValue(object, arg);
                    } else {
                        prop.getField().set(object, arg);
                    }
                    set = true;
                }
                catch (Exception f) {
                    // empty catch block
                }
            }
            if (!set) {
                String plupostfix;
                String postfix;
                String plufieldname;
                String fieldname = accessinfo instanceof String ? (String)accessinfo : xmlattrname.getLocalPart();
                set = this.setBulkField(fieldname, object, vals, converter, context, id);
                if (!set && !fieldname.equals(plufieldname = SUtil.getPlural((String)fieldname))) {
                    set = this.setBulkField(plufieldname, object, vals, converter, context, id);
                }
                if (!(set || (set = this.invokeBulkSetMethod(new String[]{"set"}, postfix = fieldname.substring(0, 1).toUpperCase() + fieldname.substring(1), vals, object, context, null, null)) || postfix.equals(plupostfix = SUtil.getPlural((String)postfix)))) {
                    set = this.invokeBulkSetMethod(new String[]{"set"}, plupostfix, vals, object, context, null, null);
                }
            }
        }
        return set;
    }

    protected boolean invokeSetMethod(String[] prefixes, String postfix, Object value, Object object, AReadContext context, Object converter, String idref) throws Exception {
        boolean set = false;
        for (int i = 0; i < prefixes.length && !set; ++i) {
            try {
                Method[] ms = SReflect.getMethods(object.getClass(), (String)(prefixes[i] + postfix));
                for (int j = 0; j < ms.length && !set; ++j) {
                    Class<?>[] ps = ms[j].getParameterTypes();
                    if (ps.length != 1) continue;
                    Object arg = this.convertValue(value, ps[0], converter, context, idref);
                    ms[j].invoke(object, arg);
                    set = true;
                }
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return set;
    }

    protected boolean invokeBulkSetMethod(String[] prefixes, String postfix, List<Object> vals, Object object, AReadContext context, Object converter, String idref) throws Exception {
        boolean set = false;
        for (int i = 0; i < prefixes.length && !set; ++i) {
            try {
                Method[] ms = SReflect.getMethods(object.getClass(), (String)(prefixes[i] + postfix));
                for (int j = 0; j < ms.length && !set; ++j) {
                    Class<?>[] ps = ms[j].getParameterTypes();
                    if (ps.length != 1) continue;
                    Object arg = this.convertBulkValues(vals, ps[0], converter, context, idref);
                    ms[j].invoke(object, arg);
                    set = true;
                }
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return set;
    }

    protected boolean setField(String fieldname, Object parent, Object object, Object converter, AReadContext context, String idref) throws Exception {
        boolean set = false;
        try {
            Field field = parent.getClass().getField(fieldname);
            Class<?> type = field.getType();
            Object val = object;
            val = this.convertValue(object, type, converter, context, idref);
            if (SReflect.isSupertype(type, val.getClass())) {
                field.set(parent, val);
                set = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return set;
    }

    protected boolean setBulkField(String fieldname, Object parent, List<Object> objects, Object converter, AReadContext context, String idref) throws Exception {
        boolean set;
        try {
            Field field = parent.getClass().getField(fieldname);
            Class<?> type = field.getType();
            Object arg = this.convertBulkValues(objects, type, converter, context, idref);
            field.set(parent, arg);
            set = true;
        }
        catch (Exception e) {
            set = false;
        }
        return set;
    }

    protected Object convertValue(Object val, Class<?> targetclass, Object converter, AReadContext context, String id) throws Exception {
        Object ret = val;
        if ("idref".equals(id)) {
            ret = context.getReadObjects().get(val);
        } else if (converter instanceof ISubObjectConverter) {
            ret = ((ISubObjectConverter)converter).convertObjectForRead(val, context);
        } else if (val instanceof String) {
            IStringObjectConverter conv;
            if (converter instanceof IStringObjectConverter) {
                ret = ((IStringObjectConverter)converter).convertString((String)val, (Object)context);
            } else if (targetclass != null && !String.class.isAssignableFrom(targetclass) && (conv = BasicTypeConverter.getBasicStringConverter(targetclass)) != null) {
                ret = conv.convertString((String)val, (Object)context);
            }
        }
        return ret;
    }

    protected Object convertBulkValues(List<Object> vals, Class<?> targetclass, Object converter, AReadContext context, String id) throws Exception {
        Object ret = vals;
        if (SReflect.isSupertype(Set.class, targetclass)) {
            ret = new HashSet<Object>(vals);
        } else if (targetclass.isArray()) {
            ret = Array.newInstance(targetclass.getComponentType(), vals.size());
            for (int j = 0; j < vals.size(); ++j) {
                Array.set(ret, j, vals.get(j));
            }
        } else if (!SReflect.isSupertype(Collection.class, targetclass)) {
            context.getReporter().report("Conversion to target no possible: " + targetclass + " " + vals, "convert error", context, context.getLocation());
        }
        return ret;
    }

    @Override
    public synchronized IPostProcessor[] getPostProcessors(Object object, Object typeinfo) {
        IPostProcessor tiproc;
        ArrayList<IPostProcessor> ret = new ArrayList<IPostProcessor>();
        IPostProcessor iPostProcessor = tiproc = typeinfo instanceof TypeInfo ? ((TypeInfo)typeinfo).getPostProcessor() : null;
        if (tiproc != null) {
            ret.add(tiproc);
        }
        if (this.postprocessors != null) {
            for (IFilter<Object> fil : this.postprocessors.keySet()) {
                if (!fil.filter(object)) continue;
                ret.add(this.postprocessors.get(fil));
            }
        }
        return ret.toArray(new IPostProcessor[ret.size()]);
    }

    public synchronized void addPostProcessor(IFilter<Object> filter, IPostProcessor processor) {
        if (this.postprocessors == null) {
            this.postprocessors = new LinkedHashMap<IFilter<Object>, IPostProcessor>();
        }
        this.postprocessors.put(filter, processor);
    }

    public synchronized void removePostProcessor(IFilter<Object> filter) {
        if (this.postprocessors != null) {
            this.postprocessors.remove(filter);
        }
    }
}

