/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.reader;

import jadex.commons.SUtil;
import jadex.commons.Tuple;
import jadex.xml.AttributeInfo;
import jadex.xml.IAttributeConverter;
import jadex.xml.IPostProcessor;
import jadex.xml.StackElement;
import jadex.xml.SubobjectInfo;
import jadex.xml.TypeInfo;
import jadex.xml.TypeInfoPathManager;
import jadex.xml.reader.AReadContext;
import jadex.xml.reader.IBulkObjectLinker;
import jadex.xml.reader.IObjectLinker;
import jadex.xml.reader.IObjectReaderHandler;
import jadex.xml.reader.IPostProcessorCall;
import jadex.xml.reader.IXMLReader;
import jadex.xml.reader.LinkData;
import jadex.xml.stax.ILocation;
import jadex.xml.stax.QName;
import jadex.xml.stax.XMLReporter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AReader {
    public static final boolean DEBUG = false;
    public static final Object STRING_MARKER = new Object();
    public static final ThreadLocal<AReadContext> READ_CONTEXT = new ThreadLocal();
    public static final Object NULL = new Object();
    protected boolean bulklink;
    protected XMLReporter reporter;

    public AReader(boolean bulklink, XMLReporter reporter) {
        this.bulklink = bulklink;
        this.reporter = reporter;
    }

    public static Object objectFromXML(AReader reader, String val, ClassLoader classloader, TypeInfoPathManager manager, IObjectReaderHandler handler) {
        return AReader.objectFromXML(reader, val, classloader, null, manager, handler);
    }

    public static Object objectFromXML(AReader reader, String val, ClassLoader classloader, Object context, TypeInfoPathManager manager, IObjectReaderHandler handler) {
        StringReader rd = null;
        try {
            Object ret;
            rd = new StringReader(val);
            Object object = ret = reader.read(manager, handler, rd, classloader, context);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (rd != null) {
                try {
                    ((Reader)rd).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Object objectFromByteArray(AReader reader, byte[] val, ClassLoader classloader, TypeInfoPathManager manager, IObjectReaderHandler handler) {
        return AReader.objectFromInputStream(reader, new ByteArrayInputStream(val), classloader, null, manager, handler);
    }

    public static Object objectFromByteArray(AReader reader, byte[] val, ClassLoader classloader, Object context, TypeInfoPathManager manager, IObjectReaderHandler handler) {
        return AReader.objectFromInputStream(reader, new ByteArrayInputStream(val), classloader, context, manager, handler);
    }

    public static Object objectFromInputStream(AReader reader, InputStream val, ClassLoader classloader, TypeInfoPathManager manager, IObjectReaderHandler handler) {
        return AReader.objectFromInputStream(reader, val, classloader, null, manager, handler);
    }

    public static Object objectFromInputStream(AReader reader, InputStream bis, ClassLoader classloader, Object context, TypeInfoPathManager manager, IObjectReaderHandler handler) {
        try {
            Object ret;
            Object object = ret = reader.read(manager, handler, bis, classloader, context);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static SubobjectInfo getSubobjectInfoRead(QName localname, QName[] fullpath, TypeInfo patypeinfo, Map<String, String> attrs) {
        SubobjectInfo ret = null;
        if (patypeinfo != null) {
            QName tag = localname;
            QName[] fpath = fullpath;
            if (localname.getNamespaceURI().startsWith("typeinfo:")) {
                tag = fullpath[fullpath.length - 2];
                fpath = new QName[fullpath.length - 1];
                System.arraycopy(fullpath, 0, fpath, 0, fpath.length);
            }
            ret = patypeinfo.getSubobjectInfoRead(tag, fpath, attrs);
        }
        return ret;
    }

    public Object read(TypeInfoPathManager tipmanager, IObjectReaderHandler handler, Reader input, ClassLoader classloader, Object callcontext) throws Exception {
        IXMLReader parser = this.createXMLReader(input);
        return this.read(tipmanager, handler, parser, classloader, callcontext);
    }

    public Object read(TypeInfoPathManager tipmanager, IObjectReaderHandler handler, InputStream input, ClassLoader classloader, Object callcontext) throws Exception {
        IXMLReader parser = this.createXMLReader(input);
        return this.read(tipmanager, handler, parser, classloader, callcontext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(TypeInfoPathManager tipmanager, IObjectReaderHandler handler, IXMLReader parser, ClassLoader classloader, Object callcontext) throws Exception {
        AReadContext readcontext = this.createReadContext(tipmanager, handler, parser, this.reporter, callcontext, classloader);
        AReadContext oldcontext = READ_CONTEXT.get();
        READ_CONTEXT.set(readcontext);
        try {
            while (parser.hasNext()) {
                int next = parser.next();
                if (next == 5) {
                    this.handleComment(readcontext);
                    continue;
                }
                if (next == 4 || next == 12) {
                    this.handleContent(readcontext);
                    continue;
                }
                if (next == 1) {
                    this.handleStartElement(readcontext);
                    continue;
                }
                if (next != 2) continue;
                this.handleEndElement(readcontext);
            }
            int i = 1;
            while (readcontext.getPostProcessors().size() > 0) {
                List ps = (List)readcontext.getPostProcessors().remove((Object)i);
                if (ps != null) {
                    for (int j = 0; j < ps.size(); ++j) {
                        ((IPostProcessorCall)ps.get(j)).callPostProcessor();
                    }
                }
                ++i;
            }
        }
        catch (RuntimeException e) {
            ILocation loc = readcontext.getStackSize() > 0 ? readcontext.getTopStackElement().getLocation() : parser.getLocation();
            readcontext.getReporter().report(e.toString(), "XML error", readcontext, loc);
        }
        finally {
            READ_CONTEXT.set(oldcontext);
            parser.close();
        }
        return readcontext.getRootObject() == NULL ? null : readcontext.getRootObject();
    }

    protected void handleComment(AReadContext readcontext) throws Exception {
        if (readcontext.getReadIgnore() == 0) {
            readcontext.setComment(readcontext.getParser().getText());
        }
    }

    protected void handleContent(AReadContext readcontext) throws Exception {
        if (readcontext.getReadIgnore() == 0) {
            readcontext.getTopStackElement().addContent(readcontext.getParser().getText());
        }
    }

    protected void handleStartElement(AReadContext readcontext) throws Exception {
        IXMLReader parser = readcontext.getParser();
        if (readcontext.getReadIgnore() > 0) {
            readcontext.setReadIgnore(readcontext.getReadIgnore() + 1);
        } else if (readcontext.getReadIgnore() == 0) {
            IObjectReaderHandler handler;
            HashMap<String, String> rawattrs = null;
            int attrcnt = parser.getAttributeCount();
            if (attrcnt > 0) {
                rawattrs = new HashMap<String, String>();
                for (int i = 0; i < attrcnt; ++i) {
                    String attrname = parser.getAttributeLocalName(i);
                    String attrval = parser.getAttributeValue(i);
                    rawattrs.put(attrname, attrval);
                }
            }
            Object object = null;
            QName localname = parser.getName();
            QName[] fullpath = readcontext.getXMLPath(localname);
            TypeInfo typeinfo = readcontext.getPathManager().getTypeInfo(localname, fullpath, rawattrs);
            IObjectReaderHandler iObjectReaderHandler = handler = typeinfo != null ? typeinfo.getReaderHandler() : null;
            if (handler == null) {
                if (readcontext.getTopStackElement() != null && readcontext.getTopStackElement().getReaderHandler() != null) {
                    handler = readcontext.getTopStackElement().getReaderHandler();
                } else if (readcontext.getDefaultHandler() != null) {
                    handler = readcontext.getDefaultHandler();
                } else {
                    readcontext.getReporter().report("No handler for element: " + localname, "type info error", readcontext, parser.getLocation());
                }
            }
            if (readcontext.getStackSize() > 0) {
                TypeInfo patypeinfo;
                SubobjectInfo linkinfo;
                StackElement pse = readcontext.getTopStackElement();
                ArrayList<QName> pathname = new ArrayList<QName>();
                pathname.add(localname);
                for (int i = readcontext.getStackSize() - 2; i >= 0 && pse.getObject() == null; --i) {
                    pse = readcontext.getStackElement(i);
                    pathname.add(0, readcontext.getStackElement(i + 1).getTag());
                }
                if (pse != null && (linkinfo = AReader.getSubobjectInfoRead(localname, fullpath, patypeinfo = pse.getTypeInfo(), readcontext.getTopStackElement() != null ? readcontext.getTopStackElement().getRawAttributes() : null)) != null && linkinfo.getAccessInfo().isIgnoreRead()) {
                    readcontext.setReadIgnore(readcontext.getReadIgnore() + 1);
                }
            }
            if (readcontext.getReadIgnore() == 0) {
                String idref;
                String string = idref = rawattrs != null ? (String)rawattrs.get("__IDREF") : null;
                if (idref != null) {
                    StackElement se;
                    if (readcontext.getReadObjects().containsKey(idref)) {
                        object = readcontext.getReadObjects().get(idref);
                        se = new StackElement(handler, localname, object, rawattrs, typeinfo, parser.getLocation());
                        readcontext.addStackElement(se);
                    } else {
                        se = new StackElement(handler, localname, null, rawattrs, typeinfo, parser.getLocation());
                        readcontext.addStackElement(se);
                        readcontext.getReporter().report("idref not contained: " + idref, "idref error", se, se.getLocation());
                    }
                } else {
                    Object commentinfo;
                    String id;
                    Object ti = typeinfo;
                    if (localname.getNamespaceURI().startsWith("typeinfo:") && (typeinfo == null || typeinfo.isCreateFromTag())) {
                        ti = localname;
                    }
                    try {
                        object = handler.createObject(ti, readcontext.getStackSize() == 0, readcontext, rawattrs);
                    }
                    catch (Exception e) {
                        readcontext.getReporter().report(e.toString(), "creation error", readcontext, parser.getLocation());
                        readcontext.removeStackElement();
                        readcontext.setReadIgnore(1);
                    }
                    if (typeinfo == null && object != null) {
                        typeinfo = handler.getTypeInfo(object, fullpath, readcontext);
                    }
                    String string2 = id = rawattrs != null ? (String)rawattrs.get("__ID") : null;
                    if (id != null && object != null) {
                        readcontext.getReadObjects().put(id, object);
                    }
                    readcontext.addStackElement(new StackElement(handler, localname, object, rawattrs, typeinfo, parser.getLocation()));
                    int atcnt = attrcnt;
                    if (rawattrs != null) {
                        Collection<AttributeInfo> attrinfos;
                        if (rawattrs.containsKey("__ID")) {
                            --atcnt;
                        }
                        if (rawattrs.containsKey("__len")) {
                            --atcnt;
                        }
                        Collection<AttributeInfo> collection = attrinfos = typeinfo == null ? null : typeinfo.getAttributeInfos();
                        if (attrinfos != null) {
                            for (AttributeInfo attrinfo : attrinfos) {
                                boolean contains = rawattrs.containsKey(attrinfo.getAccessInfo().getXmlObjectName().getLocalPart());
                                boolean ignore = attrinfo.isIgnoreRead();
                                if (!contains || !ignore) continue;
                                --atcnt;
                            }
                        }
                    }
                    if (atcnt > 0) {
                        ArrayList<QName> attrpath = null;
                        if (object == null) {
                            attrpath = new ArrayList<QName>();
                            attrpath.add(readcontext.getTopStackElement().getTag());
                            for (int i = readcontext.getStackSize() - 2; i >= 0 && object == null; --i) {
                                StackElement pse = readcontext.getStackElement(i);
                                attrpath.add(pse.getTag());
                                typeinfo = pse.getTypeInfo();
                                object = pse.getObject();
                            }
                        }
                        if (object != null) {
                            Set<Object> attrs = typeinfo == null ? Collections.EMPTY_SET : typeinfo.getXMLAttributeNames();
                            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                                Object attrinfo;
                                QName attrname;
                                QName qName = attrname = parser.getAttributePrefix(i) == null || "".equals(parser.getAttributePrefix(i)) ? new QName(parser.getAttributeLocalName(i)) : new QName(parser.getAttributeNamespace(i), parser.getAttributeLocalName(i), parser.getAttributePrefix(i));
                                if ("__ID".equals(attrname.getLocalPart()) || "__len".equals(attrname.getLocalPart())) continue;
                                String attrval = parser.getAttributeValue(i);
                                attrs.remove(attrname);
                                Object object2 = attrinfo = typeinfo != null ? typeinfo.getAttributeInfo(attrname) : null;
                                if (attrinfo == null && typeinfo != null && attrpath != null) {
                                    LinkedList<QName> key = new LinkedList<QName>();
                                    key.add(attrname);
                                    for (int j = 0; attrinfo == null && j < attrpath.size(); ++j) {
                                        key.add(0, (QName)attrpath.get(j));
                                        attrinfo = typeinfo.getAttributeInfo(new Tuple(key.toArray()));
                                    }
                                }
                                if (attrinfo instanceof AttributeInfo && ((AttributeInfo)attrinfo).isIgnoreRead()) continue;
                                handler.handleAttributeValue(object, attrname, attrpath, attrval, attrinfo, readcontext);
                                if (!(attrinfo instanceof AttributeInfo) || !"id".equals(((AttributeInfo)attrinfo).getId())) continue;
                                readcontext.getReadObjects().put(attrval, object);
                            }
                            for (Object key : attrs) {
                                if (!(key instanceof QName)) continue;
                                Object attrinfo = typeinfo.getAttributeInfo(key);
                                handler.handleAttributeValue(object, (QName)key, attrpath, null, attrinfo, readcontext);
                            }
                        } else {
                            StackElement se = readcontext.getTopStackElement();
                            readcontext.getReporter().report("No element on stack for attributes", "stack error", se, se.getLocation());
                        }
                    }
                    if (readcontext.getComment() != null && typeinfo != null && (commentinfo = typeinfo.getCommentInfo()) != null) {
                        handler.handleAttributeValue(object, null, null, readcontext.getComment(), commentinfo, readcontext);
                    }
                }
            }
            readcontext.setComment(null);
        }
    }

    protected void handleEndElement(final AReadContext readcontext) throws Exception {
        if (readcontext.getReadIgnore() == 0) {
            String id;
            IPostProcessor[] postprocs;
            IXMLReader parser = readcontext.getParser();
            StackElement topse = readcontext.getTopStackElement();
            QName localname = parser.getName();
            QName[] fullpath = readcontext.getXMLPath();
            TypeInfo typeinfo = readcontext.getPathManager().getTypeInfo(localname, fullpath, topse.getRawAttributes());
            if (topse.getObject() == null && topse.getContent() != null && topse.getContent().trim().length() > 0 || topse.getObject() == STRING_MARKER) {
                Object val;
                Object object = val = topse.getContent() != null ? topse.getContent() : topse.getObject();
                if (val instanceof String) {
                    if (typeinfo != null && typeinfo.getContentInfo() != null) {
                        IAttributeConverter conv;
                        Object coninfo = typeinfo.getContentInfo();
                        if (coninfo != null && coninfo instanceof AttributeInfo && (conv = ((AttributeInfo)coninfo).getConverter()) != null) {
                            val = conv.convertString((String)val, readcontext);
                        }
                    } else {
                        val = topse.getReaderHandler().convertContentObject((String)val, localname, readcontext);
                    }
                }
                topse = new StackElement(topse.getReaderHandler(), topse.getTag(), val, topse.getRawAttributes(), null, topse.getLocation());
                readcontext.setStackElement(topse, readcontext.getStackSize() - 1);
            }
            if (topse.getObject() != null && topse.getContent() != null && topse.getContent().trim().length() > 0) {
                if (typeinfo != null && typeinfo.getContentInfo() != null) {
                    topse.getReaderHandler().handleAttributeValue(topse.getObject(), null, null, topse.getContent(), typeinfo.getContentInfo(), readcontext);
                } else {
                    StackElement se = readcontext.getTopStackElement();
                    readcontext.getReporter().report("No content mapping for: " + topse.getContent() + " tag=" + topse.getTag(), "link error", se, se.getLocation());
                }
            }
            if ((postprocs = topse.getReaderHandler().getPostProcessors(topse.getObject(), typeinfo)) != null && postprocs.length > 0) {
                for (int i = 0; i < postprocs.length; ++i) {
                    if (postprocs[i].getPass() == 0) {
                        try {
                            Object changed = postprocs[i].postProcess(readcontext, topse.getObject());
                            if (changed == IPostProcessor.DISCARD_OBJECT) {
                                topse.setObject(null);
                                continue;
                            }
                            if (changed == null) continue;
                            topse.setObject(changed);
                        }
                        catch (RuntimeException e) {
                            readcontext.getReporter().report("Error during postprocessing: " + e, "postprocessor error", topse, topse.getLocation());
                        }
                        continue;
                    }
                    final StackElement ftopse = topse;
                    final StackElement[] stack = readcontext.getStack();
                    final int fi = i;
                    readcontext.getPostProcessors().add((Object)postprocs[i].getPass(), (Object)new IPostProcessorCall(){

                        @Override
                        public void callPostProcessor() throws Exception {
                            try {
                                Object check = postprocs[fi].postProcess(readcontext, ftopse.getObject());
                                if (check != null) {
                                    readcontext.getReporter().report("Object replacement only possible in first pass.", "postprocessor error", ftopse, ftopse.getLocation());
                                }
                            }
                            catch (Exception e) {
                                readcontext.getReporter().report("Error during postprocessing: " + e, "postprocessor error", stack, ftopse != null ? ftopse.getLocation() : readcontext.getLocation());
                            }
                        }
                    });
                }
            }
            String string = id = topse.getRawAttributes() != null ? topse.getRawAttributes().get("__ID") : null;
            if (id != null && topse.getObject() != null) {
                readcontext.getReadObjects().put(id, topse.getObject());
            }
            if (topse.getObject() != null) {
                List<LinkData> childs;
                boolean bulklink;
                boolean bl = bulklink = typeinfo != null ? typeinfo.isBulkLink() : this.bulklink;
                if (readcontext.getStackSize() > 0 && bulklink && (childs = readcontext.removeChildren(topse.getObject())) != null) {
                    IBulkObjectLinker linker = (IBulkObjectLinker)(typeinfo != null && typeinfo.getLinker() != null ? typeinfo.getLinker() : topse.getReaderHandler());
                    linker.bulkLinkObjects(topse.getObject(), childs, readcontext);
                }
                if (readcontext.getStackSize() > 1) {
                    StackElement pse = readcontext.getStackElement(readcontext.getStackSize() - 2);
                    ArrayList<QName> pathname = new ArrayList<QName>();
                    pathname.add(localname);
                    for (int i = readcontext.getStackSize() - 3; i >= 0 && pse.getObject() == null; --i) {
                        pse = readcontext.getStackElement(i);
                        pathname.add(0, readcontext.getStackElement(i + 1).getTag());
                    }
                    if (pse.getObject() != null) {
                        TypeInfo patypeinfo = pse.getTypeInfo();
                        SubobjectInfo linkinfo = AReader.getSubobjectInfoRead(localname, fullpath, patypeinfo, topse.getRawAttributes());
                        boolean bl2 = bulklink = patypeinfo != null ? patypeinfo.isBulkLink() : this.bulklink;
                        if (!bulklink) {
                            IObjectLinker linker = (IObjectLinker)(patypeinfo != null && patypeinfo.getLinker() != null ? patypeinfo.getLinker() : pse.getReaderHandler());
                            linker.linkObject(topse.getObject(), pse.getObject(), linkinfo == null ? null : linkinfo, pathname.toArray(new QName[pathname.size()]), readcontext);
                        } else {
                            readcontext.addChild(pse.getObject(), new LinkData(topse.getObject(), linkinfo == null ? null : linkinfo, pathname.toArray(new QName[pathname.size()])));
                        }
                    } else {
                        StackElement se = readcontext.getTopStackElement();
                        readcontext.getReporter().report("No parent object found for: " + SUtil.arrayToString((Object)fullpath), "link error", se, se.getLocation());
                    }
                }
            }
            readcontext.removeStackElement();
        } else {
            readcontext.setReadIgnore(readcontext.getReadIgnore() - 1);
        }
    }

    protected AReadContext createReadContext(TypeInfoPathManager tipmanager, IObjectReaderHandler handler, IXMLReader parser, XMLReporter reporter, Object callcontext, ClassLoader classloader) {
        return new AReadContext(tipmanager, handler, parser, reporter, callcontext, classloader);
    }

    protected abstract IXMLReader createXMLReader(Reader var1);

    protected abstract IXMLReader createXMLReader(InputStream var1);
}

