/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.writer;

import jadex.commons.SReflect;
import jadex.commons.transformation.annotations.IncludeFields;
import jadex.xml.AccessInfo;
import jadex.xml.AttributeInfo;
import jadex.xml.IContext;
import jadex.xml.IPreProcessor;
import jadex.xml.ObjectInfo;
import jadex.xml.SubobjectInfo;
import jadex.xml.TypeInfo;
import jadex.xml.TypeInfoTypeManager;
import jadex.xml.stax.QName;
import jadex.xml.writer.IObjectWriterHandler;
import jadex.xml.writer.WriteObjectInfo;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractObjectWriterHandler
implements IObjectWriterHandler {
    protected boolean gentypetags;
    protected boolean prefertags;
    protected boolean flattening;
    protected TypeInfoTypeManager titmanager;

    public AbstractObjectWriterHandler(boolean gentypetags, boolean prefertags, boolean flattening, Set typeinfos) {
        this.gentypetags = gentypetags;
        this.prefertags = prefertags;
        this.flattening = flattening;
        this.titmanager = new TypeInfoTypeManager(typeinfos);
    }

    @Override
    public TypeInfo getTypeInfo(Object object, QName[] fullpath, IContext context) {
        TypeInfo ret = null;
        Object type = this.getObjectType(object, context);
        Set tis = this.titmanager.getTypeInfosByType(type);
        if (tis != null) {
            if (tis.size() == 1) {
                ret = (TypeInfo)tis.iterator().next();
            } else if (tis.size() > 1) {
                ret = this.titmanager.findTypeInfo(tis, fullpath);
            }
        }
        return ret;
    }

    public TypeInfoTypeManager getTypeInfoManager() {
        return this.titmanager;
    }

    public abstract Object getObjectType(Object var1, IContext var2);

    @Override
    public WriteObjectInfo getObjectWriteInfo(Object object, TypeInfo typeinfo, IContext context) throws Exception {
        boolean bl;
        WriteObjectInfo wi = new WriteObjectInfo();
        HashSet<String> doneprops = new HashSet<String>();
        if (typeinfo != null) {
            Collection<SubobjectInfo> subobsinfos;
            Collection<AttributeInfo> attrinfos;
            Object object2;
            Object value;
            Object property;
            Object object3 = typeinfo.getCommentInfo();
            if (object3 != null && (property = this.getProperty(object3)) != null) {
                doneprops.add(this.getPropertyName(property));
                if (!(object3 instanceof AttributeInfo && ((AttributeInfo)object3).isIgnoreWrite() || (value = this.getValue(object, property, context, object3)) == null)) {
                    wi.setComment(value.toString());
                }
            }
            if ((object2 = typeinfo.getContentInfo()) != null && (property = this.getProperty(object2)) != null) {
                doneprops.add(this.getPropertyName(property));
                if (!(object2 instanceof AttributeInfo && ((AttributeInfo)object2).isIgnoreWrite() || (value = this.getValue(object, property, context, object2)) == null)) {
                    wi.setContent(value.toString());
                }
            }
            if ((attrinfos = typeinfo.getAttributeInfos()) != null) {
                for (AttributeInfo attributeInfo : attrinfos) {
                    Object value2;
                    Object property2 = this.getProperty(attributeInfo);
                    if (property2 == null) continue;
                    doneprops.add(this.getPropertyName(property2));
                    if (attributeInfo instanceof AttributeInfo && attributeInfo.isIgnoreWrite() || (value2 = this.getValue(object, property2, context, attributeInfo)) == null) continue;
                    AttributeInfo attrinfo = attributeInfo;
                    if ("idref".equals(attrinfo.getId())) {
                        Set tis = this.titmanager.getTypeInfosByType(value2.getClass());
                        if (tis == null || tis.size() != 1) {
                            throw new RuntimeException("Could not determine type info for idref object: " + value2);
                        }
                        TypeInfo ti = (TypeInfo)tis.iterator().next();
                        AttributeInfo idinfo = null;
                        if (ti.getAttributeInfos() != null) {
                            Iterator<AttributeInfo> it2 = ti.getAttributeInfos().iterator();
                            while (idinfo == null && it2.hasNext()) {
                                AttributeInfo tmp = it2.next();
                                if (!"id".equals(tmp.getId())) continue;
                                idinfo = tmp;
                            }
                        }
                        if (idinfo == null && ti.getCommentInfo() instanceof AttributeInfo && "id".equals(((AttributeInfo)ti.getCommentInfo()).getId())) {
                            idinfo = (AttributeInfo)ti.getCommentInfo();
                        }
                        if (idinfo == null && ti.getContentInfo() instanceof AttributeInfo && "id".equals(((AttributeInfo)ti.getContentInfo()).getId())) {
                            idinfo = (AttributeInfo)ti.getContentInfo();
                        }
                        if (idinfo == null) {
                            throw new RuntimeException("Could not determine id attribute of type info: " + ti);
                        }
                        Object prop = this.getProperty(idinfo);
                        value2 = this.getValue(value2, prop, context, idinfo);
                    }
                    Object xmlattrname = null;
                    if (attributeInfo instanceof AttributeInfo) {
                        xmlattrname = attributeInfo.getXMLAttributeNames()[0];
                    }
                    if (xmlattrname == null) {
                        xmlattrname = this.getPropertyName(property2);
                    }
                    wi.addAttribute(xmlattrname, value2.toString());
                }
            }
            if (object.getClass().isArray()) {
                wi.addAttribute("__len", "" + Array.getLength(object));
            }
            if ((subobsinfos = typeinfo.getSubobjectInfos()) != null) {
                for (SubobjectInfo soinfo : subobsinfos) {
                    boolean flat;
                    Object value3;
                    AccessInfo ai = soinfo.getAccessInfo();
                    ObjectInfo obinfo = soinfo.getObjectInfo();
                    Object property3 = this.getProperty(soinfo);
                    if (property3 == null) continue;
                    String propname = this.getPropertyName(property3);
                    doneprops.add(propname);
                    if (ai != null && ai.isIgnoreWrite() || (value3 = this.getValue(object, property3, context, soinfo)) == null) continue;
                    QName[] xmlpath = soinfo.getXMLPathElements();
                    if (xmlpath == null) {
                        xmlpath = new QName[]{QName.valueOf(propname)};
                    }
                    if (soinfo.isMulti()) {
                        Iterator it2 = SReflect.getIterator((Object)value3);
                        boolean bl2 = flat = soinfo.getFlattening() != null ? soinfo.getFlattening() : this.flattening;
                        while (it2.hasNext()) {
                            Object val = it2.next();
                            if (!this.isTypeCompatible(val, obinfo, context)) continue;
                            QName[] path = this.createPath(xmlpath, val, context);
                            wi.addSubobject(path, val, flat);
                        }
                        continue;
                    }
                    if (!this.isTypeCompatible(value3, obinfo, context)) continue;
                    QName[] path = this.createPath(xmlpath, value3, context);
                    flat = soinfo.getFlattening() != null ? soinfo.getFlattening() : this.flattening;
                    wi.addSubobject(path, value3, flat);
                }
            }
        }
        boolean bl3 = false;
        boolean includefields = false;
        if (typeinfo != null) {
            bl = typeinfo.isIncludeMethods();
            includefields = typeinfo.isIncludeFields();
        } else {
            try {
                Field field;
                includefields = object.getClass().isAnnotationPresent(IncludeFields.class);
                if (!includefields && SReflect.getWrappedType((field = object.getClass().getField("XML_INCLUDE_FIELDS")).getType()).equals(Boolean.class)) {
                    includefields = (Boolean)field.get(object);
                }
            }
            catch (Exception field) {
                // empty catch block
            }
        }
        Collection props = null;
        if (typeinfo == null) {
            props = this.getProperties(object, context, true, includefields);
        } else if (bl || includefields) {
            props = this.getProperties(object, context, bl, includefields);
        }
        if (props != null) {
            for (Object property : props) {
                boolean prefertags;
                String propname = this.getPropertyName(property);
                if (doneprops.contains(propname)) continue;
                doneprops.add(propname);
                Object value = this.getValue(object, property, context, null);
                if (value == null) continue;
                Boolean pt = typeinfo != null && typeinfo.getMappingInfo() != null ? typeinfo.getMappingInfo().getPreferTags() : null;
                boolean bl4 = prefertags = pt != null ? pt : this.prefertags;
                if (!prefertags && this.isBasicType(property, value) && this.isDecodableToSameType(property, value, context)) {
                    if (value.equals(this.getDefaultValue(property))) continue;
                    wi.addAttribute(propname, value.toString());
                    continue;
                }
                QName[] xmlpath = new QName[]{QName.valueOf(propname)};
                QName[] path = this.createPath(xmlpath, value, context);
                wi.addSubobject(path, value, this.flattening);
            }
        }
        if (typeinfo == null && wi.getAttributes() == null && wi.getSubobjects() == null && wi.getContent() == null && doneprops.size() == 0 && this.isBasicType(null, object)) {
            wi.setContent(object.toString());
        }
        return wi;
    }

    protected QName[] createPath(QName[] xmlpath, Object value, IContext context) {
        QName[] ret = xmlpath;
        if (this.gentypetags) {
            ret = new QName[xmlpath.length + 1];
            System.arraycopy(xmlpath, 0, ret, 0, xmlpath.length);
        }
        return ret;
    }

    protected Object getDefaultValue(Object property) {
        Object ret = null;
        if (property instanceof AttributeInfo) {
            ret = ((AttributeInfo)property).getAccessInfo().getDefaultValue();
        }
        return ret;
    }

    @Override
    public IPreProcessor[] getPreProcessors(Object object, Object typeinfo) {
        IPreProcessor[] iPreProcessorArray;
        IPreProcessor pp;
        IPreProcessor iPreProcessor = pp = typeinfo instanceof TypeInfo ? ((TypeInfo)typeinfo).getPreProcessor() : null;
        if (pp == null) {
            iPreProcessorArray = null;
        } else {
            IPreProcessor[] iPreProcessorArray2 = new IPreProcessor[1];
            iPreProcessorArray = iPreProcessorArray2;
            iPreProcessorArray2[0] = pp;
        }
        return iPreProcessorArray;
    }

    protected abstract Object getValue(Object var1, Object var2, IContext var3, Object var4) throws Exception;

    protected abstract Object getProperty(Object var1);

    protected abstract String getPropertyName(Object var1);

    protected abstract Collection getProperties(Object var1, IContext var2, boolean var3, boolean var4);

    protected abstract boolean isBasicType(Object var1, Object var2);

    protected abstract boolean isTypeCompatible(Object var1, ObjectInfo var2, IContext var3);

    protected abstract boolean isDecodableToSameType(Object var1, Object var2, IContext var3);
}

