/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.connector;

import java.util.Optional;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.process.runtime.connector.Connector;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.core.common.model.connector.ActionDefinition;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.runtime.api.connector.ConnectorActionDefinitionFinder;
import org.activiti.runtime.api.connector.IntegrationContextBuilder;
import org.activiti.runtime.api.connector.OutboundVariablesProvider;
import org.springframework.context.ApplicationContext;

public class DefaultServiceTaskBehavior
extends AbstractBpmnActivityBehavior {
    private final ApplicationContext applicationContext;
    private final IntegrationContextBuilder integrationContextBuilder;
    private ConnectorActionDefinitionFinder connectorActionDefinitionFinder;
    private OutboundVariablesProvider outboundVariablesProvider;

    public DefaultServiceTaskBehavior(ApplicationContext applicationContext, IntegrationContextBuilder integrationContextBuilder, ConnectorActionDefinitionFinder connectorActionDefinitionFinder, OutboundVariablesProvider outboundVariablesProvider) {
        this.applicationContext = applicationContext;
        this.connectorActionDefinitionFinder = connectorActionDefinitionFinder;
        this.integrationContextBuilder = integrationContextBuilder;
        this.outboundVariablesProvider = outboundVariablesProvider;
    }

    public void execute(DelegateExecution execution) {
        ActionDefinition actionDefinition = this.findRelatedActionDefinition(execution);
        Connector connector = this.getConnector(this.getImplementation(execution));
        IntegrationContext integrationContext = (IntegrationContext)connector.apply((Object)this.integrationContextBuilder.from(execution, actionDefinition));
        execution.setVariables(this.outboundVariablesProvider.calculateVariables(integrationContext, actionDefinition));
        this.leave(execution);
    }

    public ActionDefinition findRelatedActionDefinition(DelegateExecution execution) {
        String implementation = this.getImplementation(execution);
        Optional<ActionDefinition> actionDefinitionOptional = this.connectorActionDefinitionFinder.find(implementation);
        return actionDefinitionOptional.orElse(null);
    }

    private String getImplementation(DelegateExecution execution) {
        return ((ServiceTask)execution.getCurrentFlowElement()).getImplementation();
    }

    private Connector getConnector(String implementation) {
        return (Connector)this.applicationContext.getBean(implementation, Connector.class);
    }

    private String getServiceTaskImplementation(DelegateExecution execution) {
        return ((ServiceTask)execution.getCurrentFlowElement()).getImplementation();
    }

    public boolean hasConnectorBean(DelegateExecution execution) {
        String implementation = this.getServiceTaskImplementation(execution);
        return this.applicationContext.containsBean(implementation) && this.applicationContext.getBean(implementation) instanceof Connector;
    }
}

