/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.connector;

import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.runtime.model.impl.IntegrationContextImpl;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.core.common.model.connector.ActionDefinition;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.integration.IntegrationContextEntity;
import org.activiti.runtime.api.connector.InboundVariablesProvider;

public class IntegrationContextBuilder {
    private InboundVariablesProvider inboundVariablesProvider;

    public IntegrationContextBuilder(InboundVariablesProvider inboundVariablesProvider) {
        this.inboundVariablesProvider = inboundVariablesProvider;
    }

    public IntegrationContext from(IntegrationContextEntity integrationContextEntity, DelegateExecution execution, ActionDefinition actionDefinition) {
        IntegrationContextImpl integrationContext = this.buildFromExecution(execution, actionDefinition);
        integrationContext.setId(integrationContextEntity.getId());
        return integrationContext;
    }

    public IntegrationContext from(DelegateExecution execution, ActionDefinition actionDefinition) {
        return this.buildFromExecution(execution, actionDefinition);
    }

    private IntegrationContextImpl buildFromExecution(DelegateExecution execution, ActionDefinition actionDefinition) {
        ServiceTask serviceTask;
        ExecutionEntity processInstance;
        IntegrationContextImpl integrationContext = new IntegrationContextImpl();
        integrationContext.setProcessInstanceId(execution.getProcessInstanceId());
        integrationContext.setProcessDefinitionId(execution.getProcessDefinitionId());
        integrationContext.setBusinessKey(execution.getProcessInstanceBusinessKey());
        integrationContext.setClientId(execution.getCurrentActivityId());
        if (ExecutionEntity.class.isInstance(execution) && (processInstance = ((ExecutionEntity)ExecutionEntity.class.cast(execution)).getProcessInstance()) != null) {
            integrationContext.setProcessDefinitionKey(processInstance.getProcessDefinitionKey());
            integrationContext.setProcessDefinitionVersion(processInstance.getProcessDefinitionVersion());
            integrationContext.setParentProcessInstanceId(processInstance.getParentProcessInstanceId());
        }
        if ((serviceTask = (ServiceTask)execution.getCurrentFlowElement()) != null) {
            integrationContext.setConnectorType(serviceTask.getImplementation());
            integrationContext.setClientName(serviceTask.getName());
            integrationContext.setClientType(ServiceTask.class.getSimpleName());
        }
        integrationContext.setInBoundVariables(this.inboundVariablesProvider.calculateVariables(execution, actionDefinition));
        return integrationContext;
    }
}

