/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.connector;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.core.common.model.connector.ActionDefinition;
import org.activiti.runtime.api.connector.ConnectorActionDefinitionFinder;
import org.activiti.spring.process.ProcessExtensionService;
import org.activiti.spring.process.model.Extension;
import org.activiti.spring.process.model.ProcessExtensionModel;
import org.activiti.spring.process.model.ProcessVariablesMapping;
import org.activiti.spring.process.model.VariableDefinition;

public class OutboundVariablesProvider {
    private ProcessExtensionService processExtensionService;
    private ConnectorActionDefinitionFinder connectorActionDefinitionFinder;

    public OutboundVariablesProvider(ProcessExtensionService processExtensionService, ConnectorActionDefinitionFinder connectorActionDefinitionFinder) {
        this.processExtensionService = processExtensionService;
        this.connectorActionDefinitionFinder = connectorActionDefinitionFinder;
    }

    public Map<String, Object> calculateVariables(IntegrationContext integrationContext, ActionDefinition actionDefinition) {
        Map outboundVariables = integrationContext.getOutBoundVariables();
        if (actionDefinition == null || !this.processExtensionService.hasExtensionsFor(integrationContext.getProcessDefinitionKey())) {
            return outboundVariables;
        }
        HashMap<String, Object> mappedOutboundVariables = new HashMap<String, Object>();
        ProcessExtensionModel extensionsModel = this.processExtensionService.getExtensionsForId(integrationContext.getProcessDefinitionId());
        Extension extensions = extensionsModel.getExtensions();
        ProcessVariablesMapping processVariablesMapping = extensions.getMappingForFlowElement(integrationContext.getClientId());
        processVariablesMapping.getOutputs().forEach((varUUID, mapping) -> {
            org.activiti.core.common.model.connector.VariableDefinition outBoundVariableDefinition = actionDefinition.getOutputs().stream().filter(variableDefinition -> variableDefinition.getId().equals(mapping.getValue())).findFirst().orElse(null);
            VariableDefinition processVariableDefinition = extensions.getProperty(varUUID);
            if (outBoundVariableDefinition != null && processVariableDefinition != null) {
                mappedOutboundVariables.put(processVariableDefinition.getName(), outboundVariables.remove(outBoundVariableDefinition.getName()));
            }
        });
        outboundVariables.forEach((key, value) -> extensions.getProperties().values().stream().filter(matchingDefinition -> matchingDefinition.getName().equals(key)).findFirst().map(variableDefinition -> mappedOutboundVariables.put((String)key, value)));
        return mappedOutboundVariables;
    }

    public Map<String, Object> calculateVariables(IntegrationContext integrationContext) {
        Optional<ActionDefinition> actionDefinitionOptional = this.connectorActionDefinitionFinder.find(integrationContext.getConnectorType());
        return this.calculateVariables(integrationContext, actionDefinitionOptional.orElse(null));
    }
}

