/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.api.runtime.shared.NotFoundException;
import org.activiti.api.runtime.shared.identity.UserGroupManager;
import org.activiti.api.runtime.shared.query.Page;
import org.activiti.api.runtime.shared.query.Pageable;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.builders.TaskPayloadBuilder;
import org.activiti.api.task.model.impl.TaskImpl;
import org.activiti.api.task.model.payloads.CandidateGroupsPayload;
import org.activiti.api.task.model.payloads.CandidateUsersPayload;
import org.activiti.api.task.model.payloads.ClaimTaskPayload;
import org.activiti.api.task.model.payloads.CompleteTaskPayload;
import org.activiti.api.task.model.payloads.CreateTaskPayload;
import org.activiti.api.task.model.payloads.CreateTaskVariablePayload;
import org.activiti.api.task.model.payloads.DeleteTaskPayload;
import org.activiti.api.task.model.payloads.GetTaskVariablesPayload;
import org.activiti.api.task.model.payloads.GetTasksPayload;
import org.activiti.api.task.model.payloads.ReleaseTaskPayload;
import org.activiti.api.task.model.payloads.UpdateTaskPayload;
import org.activiti.api.task.model.payloads.UpdateTaskVariablePayload;
import org.activiti.api.task.runtime.TaskRuntime;
import org.activiti.api.task.runtime.conf.TaskRuntimeConfiguration;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.runtime.api.impl.TaskRuntimeHelper;
import org.activiti.runtime.api.model.impl.APITaskConverter;
import org.activiti.runtime.api.model.impl.APIVariableInstanceConverter;
import org.activiti.runtime.api.query.impl.PageImpl;
import org.springframework.security.access.prepost.PreAuthorize;

@PreAuthorize(value="hasRole('ACTIVITI_USER')")
public class TaskRuntimeImpl
implements TaskRuntime {
    private final TaskService taskService;
    private final APITaskConverter taskConverter;
    private final APIVariableInstanceConverter variableInstanceConverter;
    private final TaskRuntimeConfiguration configuration;
    private final UserGroupManager userGroupManager;
    private final SecurityManager securityManager;
    private final TaskRuntimeHelper taskRuntimeHelper;

    public TaskRuntimeImpl(TaskService taskService, UserGroupManager userGroupManager, SecurityManager securityManager, APITaskConverter taskConverter, APIVariableInstanceConverter variableInstanceConverter, TaskRuntimeConfiguration configuration, TaskRuntimeHelper taskRuntimeHelper) {
        this.taskService = taskService;
        this.userGroupManager = userGroupManager;
        this.securityManager = securityManager;
        this.taskConverter = taskConverter;
        this.variableInstanceConverter = variableInstanceConverter;
        this.configuration = configuration;
        this.taskRuntimeHelper = taskRuntimeHelper;
    }

    public TaskRuntimeConfiguration configuration() {
        return this.configuration;
    }

    public org.activiti.api.task.model.Task task(String taskId) {
        return this.taskConverter.from(this.taskRuntimeHelper.getInternalTaskWithChecks(taskId));
    }

    public Page<org.activiti.api.task.model.Task> tasks(Pageable pageable) {
        String authenticatedUserId = this.securityManager.getAuthenticatedUserId();
        if (authenticatedUserId != null && !authenticatedUserId.isEmpty()) {
            List userGroups = this.userGroupManager.getUserGroups(authenticatedUserId);
            return this.tasks(pageable, TaskPayloadBuilder.tasks().withAssignee(authenticatedUserId).withGroups(userGroups).build());
        }
        throw new IllegalStateException("You need an authenticated user to perform a task query");
    }

    public Page<org.activiti.api.task.model.Task> tasks(Pageable pageable, GetTasksPayload getTasksPayload) {
        String authenticatedUserId;
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        if (getTasksPayload == null) {
            getTasksPayload = TaskPayloadBuilder.tasks().build();
        }
        if ((authenticatedUserId = this.securityManager.getAuthenticatedUserId()) == null || authenticatedUserId.isEmpty()) {
            throw new IllegalStateException("You need an authenticated user to perform a task query");
        }
        List userGroups = this.userGroupManager.getUserGroups(authenticatedUserId);
        getTasksPayload.setAssigneeId(authenticatedUserId);
        getTasksPayload.setGroups(userGroups);
        taskQuery = (TaskQuery)((TaskQuery)((TaskQuery)taskQuery.or()).taskCandidateOrAssigned(getTasksPayload.getAssigneeId(), getTasksPayload.getGroups()).taskOwner(authenticatedUserId)).endOr();
        if (getTasksPayload.getProcessInstanceId() != null) {
            taskQuery = (TaskQuery)taskQuery.processInstanceId(getTasksPayload.getProcessInstanceId());
        }
        if (getTasksPayload.getParentTaskId() != null) {
            taskQuery = (TaskQuery)taskQuery.taskParentTaskId(getTasksPayload.getParentTaskId());
        }
        List tasks = this.taskConverter.from(taskQuery.listPage(pageable.getStartIndex(), pageable.getMaxItems()));
        return new PageImpl(tasks, Math.toIntExact(taskQuery.count()));
    }

    public org.activiti.api.task.model.Task complete(CompleteTaskPayload completeTaskPayload) {
        org.activiti.api.task.model.Task task;
        String authenticatedUserId = this.securityManager.getAuthenticatedUserId();
        try {
            task = this.task(completeTaskPayload.getTaskId());
        }
        catch (IllegalStateException ex) {
            throw new IllegalStateException("The authenticated user cannot complete task" + completeTaskPayload.getTaskId() + " due he/she cannot access to the task");
        }
        if (task.getAssignee() == null || task.getAssignee().isEmpty()) {
            throw new IllegalStateException("The task needs to be claimed before trying to complete it");
        }
        if (!task.getAssignee().equals(authenticatedUserId)) {
            throw new IllegalStateException("You cannot complete the task if you are not assigned to it");
        }
        TaskImpl competedTaskData = new TaskImpl(task.getId(), task.getName(), Task.TaskStatus.COMPLETED);
        this.taskService.complete(completeTaskPayload.getTaskId(), completeTaskPayload.getVariables(), true);
        return competedTaskData;
    }

    public org.activiti.api.task.model.Task claim(ClaimTaskPayload claimTaskPayload) {
        org.activiti.api.task.model.Task task;
        try {
            task = this.task(claimTaskPayload.getTaskId());
        }
        catch (IllegalStateException ex) {
            throw new IllegalStateException("The authenticated user cannot claim task" + claimTaskPayload.getTaskId() + " due it is not a candidate for it");
        }
        if (task.getAssignee() != null && !task.getAssignee().isEmpty()) {
            throw new IllegalStateException("The task was already claimed, the assignee of this task needs to release it first for you to claim it");
        }
        String authenticatedUserId = this.securityManager.getAuthenticatedUserId();
        claimTaskPayload.setAssignee(authenticatedUserId);
        this.taskService.claim(claimTaskPayload.getTaskId(), claimTaskPayload.getAssignee());
        return this.task(claimTaskPayload.getTaskId());
    }

    public org.activiti.api.task.model.Task release(ReleaseTaskPayload releaseTaskPayload) {
        org.activiti.api.task.model.Task task;
        try {
            task = this.task(releaseTaskPayload.getTaskId());
        }
        catch (IllegalStateException ex) {
            throw new IllegalStateException("The authenticated user cannot claim task" + releaseTaskPayload.getTaskId() + " due it is not a candidate for it");
        }
        if (task.getAssignee() == null || task.getAssignee().isEmpty()) {
            throw new IllegalStateException("You cannot release a task that is not claimed");
        }
        String authenticatedUserId = this.securityManager.getAuthenticatedUserId();
        if (!task.getAssignee().equals(authenticatedUserId)) {
            throw new IllegalStateException("You cannot release a task where you are not the assignee");
        }
        this.taskService.unclaim(releaseTaskPayload.getTaskId());
        return this.task(releaseTaskPayload.getTaskId());
    }

    public org.activiti.api.task.model.Task update(UpdateTaskPayload updateTaskPayload) {
        return this.taskRuntimeHelper.applyUpdateTaskPayload(false, updateTaskPayload);
    }

    public org.activiti.api.task.model.Task delete(DeleteTaskPayload deleteTaskPayload) {
        org.activiti.api.task.model.Task task;
        try {
            task = this.task(deleteTaskPayload.getTaskId());
        }
        catch (IllegalStateException ex) {
            throw new IllegalStateException("The authenticated user cannot delete the task" + deleteTaskPayload.getTaskId() + " due it is not the current assignee");
        }
        String authenticatedUserId = this.securityManager.getAuthenticatedUserId();
        if (!(task.getAssignee() != null && !task.getAssignee().isEmpty() && task.getAssignee().equals(authenticatedUserId) || task.getOwner() != null && !task.getOwner().isEmpty() && task.getOwner().equals(authenticatedUserId))) {
            throw new IllegalStateException("You cannot delete a task where you are not the assignee/owner");
        }
        TaskImpl deletedTaskData = new TaskImpl(task.getId(), task.getName(), Task.TaskStatus.DELETED);
        if (!deleteTaskPayload.hasReason()) {
            deleteTaskPayload.setReason("Cancelled by " + authenticatedUserId);
        }
        this.taskService.deleteTask(deleteTaskPayload.getTaskId(), deleteTaskPayload.getReason(), true);
        return deletedTaskData;
    }

    public org.activiti.api.task.model.Task create(CreateTaskPayload createTaskPayload) {
        if (createTaskPayload.getName() == null || createTaskPayload.getName().isEmpty()) {
            throw new IllegalStateException("You cannot create a task without name");
        }
        Task task = this.taskService.newTask();
        task.setName(createTaskPayload.getName());
        task.setDescription(createTaskPayload.getDescription());
        task.setDueDate(createTaskPayload.getDueDate());
        task.setPriority(createTaskPayload.getPriority());
        if (createTaskPayload.getAssignee() != null && !createTaskPayload.getAssignee().isEmpty()) {
            task.setAssignee(createTaskPayload.getAssignee());
        }
        task.setParentTaskId(createTaskPayload.getParentTaskId());
        task.setFormKey(createTaskPayload.getFormKey());
        task.setOwner(this.securityManager.getAuthenticatedUserId());
        this.taskService.saveTask(task);
        this.taskService.addCandidateUser(task.getId(), this.securityManager.getAuthenticatedUserId());
        if (createTaskPayload.getCandidateGroups() != null && !createTaskPayload.getCandidateGroups().isEmpty()) {
            for (String g : createTaskPayload.getCandidateGroups()) {
                this.taskService.addCandidateGroup(task.getId(), g);
            }
        }
        if (createTaskPayload.getCandidateUsers() != null && !createTaskPayload.getCandidateUsers().isEmpty()) {
            for (String u : createTaskPayload.getCandidateUsers()) {
                this.taskService.addCandidateUser(task.getId(), u);
            }
        }
        return this.taskConverter.from(task);
    }

    public void addCandidateUsers(CandidateUsersPayload candidateUsersPayload) {
        Task internalTask;
        try {
            internalTask = this.taskRuntimeHelper.getInternalTaskWithChecks(candidateUsersPayload.getTaskId());
        }
        catch (IllegalStateException ex) {
            throw new IllegalStateException("The authenticated user cannot update the task" + candidateUsersPayload.getTaskId() + " due it is not the current assignee");
        }
        String authenticatedUserId = this.securityManager.getAuthenticatedUserId();
        if (!Objects.equals(internalTask.getAssignee(), authenticatedUserId)) {
            throw new IllegalStateException("You cannot update a task where you are not the assignee");
        }
        if (candidateUsersPayload.getCandidateUsers() != null && !candidateUsersPayload.getCandidateUsers().isEmpty()) {
            for (String u : candidateUsersPayload.getCandidateUsers()) {
                this.taskService.addCandidateUser(internalTask.getId(), u);
            }
        }
    }

    public void deleteCandidateUsers(CandidateUsersPayload candidateUsersPayload) {
        Task internalTask;
        try {
            internalTask = this.taskRuntimeHelper.getInternalTaskWithChecks(candidateUsersPayload.getTaskId());
        }
        catch (IllegalStateException ex) {
            throw new IllegalStateException("The authenticated user cannot update the task" + candidateUsersPayload.getTaskId() + " due it is not the current assignee");
        }
        String authenticatedUserId = this.securityManager.getAuthenticatedUserId();
        if (!Objects.equals(internalTask.getAssignee(), authenticatedUserId)) {
            throw new IllegalStateException("You cannot update a task where you are not the assignee");
        }
        if (candidateUsersPayload.getCandidateUsers() != null && !candidateUsersPayload.getCandidateUsers().isEmpty()) {
            for (String u : candidateUsersPayload.getCandidateUsers()) {
                this.taskService.deleteCandidateUser(internalTask.getId(), u);
            }
        }
    }

    public void addCandidateGroups(CandidateGroupsPayload candidateGroupsPayload) {
        Task internalTask;
        try {
            internalTask = this.taskRuntimeHelper.getInternalTaskWithChecks(candidateGroupsPayload.getTaskId());
        }
        catch (IllegalStateException ex) {
            throw new IllegalStateException("The authenticated user cannot update the task" + candidateGroupsPayload.getTaskId() + " due it is not the current assignee");
        }
        String authenticatedUserId = this.securityManager.getAuthenticatedUserId();
        if (!Objects.equals(internalTask.getAssignee(), authenticatedUserId)) {
            throw new IllegalStateException("You cannot update a task where you are not the assignee");
        }
        if (candidateGroupsPayload.getCandidateGroups() != null && !candidateGroupsPayload.getCandidateGroups().isEmpty()) {
            for (String g : candidateGroupsPayload.getCandidateGroups()) {
                this.taskService.addCandidateGroup(internalTask.getId(), g);
            }
        }
    }

    public void deleteCandidateGroups(CandidateGroupsPayload candidateGroupsPayload) {
        Task internalTask;
        try {
            internalTask = this.taskRuntimeHelper.getInternalTaskWithChecks(candidateGroupsPayload.getTaskId());
        }
        catch (IllegalStateException ex) {
            throw new IllegalStateException("The authenticated user cannot update the task" + candidateGroupsPayload.getTaskId() + " due it is not the current assignee");
        }
        String authenticatedUserId = this.securityManager.getAuthenticatedUserId();
        if (!Objects.equals(internalTask.getAssignee(), authenticatedUserId)) {
            throw new IllegalStateException("You cannot update a task where you are not the assignee");
        }
        if (candidateGroupsPayload.getCandidateGroups() != null && !candidateGroupsPayload.getCandidateGroups().isEmpty()) {
            for (String g : candidateGroupsPayload.getCandidateGroups()) {
                this.taskService.deleteCandidateGroup(internalTask.getId(), g);
            }
        }
    }

    public List<String> userCandidates(String taskId) {
        List<IdentityLink> identityLinks = this.getIdentityLinks(taskId);
        ArrayList<String> userCandidates = new ArrayList<String>();
        if (identityLinks != null) {
            for (IdentityLink i : identityLinks) {
                if (i.getUserId() == null || !i.getType().equals("candidate")) continue;
                userCandidates.add(i.getUserId());
            }
        }
        return userCandidates;
    }

    public List<String> groupCandidates(String taskId) {
        List<IdentityLink> identityLinks = this.getIdentityLinks(taskId);
        ArrayList<String> groupCandidates = new ArrayList<String>();
        if (identityLinks != null) {
            for (IdentityLink i : identityLinks) {
                if (i.getGroupId() == null || !i.getType().equals("candidate")) continue;
                groupCandidates.add(i.getGroupId());
            }
        }
        return groupCandidates;
    }

    public List<VariableInstance> variables(GetTaskVariablesPayload getTaskVariablesPayload) {
        this.taskRuntimeHelper.assertHasAccessToTask(getTaskVariablesPayload.getTaskId());
        return this.variableInstanceConverter.from(this.taskRuntimeHelper.getInternalTaskVariables(getTaskVariablesPayload.getTaskId()).values());
    }

    public void createVariable(CreateTaskVariablePayload createTaskVariablePayload) {
        this.taskRuntimeHelper.createVariable(false, createTaskVariablePayload);
    }

    public void updateVariable(UpdateTaskVariablePayload updateTaskVariablePayload) {
        this.taskRuntimeHelper.updateVariable(false, updateTaskVariablePayload);
    }

    private List<IdentityLink> getIdentityLinks(String taskId) {
        String authenticatedUserId = this.securityManager.getAuthenticatedUserId();
        if (authenticatedUserId != null && !authenticatedUserId.isEmpty()) {
            List userRoles = this.userGroupManager.getUserRoles(authenticatedUserId);
            List userGroups = this.userGroupManager.getUserGroups(authenticatedUserId);
            Task internalTask = (Task)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(authenticatedUserId, userGroups).taskId(taskId)).singleResult();
            if (internalTask == null) {
                throw new NotFoundException("Unable to find task for the given id: " + taskId + " for user: " + authenticatedUserId + " (with groups: " + userGroups + " & with roles: " + userRoles + ")");
            }
            return this.taskService.getIdentityLinksForTask(taskId);
        }
        throw new IllegalStateException("There is no authenticated user, we need a user authenticated to find tasks");
    }
}

