/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import java.util.ArrayList;
import java.util.List;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.api.runtime.shared.query.Page;
import org.activiti.api.runtime.shared.query.Pageable;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.builders.TaskPayloadBuilder;
import org.activiti.api.task.model.impl.TaskImpl;
import org.activiti.api.task.model.payloads.AssignTaskPayload;
import org.activiti.api.task.model.payloads.CandidateGroupsPayload;
import org.activiti.api.task.model.payloads.CandidateUsersPayload;
import org.activiti.api.task.model.payloads.ClaimTaskPayload;
import org.activiti.api.task.model.payloads.CompleteTaskPayload;
import org.activiti.api.task.model.payloads.CreateTaskVariablePayload;
import org.activiti.api.task.model.payloads.DeleteTaskPayload;
import org.activiti.api.task.model.payloads.GetTaskVariablesPayload;
import org.activiti.api.task.model.payloads.GetTasksPayload;
import org.activiti.api.task.model.payloads.ReleaseTaskPayload;
import org.activiti.api.task.model.payloads.UpdateTaskPayload;
import org.activiti.api.task.model.payloads.UpdateTaskVariablePayload;
import org.activiti.api.task.runtime.TaskAdminRuntime;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskQuery;
import org.activiti.runtime.api.impl.TaskRuntimeHelper;
import org.activiti.runtime.api.model.impl.APITaskConverter;
import org.activiti.runtime.api.model.impl.APIVariableInstanceConverter;
import org.activiti.runtime.api.query.impl.PageImpl;
import org.springframework.security.access.prepost.PreAuthorize;

@PreAuthorize(value="hasRole('ACTIVITI_ADMIN')")
public class TaskAdminRuntimeImpl
implements TaskAdminRuntime {
    private final TaskService taskService;
    private final APITaskConverter taskConverter;
    private final APIVariableInstanceConverter variableInstanceConverter;
    private final TaskRuntimeHelper taskRuntimeHelper;
    private final SecurityManager securityManager;

    public TaskAdminRuntimeImpl(TaskService taskService, APITaskConverter taskConverter, APIVariableInstanceConverter variableInstanceConverter, TaskRuntimeHelper taskRuntimeHelper, SecurityManager securityManager) {
        this.taskService = taskService;
        this.taskConverter = taskConverter;
        this.variableInstanceConverter = variableInstanceConverter;
        this.taskRuntimeHelper = taskRuntimeHelper;
        this.securityManager = securityManager;
    }

    public Task task(String taskId) {
        return this.taskConverter.from(this.taskRuntimeHelper.getInternalTask(taskId));
    }

    public Page<Task> tasks(Pageable pageable) {
        return this.tasks(pageable, TaskPayloadBuilder.tasks().build());
    }

    public Page<Task> tasks(Pageable pageable, GetTasksPayload getTasksPayload) {
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        if (getTasksPayload.getProcessInstanceId() != null) {
            taskQuery = (TaskQuery)taskQuery.processInstanceId(getTasksPayload.getProcessInstanceId());
        }
        if (getTasksPayload.getParentTaskId() != null) {
            taskQuery = (TaskQuery)taskQuery.taskParentTaskId(getTasksPayload.getParentTaskId());
        }
        List tasks = this.taskConverter.from(taskQuery.listPage(pageable.getStartIndex(), pageable.getMaxItems()));
        return new PageImpl(tasks, Math.toIntExact(taskQuery.count()));
    }

    public Task update(UpdateTaskPayload updateTaskPayload) {
        return this.taskRuntimeHelper.applyUpdateTaskPayload(true, updateTaskPayload);
    }

    public Task delete(DeleteTaskPayload deleteTaskPayload) {
        Task task = this.task(deleteTaskPayload.getTaskId());
        TaskImpl deletedTaskData = new TaskImpl(task.getId(), task.getName(), Task.TaskStatus.CANCELLED);
        String authenticatedUserId = this.securityManager.getAuthenticatedUserId();
        if (!deleteTaskPayload.hasReason()) {
            deleteTaskPayload.setReason("Task deleted by " + authenticatedUserId);
        }
        this.taskService.deleteTask(deleteTaskPayload.getTaskId(), deleteTaskPayload.getReason(), true);
        return deletedTaskData;
    }

    public List<VariableInstance> variables(GetTaskVariablesPayload getTaskVariablesPayload) {
        return this.variableInstanceConverter.from(this.taskRuntimeHelper.getInternalTaskVariables(getTaskVariablesPayload.getTaskId()).values());
    }

    public void createVariable(CreateTaskVariablePayload createTaskVariablePayload) {
        this.taskRuntimeHelper.createVariable(true, createTaskVariablePayload);
    }

    public void updateVariable(UpdateTaskVariablePayload updateTaskVariablePayload) {
        this.taskRuntimeHelper.updateVariable(true, updateTaskVariablePayload);
    }

    public Task complete(CompleteTaskPayload completeTaskPayload) {
        Task task = this.task(completeTaskPayload.getTaskId());
        if (task == null) {
            throw new IllegalStateException("Task with id: " + completeTaskPayload.getTaskId() + " cannot be completed because it cannot be found.");
        }
        TaskImpl competedTaskData = new TaskImpl(task.getId(), task.getName(), Task.TaskStatus.COMPLETED);
        this.taskService.complete(completeTaskPayload.getTaskId(), completeTaskPayload.getVariables(), true);
        return competedTaskData;
    }

    public Task claim(ClaimTaskPayload claimTaskPayload) {
        this.taskService.claim(claimTaskPayload.getTaskId(), claimTaskPayload.getAssignee());
        return this.task(claimTaskPayload.getTaskId());
    }

    public Task release(ReleaseTaskPayload releaseTaskPayload) {
        this.taskService.unclaim(releaseTaskPayload.getTaskId());
        return this.task(releaseTaskPayload.getTaskId());
    }

    public Task assign(AssignTaskPayload assignTaskPayload) {
        this.taskService.unclaim(assignTaskPayload.getTaskId());
        this.taskService.claim(assignTaskPayload.getTaskId(), assignTaskPayload.getAssignee());
        return this.task(assignTaskPayload.getTaskId());
    }

    public void addCandidateUsers(CandidateUsersPayload candidateUsersPayload) {
        if (candidateUsersPayload.getCandidateUsers() != null && !candidateUsersPayload.getCandidateUsers().isEmpty()) {
            for (String u : candidateUsersPayload.getCandidateUsers()) {
                this.taskService.addCandidateUser(candidateUsersPayload.getTaskId(), u);
            }
        }
    }

    public void deleteCandidateUsers(CandidateUsersPayload candidateUsersPayload) {
        if (candidateUsersPayload.getCandidateUsers() != null && !candidateUsersPayload.getCandidateUsers().isEmpty()) {
            for (String u : candidateUsersPayload.getCandidateUsers()) {
                this.taskService.deleteCandidateUser(candidateUsersPayload.getTaskId(), u);
            }
        }
    }

    public void addCandidateGroups(CandidateGroupsPayload candidateGroupsPayload) {
        if (candidateGroupsPayload.getCandidateGroups() != null && !candidateGroupsPayload.getCandidateGroups().isEmpty()) {
            for (String g : candidateGroupsPayload.getCandidateGroups()) {
                this.taskService.addCandidateGroup(candidateGroupsPayload.getTaskId(), g);
            }
        }
    }

    public void deleteCandidateGroups(CandidateGroupsPayload candidateGroupsPayload) {
        if (candidateGroupsPayload.getCandidateGroups() != null && !candidateGroupsPayload.getCandidateGroups().isEmpty()) {
            for (String g : candidateGroupsPayload.getCandidateGroups()) {
                this.taskService.deleteCandidateGroup(candidateGroupsPayload.getTaskId(), g);
            }
        }
    }

    public List<String> userCandidates(String taskId) {
        List<IdentityLink> identityLinks = this.getIdentityLinks(taskId);
        ArrayList<String> userCandidates = new ArrayList<String>();
        if (identityLinks != null) {
            for (IdentityLink i : identityLinks) {
                if (i.getUserId() == null || !i.getType().equals("candidate")) continue;
                userCandidates.add(i.getUserId());
            }
        }
        return userCandidates;
    }

    public List<String> groupCandidates(String taskId) {
        List<IdentityLink> identityLinks = this.getIdentityLinks(taskId);
        ArrayList<String> groupCandidates = new ArrayList<String>();
        if (identityLinks != null) {
            for (IdentityLink i : identityLinks) {
                if (i.getGroupId() == null || !i.getType().equals("candidate")) continue;
                groupCandidates.add(i.getGroupId());
            }
        }
        return groupCandidates;
    }

    private List<IdentityLink> getIdentityLinks(String taskId) {
        return this.taskService.getIdentityLinksForTask(taskId);
    }
}

