/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.conf;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.activiti.dmn.engine.DmnEngineConfiguration;
import org.activiti.dmn.engine.configurator.DmnEngineConfigurator;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.cfg.ProcessEngineConfigurator;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.asyncexecutor.DefaultAsyncJobExecutor;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.runtime.Clock;
import org.activiti.form.api.FormRepositoryService;
import org.activiti.form.engine.FormEngineConfiguration;
import org.activiti.form.engine.configurator.FormEngineConfigurator;
import org.activiti.spring.ProcessEngineFactoryBean;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ComponentScan(basePackages={"org.activiti.app.runtime.activiti", "org.activiti.app.extension.conf", "org.activiti.app.extension.bean"})
public class ActivitiEngineConfiguration {
    private final Logger logger = LoggerFactory.getLogger(ActivitiEngineConfiguration.class);
    @Inject
    private DataSource dataSource;
    @Inject
    private PlatformTransactionManager transactionManager;
    @Inject
    private Environment environment;

    @Bean(name={"processEngine"})
    public ProcessEngineFactoryBean processEngineFactoryBean() {
        ProcessEngineFactoryBean factoryBean = new ProcessEngineFactoryBean();
        factoryBean.setProcessEngineConfiguration(this.processEngineConfiguration());
        return factoryBean;
    }

    public ProcessEngine processEngine() {
        try {
            return this.processEngineFactoryBean().getObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Bean(name={"processEngineConfiguration"})
    public ProcessEngineConfigurationImpl processEngineConfiguration() {
        SpringProcessEngineConfiguration processEngineConfiguration = new SpringProcessEngineConfiguration();
        processEngineConfiguration.setDataSource(this.dataSource);
        processEngineConfiguration.setDatabaseSchemaUpdate("true");
        processEngineConfiguration.setTransactionManager(this.transactionManager);
        processEngineConfiguration.setAsyncExecutorActivate(true);
        processEngineConfiguration.setAsyncExecutor(this.asyncExecutor());
        String emailHost = this.environment.getProperty("email.host");
        if (StringUtils.isNotEmpty((CharSequence)emailHost)) {
            processEngineConfiguration.setMailServerHost(emailHost);
            processEngineConfiguration.setMailServerPort(((Integer)this.environment.getRequiredProperty("email.port", Integer.class)).intValue());
            Boolean useCredentials = (Boolean)this.environment.getProperty("email.useCredentials", Boolean.class);
            if (Boolean.TRUE.equals(useCredentials)) {
                processEngineConfiguration.setMailServerUsername(this.environment.getProperty("email.username"));
                processEngineConfiguration.setMailServerPassword(this.environment.getProperty("email.password"));
            }
        }
        processEngineConfiguration.setProcessDefinitionCacheLimit(((Integer)this.environment.getProperty("activiti.process-definitions.cache.max", Integer.class, (Object)128)).intValue());
        processEngineConfiguration.setEnableSafeBpmnXml(true);
        ArrayList preParseHandlers = new ArrayList();
        processEngineConfiguration.setPreBpmnParseHandlers(preParseHandlers);
        FormEngineConfiguration formEngineConfiguration = new FormEngineConfiguration();
        formEngineConfiguration.setDataSource(this.dataSource);
        FormEngineConfigurator formEngineConfigurator = new FormEngineConfigurator();
        formEngineConfigurator.setFormEngineConfiguration(formEngineConfiguration);
        processEngineConfiguration.addConfigurator((ProcessEngineConfigurator)formEngineConfigurator);
        DmnEngineConfiguration dmnEngineConfiguration = new DmnEngineConfiguration();
        dmnEngineConfiguration.setDataSource(this.dataSource);
        DmnEngineConfigurator dmnEngineConfigurator = new DmnEngineConfigurator();
        dmnEngineConfigurator.setDmnEngineConfiguration(dmnEngineConfiguration);
        processEngineConfiguration.addConfigurator((ProcessEngineConfigurator)dmnEngineConfigurator);
        return processEngineConfiguration;
    }

    @Bean
    public AsyncExecutor asyncExecutor() {
        DefaultAsyncJobExecutor asyncExecutor = new DefaultAsyncJobExecutor();
        asyncExecutor.setDefaultAsyncJobAcquireWaitTimeInMillis(5000);
        asyncExecutor.setDefaultTimerJobAcquireWaitTimeInMillis(5000);
        return asyncExecutor;
    }

    @Bean(name={"clock"})
    @DependsOn(value={"processEngine"})
    public Clock getClock() {
        return this.processEngineConfiguration().getClock();
    }

    @Bean
    public RepositoryService repositoryService() {
        return this.processEngine().getRepositoryService();
    }

    @Bean
    public RuntimeService runtimeService() {
        return this.processEngine().getRuntimeService();
    }

    @Bean
    public TaskService taskService() {
        return this.processEngine().getTaskService();
    }

    @Bean
    public HistoryService historyService() {
        return this.processEngine().getHistoryService();
    }

    @Bean
    public FormService formService() {
        return this.processEngine().getFormService();
    }

    @Bean
    public IdentityService identityService() {
        return this.processEngine().getIdentityService();
    }

    @Bean
    public ManagementService managementService() {
        return this.processEngine().getManagementService();
    }

    @Bean
    public FormRepositoryService formEngineRepositoryService() {
        return this.processEngine().getFormEngineRepositoryService();
    }

    @Bean
    public org.activiti.form.api.FormService formEngineFormService() {
        return this.processEngine().getFormEngineFormService();
    }
}

