/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.conf;

import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class Bootstrapper
implements ApplicationListener<ContextRefreshedEvent> {
    private final Logger log = LoggerFactory.getLogger(Bootstrapper.class);
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private Environment env;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getParent() == null) {
            this.createDefaultAdmin();
        }
    }

    protected void createDefaultAdmin() {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) {
                if (Bootstrapper.this.identityService.createUserQuery().count() == 0L) {
                    Bootstrapper.this.log.info("No users found, initializing default entities");
                    User user = Bootstrapper.this.initializeSuperUser();
                    Bootstrapper.this.initializeSuperUserGroups(user);
                }
                return null;
            }
        });
    }

    protected User initializeSuperUser() {
        String adminPassword = this.env.getRequiredProperty("admin.password");
        String adminLastname = this.env.getRequiredProperty("admin.lastname");
        String adminEmail = this.env.getRequiredProperty("admin.email");
        User admin = this.identityService.newUser(adminEmail);
        admin.setLastName(adminLastname);
        admin.setEmail(adminEmail);
        admin.setPassword(adminPassword);
        this.identityService.saveUser(admin);
        return admin;
    }

    protected void initializeSuperUserGroups(User superUser) {
        String superUserGroupName = this.env.getRequiredProperty("admin.group");
        Group group = this.identityService.newGroup("ROLE_ADMIN");
        group.setName(superUserGroupName);
        group.setType("security-role");
        this.identityService.saveGroup(group);
        this.identityService.createMembership(superUser.getId(), group.getId());
    }
}

