/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.conf;

import java.io.File;
import javax.inject.Inject;
import org.activiti.content.storage.api.ContentStorage;
import org.activiti.content.storage.fs.FileSystemContentStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class ContentStorageConfiguration {
    private final Logger log = LoggerFactory.getLogger(ContentStorageConfiguration.class);
    private static final String PROP_FS_ROOT = "contentstorage.fs.rootFolder";
    private static final String PROP_FS_DEPTH = "contentstorage.fs.depth";
    private static final String PROP_FS_BLOCK_SIZE = "contentstorage.fs.blockSize";
    private static final String PROP_FS_CREATE_ROOT = "contentstorage.fs.createRoot";
    private static final Integer DEFAULT_FS_DEPTH = 4;
    private static final Integer DEFAULT_FS_BLOCK_SIZE = 1024;
    @Inject
    private Environment env;

    @Bean
    public ContentStorage contentStorage() {
        String fsRoot = this.env.getProperty(PROP_FS_ROOT);
        this.log.info("Using file-system based content storage (" + fsRoot + ")");
        Integer iterationDepth = (Integer)this.env.getProperty(PROP_FS_DEPTH, Integer.class, (Object)DEFAULT_FS_DEPTH);
        Integer blockSize = (Integer)this.env.getProperty(PROP_FS_BLOCK_SIZE, Integer.class, (Object)DEFAULT_FS_BLOCK_SIZE);
        File root = new File(fsRoot);
        if (((Boolean)this.env.getProperty(PROP_FS_CREATE_ROOT, Boolean.class, (Object)Boolean.FALSE)).booleanValue() && !root.exists()) {
            this.log.info("Creating content storage root and possible missing parents: " + root.getAbsolutePath());
            root.mkdirs();
        }
        if (root != null && root.exists()) {
            this.log.info("File system root : " + root.getAbsolutePath());
        }
        return new FileSystemContentStorage(root, blockSize.intValue(), iterationDepth.intValue());
    }
}

