/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.conf;

import java.util.Properties;
import javax.inject.Inject;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactoryBean;

@Configuration
public class EmailConfiguration {
    @Inject
    private Environment env;

    @Bean
    public JavaMailSender javaMailSender() {
        Boolean useCredentials;
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        boolean isEmailEnabled = (Boolean)this.env.getProperty("email.enabled", Boolean.class, (Object)false);
        if (isEmailEnabled) {
            sender.setHost(this.env.getRequiredProperty("email.host"));
            sender.setPort(((Integer)this.env.getRequiredProperty("email.port", Integer.class)).intValue());
        }
        if (Boolean.TRUE.equals(useCredentials = (Boolean)this.env.getProperty("email.useCredentials", Boolean.class))) {
            sender.setUsername(this.env.getProperty("email.username"));
            sender.setPassword(this.env.getProperty("email.password"));
        }
        return sender;
    }

    @Bean
    public FreeMarkerConfigurationFactoryBean freeMarkerConfig() {
        Properties props = new Properties();
        props.setProperty("number_format", "0.##");
        props.setProperty("locale", "en-US");
        FreeMarkerConfigurationFactoryBean factory = new FreeMarkerConfigurationFactoryBean();
        factory.setFreemarkerSettings(props);
        factory.setTemplateLoaderPath("classpath:/email-templates/");
        return factory;
    }
}

