/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.conf;

import javax.inject.Inject;
import org.activiti.app.security.AjaxAuthenticationFailureHandler;
import org.activiti.app.security.AjaxAuthenticationSuccessHandler;
import org.activiti.app.security.AjaxLogoutSuccessHandler;
import org.activiti.app.security.CustomDaoAuthenticationProvider;
import org.activiti.app.security.CustomPersistentRememberMeServices;
import org.activiti.app.security.Http401UnauthorizedEntryPoint;
import org.activiti.app.web.CustomFormLoginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.RememberMeAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.XXssProtectionHeaderWriter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, jsr250Enabled=true)
public class SecurityConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SecurityConfiguration.class);
    public static final String KEY_LDAP_ENABLED = "ldap.authentication.enabled";
    @Autowired
    private Environment env;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) {
        try {
            auth.authenticationProvider(this.dbAuthenticationProvider());
        }
        catch (Exception e) {
            logger.error("Could not configure authentication mechanism:", (Throwable)e);
        }
    }

    @Bean
    public UserDetailsService userDetailsService() {
        org.activiti.app.security.UserDetailsService userDetailsService = new org.activiti.app.security.UserDetailsService();
        userDetailsService.setUserValidityPeriod((Long)this.env.getProperty("cache.users.recheck.period", Long.class, (Object)30000L));
        return userDetailsService;
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return NoOpPasswordEncoder.getInstance();
    }

    @Bean(name={"dbAuthenticationProvider"})
    public AuthenticationProvider dbAuthenticationProvider() {
        CustomDaoAuthenticationProvider daoAuthenticationProvider = new CustomDaoAuthenticationProvider();
        daoAuthenticationProvider.setUserDetailsService(this.userDetailsService());
        daoAuthenticationProvider.setPasswordEncoder(this.passwordEncoder());
        return daoAuthenticationProvider;
    }

    public static class LdapAuthenticationEnabledCondition
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return (Boolean)context.getEnvironment().getProperty(SecurityConfiguration.KEY_LDAP_ENABLED, Boolean.class, (Object)false);
        }
    }

    @Configuration
    @Order(value=1)
    public static class ApiWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable()).antMatcher("/api/**").authorizeRequests().antMatchers(new String[]{"/api/**"})).authenticated().and()).httpBasic();
        }
    }

    @Configuration
    @Order(value=10)
    public static class FormLoginWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        private static final Logger logger = LoggerFactory.getLogger(FormLoginWebSecurityConfigurerAdapter.class);
        @Inject
        private Environment env;
        @Inject
        private AjaxAuthenticationSuccessHandler ajaxAuthenticationSuccessHandler;
        @Inject
        private AjaxAuthenticationFailureHandler ajaxAuthenticationFailureHandler;
        @Inject
        private AjaxLogoutSuccessHandler ajaxLogoutSuccessHandler;
        @Inject
        private Http401UnauthorizedEntryPoint authenticationEntryPoint;

        protected void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).rememberMe().rememberMeServices(this.rememberMeServices()).key(this.env.getProperty("security.rememberme.key")).and()).logout().logoutUrl("/app/logout").logoutSuccessHandler((LogoutSuccessHandler)this.ajaxLogoutSuccessHandler).deleteCookies(new String[]{"JSESSIONID"}).permitAll().and()).csrf().disable()).headers().frameOptions().sameOrigin().addHeaderWriter((HeaderWriter)new XXssProtectionHeaderWriter()).and()).authorizeRequests().antMatchers(new String[]{"/*"})).permitAll().antMatchers(new String[]{"/app/rest/authenticate"})).permitAll().antMatchers(new String[]{"/app/rest/integration/login"})).permitAll().antMatchers(new String[]{"/app/rest/temporary/example-options"})).permitAll().antMatchers(new String[]{"/app/rest/idm/email-actions/*"})).permitAll().antMatchers(new String[]{"/app/rest/idm/signups"})).permitAll().antMatchers(new String[]{"/app/rest/idm/passwords"})).permitAll().antMatchers(new String[]{"/app/**"})).authenticated();
            CustomFormLoginConfig loginConfig = new CustomFormLoginConfig();
            ((CustomFormLoginConfig)((CustomFormLoginConfig)((CustomFormLoginConfig)loginConfig.loginProcessingUrl("/app/authentication")).successHandler((AuthenticationSuccessHandler)this.ajaxAuthenticationSuccessHandler)).failureHandler((AuthenticationFailureHandler)this.ajaxAuthenticationFailureHandler)).usernameParameter("j_username").passwordParameter("j_password").permitAll();
            http.apply(loginConfig);
        }

        @Bean
        public RememberMeServices rememberMeServices() {
            return new CustomPersistentRememberMeServices(this.env, this.userDetailsService());
        }

        @Bean
        public RememberMeAuthenticationProvider rememberMeAuthenticationProvider() {
            return new RememberMeAuthenticationProvider(this.env.getProperty("security.rememberme.key"));
        }
    }
}

