/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.servlet;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import org.activiti.app.conf.ApplicationConfiguration;
import org.activiti.app.servlet.ApiDispatcherServletConfiguration;
import org.activiti.app.servlet.AppDispatcherServletConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.servlet.DispatcherServlet;

public class WebConfigurer
implements ServletContextListener {
    private final Logger log = LoggerFactory.getLogger(WebConfigurer.class);
    public AnnotationConfigWebApplicationContext context;

    public void setContext(AnnotationConfigWebApplicationContext context) {
        this.context = context;
    }

    public void contextInitialized(ServletContextEvent sce) {
        this.log.debug("Configuring Spring root application context");
        ServletContext servletContext = sce.getServletContext();
        AnnotationConfigWebApplicationContext rootContext = null;
        if (this.context == null) {
            rootContext = new AnnotationConfigWebApplicationContext();
            rootContext.register(new Class[]{ApplicationConfiguration.class});
            if (rootContext.getServletContext() == null) {
                rootContext.setServletContext(servletContext);
            }
            rootContext.refresh();
            this.context = rootContext;
        } else {
            rootContext = this.context;
            if (rootContext.getServletContext() == null) {
                rootContext.setServletContext(servletContext);
            }
        }
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)rootContext);
        EnumSet<DispatcherType> disps = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC);
        this.initSpring(servletContext, rootContext);
        this.initSpringSecurity(servletContext, disps);
        this.log.debug("Web application fully configured");
    }

    private void initSpring(ServletContext servletContext, AnnotationConfigWebApplicationContext rootContext) {
        this.log.debug("Configuring Spring Web application context");
        AnnotationConfigWebApplicationContext appDispatcherServletConfiguration = new AnnotationConfigWebApplicationContext();
        appDispatcherServletConfiguration.setParent((ApplicationContext)rootContext);
        appDispatcherServletConfiguration.register(new Class[]{AppDispatcherServletConfiguration.class});
        this.log.debug("Registering Spring MVC Servlet");
        ServletRegistration.Dynamic appDispatcherServlet = servletContext.addServlet("appDispatcher", (Servlet)new DispatcherServlet((WebApplicationContext)appDispatcherServletConfiguration));
        appDispatcherServlet.addMapping(new String[]{"/app/*"});
        appDispatcherServlet.setLoadOnStartup(1);
        appDispatcherServlet.setAsyncSupported(true);
        this.log.debug("Registering Activiti public REST API");
        AnnotationConfigWebApplicationContext apiDispatcherServletConfiguration = new AnnotationConfigWebApplicationContext();
        apiDispatcherServletConfiguration.setParent((ApplicationContext)rootContext);
        apiDispatcherServletConfiguration.register(new Class[]{ApiDispatcherServletConfiguration.class});
        ServletRegistration.Dynamic apiDispatcherServlet = servletContext.addServlet("apiDispatcher", (Servlet)new DispatcherServlet((WebApplicationContext)apiDispatcherServletConfiguration));
        apiDispatcherServlet.addMapping(new String[]{"/api/*"});
        apiDispatcherServlet.setLoadOnStartup(1);
        apiDispatcherServlet.setAsyncSupported(true);
    }

    private void initSpringSecurity(ServletContext servletContext, EnumSet<DispatcherType> disps) {
        this.log.debug("Registering Spring Security Filter");
        FilterRegistration.Dynamic springSecurityFilter = servletContext.addFilter("springSecurityFilterChain", (Filter)new DelegatingFilterProxy());
        springSecurityFilter.addMappingForUrlPatterns(disps, false, new String[]{"/*"});
        springSecurityFilter.setAsyncSupported(true);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.log.info("Destroying Web application");
        WebApplicationContext ac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sce.getServletContext());
        AnnotationConfigWebApplicationContext gwac = (AnnotationConfigWebApplicationContext)ac;
        gwac.close();
        this.log.debug("Web application destroyed");
    }
}

