/*
 * Decompiled with CFR 0.152.
 */
package com.activiti.domain.idm;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Entity
@Table(name="ACT_IDM_PERSISTENT_TOKEN")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PersistentToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"d MMMM yyyy");
    @Id
    private String series;
    @JsonIgnore
    @NotNull
    @Column(name="token_value")
    private String tokenValue;
    @JsonIgnore
    @Column(name="token_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date tokenDate;
    @Size(min=0, max=39)
    @Column(name="ip_address")
    private String ipAddress;
    @Column(name="user_agent")
    private String userAgent;
    @Column(name="user_id")
    private String user;

    public String getSeries() {
        return this.series;
    }

    public void setSeries(String series) {
        this.series = series;
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public void setTokenValue(String tokenValue) {
        this.tokenValue = tokenValue;
    }

    public Date getTokenDate() {
        return this.tokenDate;
    }

    public void setTokenDate(Date tokenDate) {
        this.tokenDate = tokenDate;
    }

    @JsonGetter
    public String getFormattedTokenDate() {
        return dateTimeFormatter.print((ReadablePartial)new LocalDate((Object)this.tokenDate));
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent.length() >= 255 ? userAgent.substring(0, 254) : userAgent;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentToken that = (PersistentToken)o;
        return this.series.equals(that.series);
    }

    public int hashCode() {
        return this.series.hashCode();
    }

    public String toString() {
        return "PersistentToken{series='" + this.series + '\'' + ", tokenValue='" + this.tokenValue + '\'' + ", tokenDate=" + this.tokenDate + ", ipAddress='" + this.ipAddress + '\'' + ", userAgent='" + this.userAgent + '\'' + "}";
    }
}

