/*
 * Decompiled with CFR 0.152.
 */
package com.activiti.repository.editor;

import com.activiti.domain.editor.ModelRelation;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ModelRelationRepository
extends JpaRepository<ModelRelation, Long> {
    @Query(value="from ModelRelation mr where mr.parentModelId = :parentModelId")
    public List<ModelRelation> findByParentModelId(@Param(value="parentModelId") Long var1);

    @Query(value="from ModelRelation mr where mr.parentModelId = :parentModelId and mr.type = :type")
    public List<ModelRelation> findByParentModelIdAndType(@Param(value="parentModelId") Long var1, @Param(value="type") String var2);

    @Query(value="from ModelRelation mr where mr.modelId = :modelId")
    public List<ModelRelation> findByChildModelId(@Param(value="modelId") Long var1);

    @Query(value="from ModelRelation mr where mr.modelId = :modelId and mr.type = :type")
    public List<ModelRelation> findByChildModelIdAndType(@Param(value="modelId") Long var1, @Param(value="type") String var2);

    @Query(value="select m.id, m.name, m.modelType from ModelRelation mr inner join mr.model m where mr.parentModelId = :parentModelId")
    public List<Object[]> findModelInformationByParentModelId(@Param(value="parentModelId") Long var1);

    @Query(value="select m.id, m.name, m.modelType from ModelRelation mr inner join mr.parentModel m where mr.modelId = :modelId")
    public List<Object[]> findModelInformationByChildModelId(@Param(value="modelId") Long var1);

    @Modifying
    @Query(value="delete from ModelRelation mr where mr.parentModelId = :parentModelId")
    public void deleteModelRelationsForParentModel(@Param(value="parentModelId") Long var1);
}

