/*
 * Decompiled with CFR 0.152.
 */
package com.activiti.repository.runtime;

import com.activiti.domain.runtime.RelatedContent;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface RelatedContentRepository
extends JpaRepository<RelatedContent, Long> {
    public Page<RelatedContent> findAllRelatedBySourceAndSourceId(@Param(value="source") String var1, @Param(value="sourceId") String var2, Pageable var3);

    @Query(value="from RelatedContent r where r.taskId = :taskId and r.relatedContent = true")
    public Page<RelatedContent> findAllRelatedByTaskId(@Param(value="taskId") String var1, Pageable var2);

    @Query(value="from RelatedContent r where r.taskId = :taskId and r.relatedContent = false")
    public Page<RelatedContent> findAllFieldBasedContentByTaskId(@Param(value="taskId") String var1, Pageable var2);

    public Page<RelatedContent> findAllByTaskIdAndField(@Param(value="taskId") String var1, @Param(value="field") String var2, Pageable var3);

    @Query(value="from RelatedContent r where r.processInstanceId = :processInstanceId and r.relatedContent = true")
    public Page<RelatedContent> findAllRelatedByProcessInstanceId(@Param(value="processInstanceId") String var1, Pageable var2);

    @Query(value="from RelatedContent r where r.processInstanceId = :processInstanceId and r.relatedContent = false")
    public Page<RelatedContent> findAllFieldBasedContentByProcessInstanceId(@Param(value="processInstanceId") String var1, Pageable var2);

    @Query(value="from RelatedContent r where r.processInstanceId = :processInstanceId")
    public Page<RelatedContent> findAllContentByProcessInstanceId(@Param(value="processInstanceId") String var1, Pageable var2);

    @Query(value="from RelatedContent r where r.processInstanceId = :processInstanceId and r.field = :field")
    public Page<RelatedContent> findAllByProcessInstanceIdAndField(@Param(value="processInstanceId") String var1, @Param(value="field") String var2, Pageable var3);

    @Modifying
    @Query(value="delete from RelatedContent r where r.processInstanceId = :processInstanceId")
    public void deleteAllContentByProcessInstanceId(@Param(value="processInstanceId") String var1);

    @Query(value="select sum(r.contentSize) from RelatedContent r where r.createdBy = :user")
    public Long getTotalContentSizeForUser(@Param(value="user") String var1);
}

