/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.service.editor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.activiti.app.domain.editor.AbstractModel;
import org.activiti.app.domain.editor.Model;
import org.activiti.app.domain.editor.ModelHistory;
import org.activiti.app.model.editor.FormSaveRepresentation;
import org.activiti.app.model.editor.ModelKeyRepresentation;
import org.activiti.app.model.editor.form.FormRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.api.ModelService;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.activiti.engine.identity.User;
import org.activiti.form.model.FormDefinition;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivitiFormService {
    private static final Logger logger = LoggerFactory.getLogger(ActivitiFormService.class);
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ObjectMapper objectMapper;

    public FormRepresentation getForm(String formId) {
        Model model = this.modelService.getModel(formId);
        FormRepresentation form = this.createFormRepresentation(model);
        return form;
    }

    public FormRepresentation getFormHistory(String formId, String formHistoryId) {
        ModelHistory model = this.modelService.getModelHistory(formId, formHistoryId);
        FormRepresentation form = this.createFormRepresentation(model);
        return form;
    }

    public List<FormRepresentation> getForms(String[] formIds) {
        ArrayList<FormRepresentation> formRepresentations = new ArrayList<FormRepresentation>();
        if (formIds == null || formIds.length == 0) {
            throw new BadRequestException("No formIds provided in the request");
        }
        for (String formId : formIds) {
            Model model = this.modelService.getModel(formId);
            FormRepresentation form = this.createFormRepresentation(model);
            formRepresentations.add(form);
        }
        return formRepresentations;
    }

    public FormRepresentation saveForm(String formId, FormSaveRepresentation saveRepresentation) {
        User user = SecurityUtils.getCurrentUserObject();
        Model model = this.modelService.getModel(formId);
        String formKey = saveRepresentation.getFormRepresentation().getKey();
        ModelKeyRepresentation modelKeyInfo = this.modelService.validateModelKey(model, model.getModelType(), formKey);
        if (modelKeyInfo.isKeyAlreadyExists()) {
            throw new BadRequestException("Model with provided key already exists " + formKey);
        }
        model.setName(saveRepresentation.getFormRepresentation().getName());
        model.setKey(formKey);
        model.setDescription(saveRepresentation.getFormRepresentation().getDescription());
        String editorJson = null;
        try {
            editorJson = this.objectMapper.writeValueAsString((Object)saveRepresentation.getFormRepresentation().getFormDefinition());
        }
        catch (Exception e) {
            logger.error("Error while processing form json", (Throwable)e);
            throw new InternalServerErrorException("Form could not be saved " + formId);
        }
        String filteredImageString = saveRepresentation.getFormImageBase64().replace("data:image/png;base64,", "");
        byte[] imageBytes = Base64.decodeBase64((String)filteredImageString);
        model = this.modelService.saveModel(model, editorJson, imageBytes, saveRepresentation.isNewVersion(), saveRepresentation.getComment(), user);
        FormRepresentation result = new FormRepresentation(model);
        result.setFormDefinition(saveRepresentation.getFormRepresentation().getFormDefinition());
        return result;
    }

    protected FormRepresentation createFormRepresentation(AbstractModel model) {
        FormDefinition formDefinition = null;
        try {
            formDefinition = (FormDefinition)this.objectMapper.readValue(model.getModelEditorJson(), FormDefinition.class);
        }
        catch (Exception e) {
            logger.error("Error deserializing form", (Throwable)e);
            throw new InternalServerErrorException("Could not deserialize form definition");
        }
        FormRepresentation result = new FormRepresentation(model);
        result.setFormDefinition(formDefinition);
        return result;
    }
}

