/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.service.editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.activiti.app.domain.editor.Model;
import org.activiti.app.domain.editor.ModelHistory;
import org.activiti.app.repository.editor.ModelHistoryRepository;
import org.activiti.app.repository.editor.ModelRepository;
import org.activiti.app.service.exception.NotFoundException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseActivitiModelService {
    private static final Logger logger = LoggerFactory.getLogger(BaseActivitiModelService.class);
    protected static final String PROCESS_NOT_FOUND_MESSAGE_KEY = "PROCESS.ERROR.NOT-FOUND";
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ModelHistoryRepository modelHistoryRepository;
    @Autowired
    protected IdentityService identityService;

    protected Model getModel(String modelId, boolean checkRead, boolean checkEdit) {
        Model model = (Model)this.modelRepository.findOne((Serializable)((Object)modelId));
        if (model == null) {
            NotFoundException processNotFound = new NotFoundException("No model found with the given id: " + modelId);
            processNotFound.setMessageKey(PROCESS_NOT_FOUND_MESSAGE_KEY);
            throw processNotFound;
        }
        return model;
    }

    protected ModelHistory getModelHistory(String modelId, String modelHistoryId, boolean checkRead, boolean checkEdit) {
        Model model = this.getModel(modelId, checkRead, checkEdit);
        ModelHistory modelHistory = (ModelHistory)this.modelHistoryRepository.findOne((Serializable)((Object)modelHistoryId));
        if (modelHistory == null || modelHistory.getRemovalDate() != null || !modelHistory.getModelId().equals(model.getId())) {
            throw new NotFoundException("Model history not found: " + modelHistoryId);
        }
        return modelHistory;
    }

    protected List<String> getGroupIds(String userId) {
        List groups = this.identityService.createGroupQuery().groupMember(userId).list();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }
}

