/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.service.idm;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.activiti.app.domain.idm.PersistentToken;
import org.activiti.app.repository.idm.PersistentTokenRepository;
import org.activiti.app.service.idm.PersistentTokenService;
import org.activiti.engine.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataAccessException;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PersistentTokenServiceImpl
implements PersistentTokenService {
    private static final Logger logger = LoggerFactory.getLogger(PersistentTokenServiceImpl.class);
    private static final int DEFAULT_SERIES_LENGTH = 16;
    private static final int DEFAULT_TOKEN_LENGTH = 16;
    private SecureRandom random = new SecureRandom();
    @Inject
    private Environment environment;
    @Inject
    private PersistentTokenRepository persistentTokenRepository;
    private LoadingCache<String, PersistentToken> tokenCache;

    @PostConstruct
    protected void initTokenCache() {
        Long maxSize = (Long)this.environment.getProperty("cache.login-users.max.size", Long.class);
        Long maxAge = (Long)this.environment.getProperty("cache.login-users.max.age", Long.class);
        this.tokenCache = CacheBuilder.newBuilder().maximumSize(maxSize != null ? maxSize : 2048L).expireAfterWrite(maxAge != null ? maxAge : 30L, TimeUnit.SECONDS).recordStats().build((CacheLoader)new CacheLoader<String, PersistentToken>(){

            public PersistentToken load(String tokenId) throws Exception {
                PersistentToken persistentToken = (PersistentToken)PersistentTokenServiceImpl.this.persistentTokenRepository.findOne((Serializable)((Object)tokenId));
                if (persistentToken != null) {
                    return persistentToken;
                }
                throw new PersistentTokenNotFoundException();
            }
        });
    }

    @Override
    public PersistentToken saveAndFlush(PersistentToken persistentToken) {
        return (PersistentToken)this.persistentTokenRepository.saveAndFlush(persistentToken);
    }

    @Override
    public void delete(PersistentToken persistentToken) {
        this.tokenCache.invalidate((Object)persistentToken);
        this.persistentTokenRepository.delete(persistentToken);
    }

    @Override
    public PersistentToken getPersistentToken(String tokenId) {
        return this.getPersistentToken(tokenId, false);
    }

    @Override
    public PersistentToken getPersistentToken(String tokenId, boolean invalidateCacheEntry) {
        if (invalidateCacheEntry) {
            this.tokenCache.invalidate((Object)tokenId);
        }
        try {
            return (PersistentToken)this.tokenCache.get((Object)tokenId);
        }
        catch (ExecutionException e) {
            return null;
        }
        catch (UncheckedExecutionException e) {
            return null;
        }
    }

    private String generateSeriesData() {
        byte[] newSeries = new byte[16];
        this.random.nextBytes(newSeries);
        return new String(Base64.encode((byte[])newSeries));
    }

    private String generateTokenData() {
        byte[] newToken = new byte[16];
        this.random.nextBytes(newToken);
        return new String(Base64.encode((byte[])newToken));
    }

    @Override
    public PersistentToken createToken(User user, String remoteAddress, String userAgent) {
        PersistentToken token = new PersistentToken();
        token.setSeries(this.generateSeriesData());
        token.setUser(user.getId());
        token.setTokenValue(this.generateTokenData());
        token.setTokenDate(new Date());
        token.setIpAddress(remoteAddress);
        token.setUserAgent(userAgent);
        try {
            this.saveAndFlush(token);
            return token;
        }
        catch (DataAccessException e) {
            logger.error("Failed to save persistent token ", (Throwable)e);
            return token;
        }
    }

    private static class PersistentTokenNotFoundException
    extends RuntimeException {
        private PersistentTokenNotFoundException() {
        }
    }
}

