/*
 * Decompiled with CFR 0.152.
 */
package com.activiti.model.runtime;

public class QueryVariable {
    private String name;
    private String operation;
    private Object value;
    private String type;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QueryVariableOperation getVariableOperation() {
        if (this.operation == null) {
            return null;
        }
        return QueryVariableOperation.forFriendlyName(this.operation);
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static enum QueryVariableOperation {
        EQUALS("equals"),
        NOT_EQUALS("notEquals"),
        EQUALS_IGNORE_CASE("equalsIgnoreCase"),
        NOT_EQUALS_IGNORE_CASE("notEqualsIgnoreCase"),
        LIKE("like"),
        GREATER_THAN("greaterThan"),
        GREATER_THAN_OR_EQUALS("greaterThanOrEquals"),
        LESS_THAN("lessThan"),
        LESS_THAN_OR_EQUALS("lessThanOrEquals");

        private String friendlyName;

        private QueryVariableOperation(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public static QueryVariableOperation forFriendlyName(String friendlyName) {
            for (QueryVariableOperation type : QueryVariableOperation.values()) {
                if (!type.friendlyName.equals(friendlyName)) continue;
                return type;
            }
            return null;
        }
    }
}

