/*
 * Decompiled with CFR 0.152.
 */
package com.activiti.model.runtime;

import com.activiti.domain.runtime.RelatedContent;
import com.activiti.model.common.AbstractRepresentation;
import com.activiti.model.component.SimpleContentTypeMapper;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;

public class RelatedContentRepresentation
extends AbstractRepresentation {
    protected Long id;
    protected String name;
    protected Date created;
    protected String createdBy;
    protected boolean contentAvailable;
    protected boolean link;
    protected String source;
    protected String sourceId;
    protected String mimeType;
    protected String simpleType;
    protected String linkUrl;
    public String previewStatus = "queued";
    public String thumbnailStatus = "queued";

    public RelatedContentRepresentation() {
    }

    public RelatedContentRepresentation(RelatedContent content, SimpleContentTypeMapper mapper) {
        this.id = content.getId();
        this.name = content.getName();
        this.created = content.getCreated();
        this.createdBy = content.getCreatedBy();
        this.contentAvailable = content.isContentAvailable();
        this.mimeType = content.getMimeType();
        this.link = content.isLink();
        this.linkUrl = content.getLinkUrl();
        this.source = content.getSource();
        this.sourceId = content.getSourceId();
        if (mapper != null) {
            this.simpleType = mapper.getSimpleType(content);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public boolean isContentAvailable() {
        return this.contentAvailable;
    }

    public void setContentAvailable(boolean contentAvailable) {
        this.contentAvailable = contentAvailable;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(String simpleType) {
        this.simpleType = simpleType;
    }

    public void setLink(boolean link) {
        this.link = link;
    }

    public boolean isLink() {
        return this.link;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLinkUrl() {
        return this.linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public String getThumbnailStatus() {
        return this.thumbnailStatus;
    }

    public void setThumbnailStatus(String thumbnailStatus) {
        this.thumbnailStatus = thumbnailStatus;
    }

    public String getPreviewStatus() {
        return this.previewStatus;
    }

    public void setPreviewStatus(String previewStatus) {
        this.previewStatus = previewStatus;
    }
}

