/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.editor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.app.domain.editor.AbstractModel;
import org.activiti.app.domain.editor.AppDefinition;
import org.activiti.app.domain.editor.Model;
import org.activiti.app.domain.editor.ModelHistory;
import org.activiti.app.model.editor.AppDefinitionPublishRepresentation;
import org.activiti.app.model.editor.AppDefinitionRepresentation;
import org.activiti.app.model.editor.AppDefinitionSaveRepresentation;
import org.activiti.app.model.editor.AppDefinitionUpdateResultRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.api.ModelService;
import org.activiti.app.service.editor.AppDefinitionExportService;
import org.activiti.app.service.editor.AppDefinitionImportService;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.activiti.engine.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class AppDefinitionResource {
    @Autowired
    protected AppDefinitionExportService appDefinitionExportService;
    @Autowired
    protected AppDefinitionImportService appDefinitionImportService;
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ObjectMapper objectMapper;
    private static final Logger logger = LoggerFactory.getLogger(AppDefinitionResource.class);

    @RequestMapping(value={"/rest/app-definitions/{modelId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public AppDefinitionRepresentation getAppDefinition(@PathVariable(value="modelId") String modelId) {
        Model model = this.modelService.getModel(modelId);
        return this.createAppDefinitionRepresentation((AbstractModel)model);
    }

    @RequestMapping(value={"/rest/app-definitions/{modelId}/history/{modelHistoryId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public AppDefinitionRepresentation getAppDefinitionHistory(@PathVariable String modelId, @PathVariable String modelHistoryId) {
        ModelHistory model = this.modelService.getModelHistory(modelId, modelHistoryId);
        return this.createAppDefinitionRepresentation((AbstractModel)model);
    }

    @RequestMapping(value={"/rest/app-definitions/{modelId}"}, method={RequestMethod.PUT}, produces={"application/json"})
    public AppDefinitionUpdateResultRepresentation updateAppDefinition(@PathVariable(value="modelId") String modelId, @RequestBody AppDefinitionSaveRepresentation updatedModel) {
        AppDefinitionUpdateResultRepresentation result = new AppDefinitionUpdateResultRepresentation();
        User user = SecurityUtils.getCurrentUserObject();
        Model model = this.modelService.getModel(modelId);
        model.setName(updatedModel.getAppDefinition().getName());
        model.setKey(updatedModel.getAppDefinition().getKey());
        model.setDescription(updatedModel.getAppDefinition().getDescription());
        String editorJson = null;
        try {
            editorJson = this.objectMapper.writeValueAsString((Object)updatedModel.getAppDefinition().getDefinition());
        }
        catch (Exception e) {
            logger.error("Error while processing app definition json " + modelId, (Throwable)e);
            throw new InternalServerErrorException("App definition could not be saved " + modelId);
        }
        model = this.modelService.saveModel(model, editorJson, null, false, null, user);
        if (updatedModel.isPublish()) {
            return this.appDefinitionImportService.publishAppDefinition(modelId, new AppDefinitionPublishRepresentation(null, updatedModel.getForce()));
        }
        AppDefinitionRepresentation appDefinition = new AppDefinitionRepresentation((AbstractModel)model);
        appDefinition.setDefinition(updatedModel.getAppDefinition().getDefinition());
        result.setAppDefinition(appDefinition);
        return result;
    }

    @RequestMapping(value={"/rest/app-definitions/{modelId}/publish"}, method={RequestMethod.POST}, produces={"application/json"})
    public AppDefinitionUpdateResultRepresentation publishAppDefinition(@PathVariable(value="modelId") String modelId, @RequestBody AppDefinitionPublishRepresentation publishModel) {
        return this.appDefinitionImportService.publishAppDefinition(modelId, publishModel);
    }

    @RequestMapping(value={"/rest/app-definitions/{modelId}/export"}, method={RequestMethod.GET})
    public void exportAppDefinition(HttpServletResponse response, @PathVariable String modelId) throws IOException {
        this.appDefinitionExportService.exportAppDefinition(response, modelId);
    }

    @Transactional
    @RequestMapping(value={"/rest/app-definitions/{modelId}/import"}, method={RequestMethod.POST}, produces={"application/json"})
    public AppDefinitionRepresentation importAppDefinition(HttpServletRequest request, @PathVariable String modelId, @RequestParam(value="file") MultipartFile file) {
        return this.appDefinitionImportService.importAppDefinitionNewVersion(request, file, modelId);
    }

    @Transactional
    @RequestMapping(value={"/rest/app-definitions/{modelId}/text/import"}, method={RequestMethod.POST})
    public String importAppDefinitionText(HttpServletRequest request, @PathVariable String modelId, @RequestParam(value="file") MultipartFile file) {
        AppDefinitionRepresentation appDefinitionRepresentation = this.appDefinitionImportService.importAppDefinitionNewVersion(request, file, modelId);
        String appDefinitionRepresentationJson = null;
        try {
            appDefinitionRepresentationJson = this.objectMapper.writeValueAsString((Object)appDefinitionRepresentation);
        }
        catch (Exception e) {
            logger.error("Error while App Definition representation json", (Throwable)e);
            throw new InternalServerErrorException("App definition could not be saved");
        }
        return appDefinitionRepresentationJson;
    }

    @Transactional
    @RequestMapping(value={"/rest/app-definitions/import"}, method={RequestMethod.POST}, produces={"application/json"})
    public AppDefinitionRepresentation importAppDefinition(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) {
        return this.appDefinitionImportService.importAppDefinition(request, file);
    }

    @Transactional
    @RequestMapping(value={"/rest/app-definitions/text/import"}, method={RequestMethod.POST})
    public String importAppDefinitionText(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) {
        AppDefinitionRepresentation appDefinitionRepresentation = this.appDefinitionImportService.importAppDefinition(request, file);
        String appDefinitionRepresentationJson = null;
        try {
            appDefinitionRepresentationJson = this.objectMapper.writeValueAsString((Object)appDefinitionRepresentation);
        }
        catch (Exception e) {
            logger.error("Error while App Definition representation json", (Throwable)e);
            throw new InternalServerErrorException("App definition could not be saved");
        }
        return appDefinitionRepresentationJson;
    }

    protected AppDefinitionRepresentation createAppDefinitionRepresentation(AbstractModel model) {
        AppDefinition appDefinition = null;
        try {
            appDefinition = (AppDefinition)this.objectMapper.readValue(model.getModelEditorJson(), AppDefinition.class);
        }
        catch (Exception e) {
            logger.error("Error deserializing app " + model.getId(), (Throwable)e);
            throw new InternalServerErrorException("Could not deserialize app definition");
        }
        AppDefinitionRepresentation result = new AppDefinitionRepresentation(model);
        result.setDefinition(appDefinition);
        return result;
    }
}

