/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.idm;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.activiti.app.model.idm.ChangePasswordRepresentation;
import org.activiti.app.model.idm.GroupRepresentation;
import org.activiti.app.model.idm.UserRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.activiti.app.service.exception.NotFoundException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.Picture;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.util.IoUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/admin"})
public class IdmProfileResource {
    @Autowired
    protected IdentityService identityService;

    @RequestMapping(value={"/profile"}, method={RequestMethod.GET}, produces={"application/json"})
    public UserRepresentation getProfile() {
        User user = SecurityUtils.getCurrentActivitiAppUser().getUserObject();
        UserRepresentation userRepresentation = new UserRepresentation(user);
        List groups = this.identityService.createGroupQuery().groupMember(user.getId()).list();
        for (Group group : groups) {
            userRepresentation.getGroups().add(new GroupRepresentation(group));
        }
        return userRepresentation;
    }

    @RequestMapping(value={"/profile"}, method={RequestMethod.POST}, produces={"application/json"})
    public UserRepresentation updateProfile(@RequestBody UserRepresentation userRepresentation) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        if (StringUtils.isEmpty((CharSequence)userRepresentation.getEmail())) {
            throw new BadRequestException("Empty email is not allowed");
        }
        User user = (User)this.identityService.createUserQuery().userId(currentUser.getId()).singleResult();
        user.setFirstName(userRepresentation.getFirstName());
        user.setLastName(userRepresentation.getLastName());
        user.setEmail(userRepresentation.getEmail());
        this.identityService.saveUser(user);
        return new UserRepresentation(user);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/profile-password"}, method={RequestMethod.POST}, produces={"application/json"})
    public void changePassword(@RequestBody ChangePasswordRepresentation changePasswordRepresentation) {
        User user = (User)this.identityService.createUserQuery().userId(SecurityUtils.getCurrentUserId()).singleResult();
        if (!user.getPassword().equals(changePasswordRepresentation.getOriginalPassword())) {
            throw new NotFoundException();
        }
        user.setPassword(changePasswordRepresentation.getNewPassword());
        this.identityService.saveUser(user);
    }

    @RequestMapping(value={"/profile-picture"}, method={RequestMethod.GET})
    public void getProfilePicture(HttpServletResponse response) {
        try {
            int count;
            Picture picture = this.identityService.getUserPicture(SecurityUtils.getCurrentUserId());
            if (picture == null) {
                try {
                    byte[] pictureBytes = IoUtil.readInputStream((InputStream)this.getClass().getClassLoader().getResourceAsStream("activiti-logo.png"), (String)"default-logo");
                    picture = new Picture(pictureBytes, "image/png");
                }
                catch (Exception e) {
                    throw new InternalServerErrorException("Could not find default tenant logo");
                }
            }
            response.setContentType(picture.getMimeType());
            ServletOutputStream servletOutputStream = response.getOutputStream();
            BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(picture.getBytes()));
            byte[] buffer = new byte[32384];
            while ((count = in.read(buffer)) != -1) {
                servletOutputStream.write(buffer, 0, count);
            }
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        catch (Exception e) {
            throw new InternalServerErrorException("Could not get profile picture", (Throwable)e);
        }
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/profile-picture"}, method={RequestMethod.POST}, produces={"application/json"})
    public void uploadProfilePicture(@RequestParam(value="file") MultipartFile file) {
        Picture picture = null;
        try {
            picture = new Picture(file.getBytes(), file.getContentType());
        }
        catch (IOException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
        this.identityService.setUserPicture(SecurityUtils.getCurrentUserId(), picture);
    }
}

