/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.idm;

import java.util.ArrayList;
import java.util.List;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.idm.CreateUserRepresentation;
import org.activiti.app.model.idm.UpdateUsersRepresentation;
import org.activiti.app.model.idm.UserRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.ConflictingRequestException;
import org.activiti.app.service.exception.NotPermittedException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IdmUsersResource {
    private static final int MAX_USER_SIZE = 100;
    @Autowired
    protected IdentityService identityService;

    @RequestMapping(value={"/rest/admin/users"}, method={RequestMethod.GET})
    public ResultListDataRepresentation getUsers(@RequestParam(required=false) String filter, @RequestParam(required=false) String sort, @RequestParam(required=false) Integer start, @RequestParam(required=false) String groupId) {
        this.validateAdminRole();
        ResultListDataRepresentation result = new ResultListDataRepresentation();
        UserQuery userQuery = this.identityService.createUserQuery();
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            userQuery.userFullNameLike("%" + filter + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)sort)) {
            if ("idDesc".equals(sort)) {
                userQuery.orderByUserId().desc();
            } else if ("idAsc".equals(sort)) {
                userQuery.orderByUserId().asc();
            } else if ("emailAsc".equals(sort)) {
                userQuery.orderByUserEmail().asc();
            } else if ("emailDesc".equals(sort)) {
                userQuery.orderByUserEmail().desc();
            }
        }
        Integer startValue = start != null ? start : 0;
        Integer size = 100;
        List users = userQuery.listPage(startValue.intValue(), size != null && size > 0 ? size : 100);
        Long totalCount = userQuery.count();
        result.setTotal(Long.valueOf(totalCount.intValue()));
        result.setStart(startValue);
        result.setSize(Integer.valueOf(users.size()));
        result.setData(this.convertToUserRepresentations(users));
        return result;
    }

    protected List<UserRepresentation> convertToUserRepresentations(List<User> users) {
        ArrayList<UserRepresentation> result = new ArrayList<UserRepresentation>(users.size());
        for (User user : users) {
            result.add(new UserRepresentation(user));
        }
        return result;
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/rest/admin/users/{userId}"}, method={RequestMethod.PUT})
    public void updateUserDetails(@PathVariable String userId, @RequestBody UpdateUsersRepresentation updateUsersRepresentation) {
        User user = (User)this.identityService.createUserQuery().userId(userId).singleResult();
        if (user != null) {
            user.setId(updateUsersRepresentation.getId());
            user.setFirstName(updateUsersRepresentation.getFirstName());
            user.setLastName(updateUsersRepresentation.getLastName());
            user.setEmail(updateUsersRepresentation.getEmail());
            this.identityService.saveUser(user);
        }
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/rest/admin/users"}, method={RequestMethod.PUT})
    public void bulkUpdateUserDetails(@RequestBody UpdateUsersRepresentation updateUsersRepresentation) {
        this.validateAdminRole();
        if (updateUsersRepresentation.getPassword() != null) {
            for (String userId : updateUsersRepresentation.getUsers()) {
                User user = (User)this.identityService.createUserQuery().userId(userId).singleResult();
                if (user == null) continue;
                user.setPassword(updateUsersRepresentation.getPassword());
                this.identityService.saveUser(user);
            }
        }
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/rest/admin/users/{userId}"}, method={RequestMethod.DELETE})
    public void deleteUser(@PathVariable String userId) {
        this.validateAdminRole();
        List groups = this.identityService.createGroupQuery().groupMember(userId).list();
        if (groups != null && groups.size() > 0) {
            for (Group group : groups) {
                this.identityService.deleteMembership(userId, group.getId());
            }
        }
        this.identityService.deleteUser(userId);
    }

    @RequestMapping(value={"/rest/admin/users"}, method={RequestMethod.POST})
    public User createNewUser(@RequestBody CreateUserRepresentation userRepresentation) {
        this.validateAdminRole();
        if (StringUtils.isBlank((CharSequence)userRepresentation.getId()) || StringUtils.isBlank((CharSequence)userRepresentation.getPassword()) || StringUtils.isBlank((CharSequence)userRepresentation.getFirstName())) {
            throw new BadRequestException("Id, password and first name are required");
        }
        if (userRepresentation.getEmail() != null && this.identityService.createUserQuery().userEmail(userRepresentation.getEmail()).count() > 0L) {
            throw new ConflictingRequestException("User already registered", "ACCOUNT.SIGNUP.ERROR.ALREADY-REGISTERED");
        }
        User user = this.identityService.newUser(userRepresentation.getId() != null ? userRepresentation.getId() : userRepresentation.getEmail());
        user.setFirstName(userRepresentation.getFirstName());
        user.setLastName(userRepresentation.getLastName());
        user.setEmail(userRepresentation.getEmail());
        user.setPassword(userRepresentation.getPassword());
        this.identityService.saveUser(user);
        return user;
    }

    protected void validateAdminRole() {
        boolean isAdmin;
        boolean bl = isAdmin = this.identityService.createGroupQuery().groupId("ROLE_ADMIN").groupMember(SecurityUtils.getCurrentUserId()).count() > 0L;
        if (!isAdmin) {
            throw new NotPermittedException();
        }
    }
}

