/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.idm;

import javax.servlet.http.HttpServletResponse;
import org.activiti.app.model.idm.UserRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.exception.NotFoundException;
import org.activiti.app.service.exception.NotPermittedException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserResource {
    @Autowired
    protected IdentityService identityService;

    @RequestMapping(value={"/rest/users/{userId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public UserRepresentation getUser(@PathVariable String userId, HttpServletResponse response) {
        User user = (User)this.identityService.createUserQuery().userId(userId).singleResult();
        if (user == null) {
            throw new NotFoundException("User with id: " + userId + " does not exist or is inactive");
        }
        if (!user.getId().equals(SecurityUtils.getCurrentUserId())) {
            throw new NotPermittedException("Can only get user details for authenticated user");
        }
        return new UserRepresentation(user);
    }
}

