/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.runtime.AppDefinitionRepresentation;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAppDefinitionsResource {
    private final Logger logger = LoggerFactory.getLogger(AbstractAppDefinitionsResource.class);
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected ObjectMapper objectMapper;
    protected static final AppDefinitionRepresentation kickstartAppDefinitionRepresentation = AppDefinitionRepresentation.createDefaultAppDefinitionRepresentation((String)"kickstart");
    protected static final AppDefinitionRepresentation taskAppDefinitionRepresentation = AppDefinitionRepresentation.createDefaultAppDefinitionRepresentation((String)"tasks");
    protected static final AppDefinitionRepresentation idmAppDefinitionRepresentation = AppDefinitionRepresentation.createDefaultAppDefinitionRepresentation((String)"identity");

    protected ResultListDataRepresentation getAppDefinitions() {
        ArrayList<AppDefinitionRepresentation> resultList = new ArrayList<AppDefinitionRepresentation>();
        resultList.add(kickstartAppDefinitionRepresentation);
        resultList.add(taskAppDefinitionRepresentation);
        resultList.add(idmAppDefinitionRepresentation);
        HashMap<String, Deployment> deploymentMap = new HashMap<String, Deployment>();
        List deployments = this.repositoryService.createDeploymentQuery().list();
        for (Deployment deployment : deployments) {
            if (deployment.getKey() == null) continue;
            if (!deploymentMap.containsKey(deployment.getKey())) {
                deploymentMap.put(deployment.getKey(), deployment);
                continue;
            }
            if (!((Deployment)deploymentMap.get(deployment.getKey())).getDeploymentTime().before(deployment.getDeploymentTime())) continue;
            deploymentMap.put(deployment.getKey(), deployment);
        }
        for (Deployment deployment : deploymentMap.values()) {
            resultList.add(this.createRepresentation(deployment));
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(resultList);
        return result;
    }

    protected AppDefinitionRepresentation createDefaultAppDefinition(String id) {
        AppDefinitionRepresentation app = new AppDefinitionRepresentation();
        return app;
    }

    protected AppDefinitionRepresentation createRepresentation(Deployment deployment) {
        AppDefinitionRepresentation resultAppDef = new AppDefinitionRepresentation();
        resultAppDef.setDeploymentId(deployment.getId());
        resultAppDef.setDeploymentKey(deployment.getKey());
        resultAppDef.setName(deployment.getName());
        return resultAppDef;
    }
}

