/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.app.domain.runtime.RelatedContent;
import org.activiti.app.model.component.SimpleContentTypeMapper;
import org.activiti.app.model.runtime.CreateProcessInstanceRepresentation;
import org.activiti.app.model.runtime.ProcessInstanceRepresentation;
import org.activiti.app.model.runtime.RelatedContentRepresentation;
import org.activiti.app.service.api.UserCache;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.runtime.ActivitiService;
import org.activiti.app.service.runtime.PermissionService;
import org.activiti.app.service.runtime.RelatedContentService;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.form.api.FormRepositoryService;
import org.activiti.form.api.FormService;
import org.activiti.form.model.FormDefinition;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;

public abstract class AbstractProcessInstancesResource {
    @Autowired
    protected ActivitiService activitiService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected FormRepositoryService formRepositoryService;
    @Autowired
    protected FormService formService;
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected RelatedContentService relatedContentService;
    @Autowired
    protected SimpleContentTypeMapper typeMapper;
    @Autowired
    protected UserCache userCache;
    @Autowired
    protected ObjectMapper objectMapper;

    public ProcessInstanceRepresentation startNewProcessInstance(CreateProcessInstanceRepresentation startRequest) {
        UserCache.CachedUser cachedUser;
        StartEvent startEvent;
        BpmnModel bpmnModel;
        Process process;
        FlowElement startElement;
        if (StringUtils.isEmpty((CharSequence)startRequest.getProcessDefinitionId())) {
            throw new BadRequestException("Process definition id is required");
        }
        FormDefinition formDefinition = null;
        Map variables = null;
        ProcessDefinition processDefinition = this.permissionService.getProcessDefinitionById(startRequest.getProcessDefinitionId());
        if ((startRequest.getValues() != null || startRequest.getOutcome() != null) && (startElement = (process = (bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId())).getProcessById(processDefinition.getKey())).getInitialFlowElement()) instanceof StartEvent && StringUtils.isNotEmpty((CharSequence)(startEvent = (StartEvent)startElement).getFormKey()) && (formDefinition = this.formRepositoryService.getFormDefinitionByKey(startEvent.getFormKey())) != null) {
            variables = this.formService.getVariablesFromFormSubmission(formDefinition, startRequest.getValues(), startRequest.getOutcome());
        }
        ProcessInstance processInstance = this.activitiService.startProcessInstance(startRequest.getProcessDefinitionId(), variables, startRequest.getName());
        HistoricProcessInstance historicProcess = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        if (formDefinition != null) {
            this.formService.storeSubmittedForm(variables, formDefinition, null, historicProcess.getId());
        }
        User user = null;
        if (historicProcess.getStartUserId() != null && (cachedUser = this.userCache.getUser(historicProcess.getStartUserId())) != null && cachedUser.getUser() != null) {
            user = cachedUser.getUser();
        }
        return new ProcessInstanceRepresentation(historicProcess, processDefinition, ((ProcessDefinitionEntity)processDefinition).isGraphicalNotationDefined(), user);
    }

    protected Map<String, List<RelatedContent>> groupContentByField(Page<RelatedContent> allContent) {
        HashMap<String, List<RelatedContent>> result = new HashMap<String, List<RelatedContent>>();
        for (RelatedContent content : allContent.getContent()) {
            List<RelatedContent> list = result.get(content.getField());
            if (list == null) {
                list = new ArrayList<RelatedContent>();
                result.put(content.getField(), list);
            }
            list.add(content);
        }
        return result;
    }

    protected RelatedContentRepresentation createRelatedContentResponse(RelatedContent relatedContent) {
        RelatedContentRepresentation relatedContentResponse = new RelatedContentRepresentation(relatedContent, this.typeMapper);
        return relatedContentResponse;
    }
}

