/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.activiti.app.domain.runtime.RelatedContent;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.component.SimpleContentTypeMapper;
import org.activiti.app.model.runtime.ProcessInstanceRepresentation;
import org.activiti.app.model.runtime.RelatedContentRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.api.UserCache;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.activiti.app.service.exception.NotFoundException;
import org.activiti.app.service.exception.NotPermittedException;
import org.activiti.app.service.runtime.PermissionService;
import org.activiti.app.service.runtime.RelatedContentService;
import org.activiti.app.service.runtime.RelatedContentStreamProvider;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractRelatedContentResource {
    private static final int MAX_CONTENT_ITEMS = 50;
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected RelatedContentService contentService;
    @Autowired
    protected RelatedContentStreamProvider streamProvider;
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected SimpleContentTypeMapper simpleTypeMapper;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected UserCache userCache;
    @Autowired
    protected RelatedContentStreamProvider relatedContentStreamProvider;

    public ResultListDataRepresentation getRelatedContentForTask(String taskId) {
        this.permissionService.validateReadPermissionOnTask(SecurityUtils.getCurrentUserObject(), taskId);
        return this.createResultRepresentation((Page<RelatedContent>)this.contentService.getRelatedContentForTask(taskId, 50, 0));
    }

    public ResultListDataRepresentation getRelatedContentForProcessInstance(String processInstanceId) {
        if (!this.permissionService.hasReadPermissionOnProcessInstance(SecurityUtils.getCurrentUserObject(), processInstanceId)) {
            throw new NotPermittedException("You are not allowed to read the process with id: " + processInstanceId);
        }
        return this.createResultRepresentation((Page<RelatedContent>)this.contentService.getRelatedContentForProcessInstance(processInstanceId, 50, 0));
    }

    public RelatedContentRepresentation createRelatedContentOnTask(String taskId, MultipartFile file) {
        User user = SecurityUtils.getCurrentUserObject();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task not found or already completed: " + taskId);
        }
        if (!this.permissionService.canAddRelatedContentToTask(user, taskId)) {
            throw new NotPermittedException("You are not allowed to read the task with id: " + taskId);
        }
        return this.uploadFile(user, file, taskId, task.getProcessInstanceId());
    }

    public RelatedContentRepresentation createRelatedContentOnTask(String taskId, RelatedContentRepresentation relatedContent) {
        User user = SecurityUtils.getCurrentUserObject();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task not found or already completed: " + taskId);
        }
        if (!this.permissionService.canAddRelatedContentToTask(user, taskId)) {
            throw new NotPermittedException("You are not allowed to read the task with id: " + taskId);
        }
        return this.addRelatedContent(relatedContent, taskId, task.getProcessInstanceId(), true);
    }

    public RelatedContentRepresentation createRelatedContentOnProcessInstance(String processInstanceId, RelatedContentRepresentation relatedContent) {
        User user = SecurityUtils.getCurrentUserObject();
        if (!this.permissionService.canAddRelatedContentToProcessInstance(user, processInstanceId)) {
            throw new NotPermittedException("You are not allowed to read the process with id: " + processInstanceId);
        }
        return this.addRelatedContent(relatedContent, null, processInstanceId, true);
    }

    public RelatedContentRepresentation createRelatedContentOnProcessInstance(String processInstanceId, MultipartFile file) {
        User user = SecurityUtils.getCurrentUserObject();
        if (!this.permissionService.canAddRelatedContentToProcessInstance(user, processInstanceId)) {
            throw new NotPermittedException("You are not allowed to read the process with id: " + processInstanceId);
        }
        return this.uploadFile(user, file, null, processInstanceId);
    }

    public RelatedContentRepresentation createTemporaryRawRelatedContent(MultipartFile file) {
        User user = SecurityUtils.getCurrentUserObject();
        return this.uploadFile(user, file, null, null);
    }

    public RelatedContentRepresentation createTemporaryRelatedContent(RelatedContentRepresentation relatedContent) {
        return this.addRelatedContent(relatedContent, null, null, false);
    }

    public void deleteContent(Long contentId, HttpServletResponse response) {
        RelatedContent content = this.contentService.getRelatedContent(contentId, false);
        if (content == null) {
            throw new NotFoundException("No content found with id: " + contentId);
        }
        if (!this.permissionService.hasWritePermissionOnRelatedContent(SecurityUtils.getCurrentUserObject(), content)) {
            throw new NotPermittedException("You are not allowed to delete the content with id: " + contentId);
        }
        if (content.getField() != null) {
            throw new NotPermittedException("You are not allowed to delete the content with id: " + contentId);
        }
        this.contentService.deleteRelatedContent(content);
    }

    public RelatedContentRepresentation getContent(Long contentId) {
        RelatedContent content = this.contentService.getRelatedContent(contentId, false);
        if (content == null) {
            throw new NotFoundException("No content found with id: " + contentId);
        }
        if (!this.permissionService.canDownloadContent(SecurityUtils.getCurrentUserObject(), content)) {
            throw new NotPermittedException("You are not allowed to view the content with id: " + contentId);
        }
        return this.createRelatedContentResponse(content);
    }

    public void getRawContent(Long contentId, HttpServletResponse response) {
        RelatedContent content = this.contentService.getRelatedContent(contentId, false);
        if (content == null) {
            throw new NotFoundException("No content found with id: " + contentId);
        }
        if (!content.isContentAvailable() || content.getContentStoreId() == null && !content.isLink()) {
            throw new NotFoundException("Raw content not yet available for id: " + contentId);
        }
        if (!this.permissionService.canDownloadContent(SecurityUtils.getCurrentUserObject(), content)) {
            throw new NotPermittedException("You are not allowed to read the content with id: " + contentId);
        }
        if (content.getMimeType() != null) {
            response.setContentType(content.getMimeType());
        }
        InputStream inputstream = null;
        try {
            inputstream = this.streamProvider.getContentStream(content);
            IOUtils.copy((InputStream)inputstream, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error while writing raw content data for content: " + contentId, (Throwable)e);
        }
        finally {
            if (inputstream != null) {
                IOUtils.closeQuietly((InputStream)inputstream);
            }
        }
    }

    public ResultListDataRepresentation getRelatedProcessInstancesForContent(String source, String sourceId) {
        List<Object> processInstances;
        Page relatedContents = this.contentService.getRelatedContent(source, sourceId, 50, 0);
        HashSet<String> processInstanceIds = new HashSet<String>(relatedContents.getSize());
        for (RelatedContent relatedContent : relatedContents) {
            processInstanceIds.add(relatedContent.getProcessInstanceId());
        }
        if (processInstanceIds.isEmpty()) {
            processInstances = new LinkedList<HistoricProcessInstance>();
        } else {
            HistoricProcessInstanceQuery processInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
            User currentUser = SecurityUtils.getCurrentUserObject();
            processInstanceQuery.involvedUser(String.valueOf(currentUser.getId()));
            processInstanceQuery.processInstanceIds(processInstanceIds);
            processInstanceQuery.orderByProcessInstanceId().desc();
            processInstances = processInstanceQuery.listPage(0, 50);
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(this.convertInstanceList(processInstances));
        return result;
    }

    protected List<ProcessInstanceRepresentation> convertInstanceList(List<HistoricProcessInstance> instances) {
        ArrayList<ProcessInstanceRepresentation> result = new ArrayList<ProcessInstanceRepresentation>();
        if (CollectionUtils.isNotEmpty(instances)) {
            for (HistoricProcessInstance processInstance : instances) {
                UserCache.CachedUser user;
                User userRep = null;
                if (processInstance.getStartUserId() != null && (user = this.userCache.getUser(processInstance.getStartUserId())) != null && user.getUser() != null) {
                    userRep = user.getUser();
                }
                ProcessDefinitionEntity procDef = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(processInstance.getProcessDefinitionId());
                ProcessInstanceRepresentation instanceRepresentation = new ProcessInstanceRepresentation(processInstance, (ProcessDefinition)procDef, procDef.isGraphicalNotationDefined(), userRep);
                result.add(instanceRepresentation);
            }
        }
        return result;
    }

    protected RelatedContentRepresentation uploadFile(User user, MultipartFile file, String taskId, String processInstanceId) {
        if (file != null && file.getName() != null) {
            try {
                String contentType = file.getContentType();
                if (StringUtils.equals((CharSequence)file.getContentType(), (CharSequence)"application/octet-stream")) {
                    contentType = this.getContentTypeForFileExtension(file);
                }
                RelatedContent relatedContent = this.contentService.createRelatedContent(user, this.getFileName(file), null, null, taskId, processInstanceId, contentType, file.getInputStream(), Long.valueOf(file.getSize()), true, false);
                return new RelatedContentRepresentation(relatedContent, this.simpleTypeMapper);
            }
            catch (IOException e) {
                throw new BadRequestException("Error while reading file data", (Throwable)e);
            }
        }
        throw new BadRequestException("File to upload is missing");
    }

    protected RelatedContentRepresentation addRelatedContent(RelatedContentRepresentation relatedContent, String taskId, String processInstanceId, boolean isRelatedContent) {
        if (relatedContent.getSource() == null || relatedContent.getSourceId() == null || relatedContent.getName() == null) {
            throw new BadRequestException("Name, source and sourceId are required paremeters");
        }
        RelatedContent result = this.contentService.createRelatedContent(SecurityUtils.getCurrentUserObject(), relatedContent.getName(), relatedContent.getSource(), relatedContent.getSourceId(), taskId, processInstanceId, relatedContent.getMimeType(), null, null, isRelatedContent, relatedContent.isLink());
        return new RelatedContentRepresentation(result, this.simpleTypeMapper);
    }

    protected String getFileName(MultipartFile file) {
        return file.getOriginalFilename() != null ? file.getOriginalFilename() : "Nameless file";
    }

    protected ResultListDataRepresentation createResultRepresentation(Page<RelatedContent> results) {
        ArrayList<RelatedContentRepresentation> resultList = new ArrayList<RelatedContentRepresentation>(results.getNumberOfElements());
        for (RelatedContent content : results) {
            resultList.add(this.createRelatedContentResponse(content));
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(resultList);
        result.setTotal(Long.valueOf(results.getTotalElements()));
        return result;
    }

    protected RelatedContentRepresentation createRelatedContentResponse(RelatedContent relatedContent) {
        RelatedContentRepresentation relatedContentResponse = new RelatedContentRepresentation(relatedContent, this.simpleTypeMapper);
        return relatedContentResponse;
    }

    protected String getContentTypeForFileExtension(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        String contentType = null;
        if (fileName.endsWith(".jpeg") || fileName.endsWith(".jpg")) {
            contentType = "image/jpeg";
        } else if (fileName.endsWith("gif")) {
            contentType = "image/gif";
        } else if (fileName.endsWith("png")) {
            contentType = "image/png";
        } else if (fileName.endsWith("bmp")) {
            contentType = "image/bmp";
        } else if (fileName.endsWith("tif") || fileName.endsWith(".tiff")) {
            contentType = "image/tiff";
        } else if (fileName.endsWith("png")) {
            contentType = "image/png";
        } else if (fileName.endsWith("doc")) {
            contentType = "application/msword";
        } else if (fileName.endsWith("docx")) {
            contentType = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
        } else if (fileName.endsWith("docm")) {
            contentType = "application/vnd.ms-word.document.macroenabled.12";
        } else if (fileName.endsWith("dotm")) {
            contentType = "application/vnd.ms-word.template.macroenabled.12";
        } else if (fileName.endsWith("odt")) {
            contentType = "application/vnd.oasis.opendocument.text";
        } else if (fileName.endsWith("ott")) {
            contentType = "application/vnd.oasis.opendocument.text-template";
        } else if (fileName.endsWith("rtf")) {
            contentType = "application/rtf";
        } else if (fileName.endsWith("txt")) {
            contentType = "application/text";
        } else if (fileName.endsWith("xls")) {
            contentType = "application/vnd.ms-excel";
        } else if (fileName.endsWith("xlsx")) {
            contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        } else if (fileName.endsWith("xlsb")) {
            contentType = "application/vnd.ms-excel.sheet.binary.macroenabled.12";
        } else if (fileName.endsWith("xltx")) {
            contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.template";
        } else if (fileName.endsWith("ods")) {
            contentType = "application/vnd.oasis.opendocument.spreadsheet";
        } else if (fileName.endsWith("ppt")) {
            contentType = "application/vnd.ms-powerpoint";
        } else if (fileName.endsWith("pptx")) {
            contentType = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
        } else if (fileName.endsWith("ppsm")) {
            contentType = "application/vnd.ms-powerpoint.slideshow.macroenabled.12";
        } else if (fileName.endsWith("ppsx")) {
            contentType = "application/vnd.openxmlformats-officedocument.presentationml.slideshow";
        } else if (fileName.endsWith("odp")) {
            contentType = "application/vnd.oasis.opendocument.presentation";
        } else {
            return file.getContentType();
        }
        return contentType;
    }
}

