/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.idm.UserRepresentation;
import org.activiti.app.model.runtime.TaskRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.api.UserCache;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.runtime.PermissionService;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskInfoQuery;
import org.activiti.engine.task.TaskInfoQueryWrapper;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTaskQueryResource {
    private static final String SORT_CREATED_ASC = "created-asc";
    private static final String SORT_CREATED_DESC = "created-desc";
    private static final String SORT_DUE_ASC = "due-asc";
    private static final String SORT_DUE_DESC = "due-desc";
    private static final int DEFAULT_PAGE_SIZE = 25;
    @Inject
    protected RepositoryService repositoryService;
    @Inject
    protected TaskService taskService;
    @Inject
    protected RuntimeService runtimeService;
    @Inject
    protected HistoryService historyService;
    @Inject
    protected UserCache userCache;
    @Inject
    protected PermissionService permissionService;

    public ResultListDataRepresentation listTasks(ObjectNode requestNode) {
        JsonNode sortNode;
        JsonNode dueAfterNode;
        JsonNode dueBeforeNode;
        JsonNode processDefinitionNode;
        JsonNode assignmentNode;
        JsonNode textNode;
        JsonNode processInstanceIdNode;
        if (requestNode == null) {
            throw new BadRequestException("No request found");
        }
        User currentUser = SecurityUtils.getCurrentUserObject();
        JsonNode stateNode = requestNode.get("state");
        TaskInfoQueryWrapper taskInfoQueryWrapper = null;
        if (stateNode != null && "completed".equals(stateNode.asText())) {
            HistoricTaskInstanceQuery historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
            historicTaskInstanceQuery.finished();
            taskInfoQueryWrapper = new TaskInfoQueryWrapper((TaskInfoQuery)historicTaskInstanceQuery);
        } else {
            taskInfoQueryWrapper = new TaskInfoQueryWrapper((TaskInfoQuery)this.taskService.createTaskQuery());
        }
        JsonNode deploymentKeyNode = requestNode.get("deploymentKey");
        if (deploymentKeyNode != null && !deploymentKeyNode.isNull()) {
            List deployments = this.repositoryService.createDeploymentQuery().deploymentKey(deploymentKeyNode.asText()).list();
            ArrayList<String> deploymentIds = new ArrayList<String>(deployments.size());
            for (Deployment deployment : deployments) {
                deploymentIds.add(deployment.getId());
            }
            taskInfoQueryWrapper.getTaskInfoQuery().or().deploymentIdIn(deploymentIds).taskCategory(deploymentKeyNode.asText()).endOr();
        }
        if ((processInstanceIdNode = requestNode.get("processInstanceId")) != null && !processInstanceIdNode.isNull()) {
            this.handleProcessInstanceFiltering(currentUser, taskInfoQueryWrapper, processInstanceIdNode);
        }
        if ((textNode = requestNode.get("text")) != null && !textNode.isNull()) {
            this.handleTextFiltering(taskInfoQueryWrapper, textNode);
        }
        if ((assignmentNode = requestNode.get("assignment")) != null && !assignmentNode.isNull()) {
            this.handleAssignment(taskInfoQueryWrapper, assignmentNode, currentUser);
        }
        if ((processDefinitionNode = requestNode.get("processDefinitionId")) != null && !processDefinitionNode.isNull()) {
            this.handleProcessDefinition(taskInfoQueryWrapper, processDefinitionNode);
        }
        if ((dueBeforeNode = requestNode.get("dueBefore")) != null && !dueBeforeNode.isNull()) {
            this.handleDueBefore(taskInfoQueryWrapper, dueBeforeNode);
        }
        if ((dueAfterNode = requestNode.get("dueAfter")) != null && !dueAfterNode.isNull()) {
            this.handleDueAfter(taskInfoQueryWrapper, dueAfterNode);
        }
        if ((sortNode = requestNode.get("sort")) != null) {
            this.handleSorting(taskInfoQueryWrapper, sortNode);
        }
        int page = 0;
        JsonNode pageNode = requestNode.get("page");
        if (pageNode != null && !pageNode.isNull()) {
            page = pageNode.asInt(0);
        }
        int size = 25;
        JsonNode sizeNode = requestNode.get("size");
        if (sizeNode != null && !sizeNode.isNull()) {
            size = sizeNode.asInt(25);
        }
        List tasks = taskInfoQueryWrapper.getTaskInfoQuery().listPage(page * size, size);
        JsonNode includeProcessInstanceNode = requestNode.get("includeProcessInstance");
        HashMap<String, String> processInstancesNames = new HashMap<String, String>();
        if (includeProcessInstanceNode != null) {
            this.handleIncludeProcessInstance(taskInfoQueryWrapper, includeProcessInstanceNode, tasks, processInstancesNames);
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(this.convertTaskInfoList(tasks, processInstancesNames));
        if (page != 0 || tasks.size() == size) {
            Long totalCount = taskInfoQueryWrapper.getTaskInfoQuery().count();
            result.setTotal(Long.valueOf(totalCount.intValue()));
            result.setStart(Integer.valueOf(page * size));
        }
        return result;
    }

    private void handleProcessInstanceFiltering(User currentUser, TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode processInstanceIdNode) {
        String processInstanceId = processInstanceIdNode.asText();
        taskInfoQueryWrapper.getTaskInfoQuery().processInstanceId(processInstanceId);
    }

    private void handleTextFiltering(TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode textNode) {
        String text = textNode.asText();
        taskInfoQueryWrapper.getTaskInfoQuery().taskNameLikeIgnoreCase("%" + text + "%");
    }

    private void handleAssignment(TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode assignmentNode, User currentUser) {
        String assignment = assignmentNode.asText();
        if (assignment.length() > 0) {
            String currentUserId = String.valueOf(currentUser.getId());
            if ("assignee".equals(assignment)) {
                taskInfoQueryWrapper.getTaskInfoQuery().taskAssignee(currentUserId);
            } else if ("candidate".equals(assignment)) {
                taskInfoQueryWrapper.getTaskInfoQuery().taskCandidateUser(currentUserId);
            } else if (assignment.startsWith("group_")) {
                String groupIdString = assignment.replace("group_", "");
                try {
                    Long.valueOf(groupIdString);
                }
                catch (NumberFormatException e) {
                    throw new BadRequestException("Invalid group id");
                }
                taskInfoQueryWrapper.getTaskInfoQuery().taskCandidateGroup(groupIdString);
            } else {
                taskInfoQueryWrapper.getTaskInfoQuery().taskInvolvedUser(currentUserId);
            }
        }
    }

    private void handleProcessDefinition(TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode processDefinitionIdNode) {
        String processDefinitionId = processDefinitionIdNode.asText();
        taskInfoQueryWrapper.getTaskInfoQuery().processDefinitionId(processDefinitionId);
    }

    private void handleDueBefore(TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode dueBeforeNode) {
        String date = dueBeforeNode.asText();
        Date d = ISO8601Utils.parse((String)date);
        taskInfoQueryWrapper.getTaskInfoQuery().taskDueBefore(d);
    }

    private void handleDueAfter(TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode dueAfterNode) {
        String date = dueAfterNode.asText();
        Date d = ISO8601Utils.parse((String)date);
        taskInfoQueryWrapper.getTaskInfoQuery().taskDueAfter(d);
    }

    private void handleSorting(TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode sortNode) {
        String sort = sortNode.asText();
        if (SORT_CREATED_ASC.equals(sort)) {
            taskInfoQueryWrapper.getTaskInfoQuery().orderByTaskCreateTime().asc();
        } else if (SORT_CREATED_DESC.equals(sort)) {
            taskInfoQueryWrapper.getTaskInfoQuery().orderByTaskCreateTime().desc();
        } else if (SORT_DUE_ASC.equals(sort)) {
            taskInfoQueryWrapper.getTaskInfoQuery().orderByDueDateNullsLast().asc();
        } else if (SORT_DUE_DESC.equals(sort)) {
            taskInfoQueryWrapper.getTaskInfoQuery().orderByDueDateNullsLast().desc();
        } else {
            taskInfoQueryWrapper.getTaskInfoQuery().orderByTaskCreateTime().desc();
        }
    }

    private void handleIncludeProcessInstance(TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode includeProcessInstanceNode, List<? extends TaskInfo> tasks, Map<String, String> processInstanceNames) {
        block6: {
            if (!includeProcessInstanceNode.asBoolean() || !CollectionUtils.isNotEmpty(tasks)) break block6;
            HashSet<String> processInstanceIds = new HashSet<String>();
            for (TaskInfo taskInfo : tasks) {
                if (taskInfo.getProcessInstanceId() == null) continue;
                processInstanceIds.add(taskInfo.getProcessInstanceId());
            }
            if (CollectionUtils.isNotEmpty(processInstanceIds)) {
                List processInstances;
                if (taskInfoQueryWrapper.getTaskInfoQuery() instanceof HistoricTaskInstanceQuery) {
                    processInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(processInstanceIds).list();
                    for (HistoricProcessInstance processInstance : processInstances) {
                        processInstanceNames.put(processInstance.getId(), processInstance.getName());
                    }
                } else {
                    processInstances = this.runtimeService.createProcessInstanceQuery().processInstanceIds(processInstanceIds).list();
                    for (ProcessInstance processInstance : processInstances) {
                        processInstanceNames.put(processInstance.getId(), processInstance.getName());
                    }
                }
            }
        }
    }

    protected List<TaskRepresentation> convertTaskInfoList(List<? extends TaskInfo> tasks, Map<String, String> processInstanceNames) {
        ArrayList<TaskRepresentation> result = new ArrayList<TaskRepresentation>();
        if (CollectionUtils.isNotEmpty(tasks)) {
            for (TaskInfo taskInfo : tasks) {
                UserCache.CachedUser cachedUser;
                ProcessDefinitionEntity processDefinition = null;
                if (taskInfo.getProcessDefinitionId() != null) {
                    processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(taskInfo.getProcessDefinitionId());
                }
                TaskRepresentation representation = new TaskRepresentation(taskInfo, (ProcessDefinition)processDefinition, processInstanceNames.get(taskInfo.getProcessInstanceId()));
                if (StringUtils.isNotEmpty((CharSequence)taskInfo.getAssignee()) && (cachedUser = this.userCache.getUser(taskInfo.getAssignee())) != null && cachedUser.getUser() != null) {
                    User assignee = cachedUser.getUser();
                    representation.setAssignee(new UserRepresentation(assignee));
                }
                result.add(representation);
            }
        }
        return result;
    }
}

