/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.idm.UserRepresentation;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.engine.task.IdentityLink;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractWorkflowUsersResource {
    private static final int MAX_PEOPLE_SIZE = 50;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;

    public ResultListDataRepresentation getUsers(String filter, String email, String excludeTaskId, String excludeProcessId, Long groupId) {
        int page = 0;
        int pageSize = 50;
        UserQuery userQuery = this.identityService.createUserQuery();
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            userQuery.userFullNameLike("%" + filter + "%");
        }
        List matchingUsers = userQuery.listPage(page, pageSize);
        if (excludeTaskId != null) {
            this.filterUsersInvolvedInTask(excludeTaskId, matchingUsers);
        } else if (excludeProcessId != null) {
            this.filterUsersInvolvedInProcess(excludeProcessId, matchingUsers);
        }
        ArrayList<UserRepresentation> userRepresentations = new ArrayList<UserRepresentation>(matchingUsers.size());
        for (User user : matchingUsers) {
            userRepresentations.add(new UserRepresentation(user));
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(userRepresentations);
        if (page != 0 || page == 0 && matchingUsers.size() == pageSize) {
            result.setTotal(Long.valueOf(userQuery.count()));
        }
        return result;
    }

    protected void filterUsersInvolvedInProcess(String excludeProcessId, List<User> matchingUsers) {
        Set<String> involvedUsers = this.getInvolvedUsersAsSet(this.runtimeService.getIdentityLinksForProcessInstance(excludeProcessId));
        this.removeinvolvedUsers(matchingUsers, involvedUsers);
    }

    protected void filterUsersInvolvedInTask(String excludeTaskId, List<User> matchingUsers) {
        Set<String> involvedUsers = this.getInvolvedUsersAsSet(this.taskService.getIdentityLinksForTask(excludeTaskId));
        this.removeinvolvedUsers(matchingUsers, involvedUsers);
    }

    protected Set<String> getInvolvedUsersAsSet(List<IdentityLink> involvedPeople) {
        HashSet<String> involved = null;
        if (involvedPeople.size() > 0) {
            involved = new HashSet<String>();
            for (IdentityLink link : involvedPeople) {
                if (link.getUserId() == null) continue;
                involved.add(link.getUserId());
            }
        }
        return involved;
    }

    protected void removeinvolvedUsers(List<User> matchingUsers, Set<String> involvedUsers) {
        if (involvedUsers != null) {
            Iterator<User> userIt = matchingUsers.iterator();
            while (userIt.hasNext()) {
                if (!involvedUsers.contains(userIt.next().getId().toString())) continue;
                userIt.remove();
            }
        }
    }
}

