/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.inject.Inject;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.runtime.AppDefinitionRepresentation;
import org.activiti.app.rest.runtime.AbstractAppDefinitionsResource;
import org.activiti.app.service.exception.NotFoundException;
import org.activiti.app.service.runtime.PermissionService;
import org.activiti.engine.repository.Deployment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AppDefinitionsResource
extends AbstractAppDefinitionsResource {
    private final Logger logger = LoggerFactory.getLogger(AppDefinitionsResource.class);
    @Inject
    protected ObjectMapper objectMapper;
    @Inject
    protected PermissionService permissionService;

    @Override
    @RequestMapping(value={"/rest/runtime/app-definitions"}, method={RequestMethod.GET})
    public ResultListDataRepresentation getAppDefinitions() {
        return super.getAppDefinitions();
    }

    @RequestMapping(value={"/rest/runtime/app-definitions/{deploymentKey}"}, method={RequestMethod.GET})
    public AppDefinitionRepresentation getAppDefinition(@PathVariable(value="deploymentKey") String deploymentKey) {
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentKey(deploymentKey).latest().singleResult();
        if (deployment == null) {
            throw new NotFoundException("No app definition is found with key: " + deploymentKey);
        }
        return this.createRepresentation(deployment);
    }
}

