/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletResponse;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.runtime.RelatedContentRepresentation;
import org.activiti.app.rest.runtime.AbstractRelatedContentResource;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class RelatedContentResource
extends AbstractRelatedContentResource {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRelatedContentResource.class);
    protected ObjectMapper objectMapper = new ObjectMapper();

    @Override
    @RequestMapping(value={"/rest/tasks/{taskId}/content"}, method={RequestMethod.GET})
    public ResultListDataRepresentation getRelatedContentForTask(@PathVariable(value="taskId") String taskId) {
        return super.getRelatedContentForTask(taskId);
    }

    @Override
    @RequestMapping(value={"/rest/process-instances/{processInstanceId}/content"}, method={RequestMethod.GET})
    public ResultListDataRepresentation getRelatedContentForProcessInstance(@PathVariable(value="processInstanceId") String processInstanceId) {
        return super.getRelatedContentForProcessInstance(processInstanceId);
    }

    @Override
    @RequestMapping(value={"/rest/content/{source}/{sourceId}/process-instances"}, method={RequestMethod.GET})
    public ResultListDataRepresentation getRelatedProcessInstancesForContent(@PathVariable(value="source") String source, @PathVariable(value="sourceId") String sourceId) {
        return super.getRelatedProcessInstancesForContent(source, sourceId);
    }

    @Override
    @RequestMapping(value={"/rest/tasks/{taskId}/raw-content"}, method={RequestMethod.POST})
    public RelatedContentRepresentation createRelatedContentOnTask(@PathVariable(value="taskId") String taskId, @RequestParam(value="file") MultipartFile file) {
        return super.createRelatedContentOnTask(taskId, file);
    }

    @RequestMapping(value={"/rest/tasks/{taskId}/raw-content/text"}, method={RequestMethod.POST})
    public String createRelatedContentOnTaskText(@PathVariable(value="taskId") String taskId, @RequestParam(value="file") MultipartFile file) {
        RelatedContentRepresentation relatedContentRepresentation = super.createRelatedContentOnTask(taskId, file);
        String relatedContentJson = null;
        try {
            relatedContentJson = this.objectMapper.writeValueAsString((Object)relatedContentRepresentation);
        }
        catch (Exception e) {
            logger.error("Error while processing RelatedContent representation json", (Throwable)e);
            throw new InternalServerErrorException("Related Content on task could not be saved");
        }
        return relatedContentJson;
    }

    @Override
    @RequestMapping(value={"/rest/tasks/{taskId}/content"}, method={RequestMethod.POST})
    public RelatedContentRepresentation createRelatedContentOnTask(@PathVariable(value="taskId") String taskId, @RequestBody RelatedContentRepresentation relatedContent) {
        return super.createRelatedContentOnTask(taskId, relatedContent);
    }

    @Override
    @RequestMapping(value={"/rest/processes/{processInstanceId}/content"}, method={RequestMethod.POST})
    public RelatedContentRepresentation createRelatedContentOnProcessInstance(@PathVariable(value="processInstanceId") String processInstanceId, @RequestBody RelatedContentRepresentation relatedContent) {
        return super.createRelatedContentOnProcessInstance(processInstanceId, relatedContent);
    }

    @Override
    @RequestMapping(value={"/rest/process-instances/{processInstanceId}/raw-content"}, method={RequestMethod.POST})
    public RelatedContentRepresentation createRelatedContentOnProcessInstance(@PathVariable(value="processInstanceId") String processInstanceId, @RequestParam(value="file") MultipartFile file) {
        return super.createRelatedContentOnProcessInstance(processInstanceId, file);
    }

    @RequestMapping(value={"/rest/process-instances/{processInstanceId}/raw-content/text"}, method={RequestMethod.POST})
    public String createRelatedContentOnProcessInstanceText(@PathVariable(value="processInstanceId") String processInstanceId, @RequestParam(value="file") MultipartFile file) {
        RelatedContentRepresentation relatedContentRepresentation = super.createRelatedContentOnProcessInstance(processInstanceId, file);
        String relatedContentJson = null;
        try {
            relatedContentJson = this.objectMapper.writeValueAsString((Object)relatedContentRepresentation);
        }
        catch (Exception e) {
            logger.error("Error while processing RelatedContent representation json", (Throwable)e);
            throw new InternalServerErrorException("Related Content on process instance could not be saved");
        }
        return relatedContentJson;
    }

    @Override
    @RequestMapping(value={"/rest/content/raw"}, method={RequestMethod.POST})
    public RelatedContentRepresentation createTemporaryRawRelatedContent(@RequestParam(value="file") MultipartFile file) {
        return super.createTemporaryRawRelatedContent(file);
    }

    @RequestMapping(value={"/rest/content/raw/text"}, method={RequestMethod.POST})
    public String createTemporaryRawRelatedContentText(@RequestParam(value="file") MultipartFile file) {
        RelatedContentRepresentation relatedContentRepresentation = super.createTemporaryRawRelatedContent(file);
        String relatedContentJson = null;
        try {
            relatedContentJson = this.objectMapper.writeValueAsString((Object)relatedContentRepresentation);
        }
        catch (Exception e) {
            logger.error("Error while processing RelatedContent representation json", (Throwable)e);
            throw new InternalServerErrorException("Related Content could not be saved");
        }
        return relatedContentJson;
    }

    @Override
    @RequestMapping(value={"/rest/content"}, method={RequestMethod.POST})
    public RelatedContentRepresentation createTemporaryRelatedContent(@RequestBody RelatedContentRepresentation relatedContent) {
        return this.addRelatedContent(relatedContent, null, null, false);
    }

    @Override
    @RequestMapping(value={"/rest/content/{contentId}"}, method={RequestMethod.DELETE})
    public void deleteContent(@PathVariable(value="contentId") Long contentId, HttpServletResponse response) {
        super.deleteContent(contentId, response);
    }

    @Override
    @RequestMapping(value={"/rest/content/{contentId}"}, method={RequestMethod.GET})
    public RelatedContentRepresentation getContent(@PathVariable(value="contentId") Long contentId) {
        return super.getContent(contentId);
    }

    @Override
    @RequestMapping(value={"/rest/content/{contentId}/raw"}, method={RequestMethod.GET})
    public void getRawContent(@PathVariable(value="contentId") Long contentId, HttpServletResponse response) {
        super.getRawContent(contentId, response);
    }
}

